/*
 * Decompiled with CFR 0.152.
 */
package net.consensys.cava.devp2p;

import com.google.common.base.Preconditions;
import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import net.consensys.cava.bytes.Bytes;
import net.consensys.cava.rlp.RLP;
import net.consensys.cava.rlp.RLPReader;
import net.consensys.cava.rlp.RLPWriter;

public final class Endpoint {
    public static final int DEFAULT_PORT = 30303;
    private final String host;
    private final int udpPort;
    private final int tcpPort;

    public Endpoint(String host, int udpPort, int tcpPort) {
        Preconditions.checkArgument((host != null && InetAddresses.isInetAddress((String)host) ? 1 : 0) != 0, (Object)"host requires a valid IP address");
        Preconditions.checkArgument((udpPort > 0 && udpPort < 65536 ? 1 : 0) != 0, (Object)"UDP port requires a value between 1 and 65535");
        Preconditions.checkArgument((tcpPort > 0 && tcpPort < 65536 ? 1 : 0) != 0, (Object)"TCP port requires a value between 1 and 65535");
        this.host = host;
        this.udpPort = udpPort;
        this.tcpPort = tcpPort;
    }

    public String host() {
        return this.host;
    }

    public int udpPort() {
        return this.udpPort;
    }

    public int tcpPort() {
        return this.tcpPort;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Endpoint)) {
            return false;
        }
        Endpoint other = (Endpoint)obj;
        return this.host.equals(other.host) && this.udpPort == other.udpPort && this.tcpPort == other.tcpPort;
    }

    public int hashCode() {
        return Objects.hash(this.host, this.udpPort, this.tcpPort);
    }

    public String toString() {
        return "Endpoint{host='" + this.host + '\'' + ", udpPort=" + this.udpPort + ", tcpPort=" + this.tcpPort + '}';
    }

    public Bytes toBytes() {
        return RLP.encodeList(this::write);
    }

    void write(RLPWriter writer) {
        writer.writeValue(Bytes.of((byte[])InetAddresses.forString((String)this.host).getAddress()));
        writer.writeInt(this.udpPort);
        writer.writeInt(this.tcpPort);
    }

    public static Endpoint readFrom(RLPReader reader) {
        return (Endpoint)reader.readList(Endpoint::read);
    }

    public static Endpoint read(RLPReader reader) {
        int udpPort;
        InetAddress addr;
        try {
            addr = InetAddress.getByAddress(reader.readValue().toArrayUnsafe());
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
        int tcpPort = udpPort = reader.readInt();
        if (!reader.isComplete()) {
            tcpPort = reader.readInt();
        }
        return new Endpoint(addr.getHostAddress(), udpPort, tcpPort);
    }
}

