/*
 * Decompiled with CFR 0.152.
 */
package net.consensys.cava.devp2p;

import com.google.common.base.Objects;
import net.consensys.cava.bytes.Bytes;
import net.consensys.cava.devp2p.Payload;
import net.consensys.cava.rlp.RLP;

final class FindNeighborsPayload
extends Payload {
    private final Bytes target;

    static FindNeighborsPayload decode(Bytes payloadBytes) {
        return (FindNeighborsPayload)RLP.decodeList((Bytes)payloadBytes, listReader -> {
            Bytes target = listReader.readValue();
            long expiration = listReader.readLong();
            return new FindNeighborsPayload(target, expiration);
        });
    }

    FindNeighborsPayload(Bytes target, long expiration) {
        super(expiration);
        this.target = target;
    }

    public Bytes target() {
        return this.target;
    }

    @Override
    public Bytes createPayloadBytes() {
        return RLP.encodeList(writer -> {
            writer.writeValue(this.target);
            writer.writeLong(this.expiration());
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FindNeighborsPayload)) {
            return false;
        }
        FindNeighborsPayload that = (FindNeighborsPayload)o;
        return this.expiration() == that.expiration() && Objects.equal((Object)this.target, (Object)that.target);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.target, this.expiration()});
    }

    public String toString() {
        return "FindNeighborsPayload{target=" + this.target + '}';
    }
}

