/*
 * Decompiled with CFR 0.152.
 */
package net.consensys.cava.devp2p;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.consensys.cava.bytes.Bytes;
import net.consensys.cava.devp2p.Endpoint;
import net.consensys.cava.devp2p.Payload;
import net.consensys.cava.rlp.RLP;

final class NeighborsPayload
extends Payload {
    private final List<Neighbor> neighbors;

    static NeighborsPayload decode(Bytes payloadBytes) {
        return (NeighborsPayload)RLP.decodeList((Bytes)payloadBytes, reader -> {
            List neighbors = (List)reader.readList(neighborsReader -> {
                ArrayList<Neighbor> list = new ArrayList<Neighbor>();
                while (!neighborsReader.isComplete()) {
                    Endpoint endpoint = (Endpoint)neighborsReader.readList(Endpoint::read);
                    Bytes nodeId = neighborsReader.readValue();
                    list.add(new Neighbor(nodeId, endpoint));
                }
                return list;
            });
            long expiration = reader.readLong();
            return new NeighborsPayload(neighbors, expiration);
        });
    }

    NeighborsPayload(List<Neighbor> neighbors, long expiration) {
        super(expiration);
        this.neighbors = neighbors;
    }

    public List<Neighbor> neighbors() {
        return this.neighbors;
    }

    @Override
    public Bytes createPayloadBytes() {
        return RLP.encodeList(rlpWriter -> {
            rlpWriter.writeList(neighborWriter -> this.neighbors.forEach(neighbor -> {
                neighborWriter.writeList(neighbor.endpoint()::write);
                neighborWriter.writeValue(neighbor.nodeId());
            }));
            rlpWriter.writeLong(this.expiration());
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NeighborsPayload)) {
            return false;
        }
        NeighborsPayload that = (NeighborsPayload)o;
        return this.expiration() == that.expiration() && Objects.equals(this.neighbors, that.neighbors);
    }

    public int hashCode() {
        return Objects.hash(this.neighbors, this.expiration());
    }

    static final class Neighbor {
        private final Bytes nodeId;
        private final Endpoint endpoint;

        Neighbor(Bytes nodeId, Endpoint endpoint) {
            Preconditions.checkArgument((nodeId != null ? 1 : 0) != 0, (Object)"nodeId cannot be null");
            Preconditions.checkArgument((endpoint != null ? 1 : 0) != 0, (Object)"endpoint cannot be null");
            this.nodeId = nodeId;
            this.endpoint = endpoint;
        }

        Bytes nodeId() {
            return this.nodeId;
        }

        Endpoint endpoint() {
            return this.endpoint;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Neighbor)) {
                return false;
            }
            Neighbor other = (Neighbor)obj;
            return this.nodeId.equals(other.nodeId) && this.endpoint.equals(other.endpoint);
        }

        public int hashCode() {
            return Objects.hash(this.nodeId, this.endpoint);
        }

        public String toString() {
            return "Neighbor{nodeId=" + this.nodeId + ", endpoint=" + this.endpoint + '}';
        }
    }
}

