/*
 * Decompiled with CFR 0.152.
 */
package net.consensys.cava.devp2p;

import java.util.List;
import net.consensys.cava.bytes.Bytes;
import net.consensys.cava.crypto.SECP256K1;
import net.consensys.cava.devp2p.Endpoint;
import net.consensys.cava.devp2p.FindNeighborsPayload;
import net.consensys.cava.devp2p.NeighborsPayload;
import net.consensys.cava.devp2p.PacketHeader;
import net.consensys.cava.devp2p.Payload;
import net.consensys.cava.devp2p.PingPayload;
import net.consensys.cava.devp2p.PongPayload;

final class Packet<T extends Payload> {
    private PacketHeader header;
    private final T payload;
    private Bytes bytes;
    private SECP256K1.KeyPair keyPair;
    private byte packetType;

    static Packet<PingPayload> createPing(Endpoint from, Endpoint to, long expiration, SECP256K1.KeyPair keyPair) {
        return new Packet<PingPayload>(new PingPayload(from, to, expiration), keyPair, 1);
    }

    static Packet<PongPayload> createPong(Endpoint to, Bytes pingHash, long expiration, SECP256K1.KeyPair keyPair) {
        return new Packet<PongPayload>(new PongPayload(to, pingHash, expiration), keyPair, 2);
    }

    static Packet<FindNeighborsPayload> createFindNeighbors(Bytes target, long expiration, SECP256K1.KeyPair keyPair) {
        return new Packet<FindNeighborsPayload>(new FindNeighborsPayload(target, expiration), keyPair, 3);
    }

    static Packet<NeighborsPayload> createNeighbors(List<NeighborsPayload.Neighbor> neighbors, long expiration, SECP256K1.KeyPair keyPair) {
        return new Packet<NeighborsPayload>(new NeighborsPayload(neighbors, expiration), keyPair, 4);
    }

    private Packet(T payload, SECP256K1.KeyPair keyPair, byte packetType) {
        this.payload = payload;
        this.keyPair = keyPair;
        this.packetType = packetType;
    }

    Packet(T payload, PacketHeader header) {
        this.payload = payload;
        this.header = header;
    }

    PacketHeader header() {
        PacketHeader header = this.header;
        if (header == null) {
            this.header = header = new PacketHeader(this.keyPair, this.packetType, ((Payload)this.payload).toBytes());
        }
        return header;
    }

    public T payload() {
        return this.payload;
    }

    Bytes toBytes() {
        Bytes packetBytes = this.bytes;
        if (packetBytes == null) {
            this.bytes = packetBytes = Bytes.concatenate((Bytes[])new Bytes[]{this.header().hash(), this.header().signature().bytes(), Bytes.of((byte[])new byte[]{this.header().packetType()}), ((Payload)this.payload).toBytes()});
        }
        return packetBytes;
    }

    public String toString() {
        return "Packet{packetType=" + this.packetType + ", payload=" + this.payload + '}';
    }
}

