/*
 * Decompiled with CFR 0.152.
 */
package net.consensys.cava.devp2p;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import net.consensys.cava.bytes.Bytes;
import net.consensys.cava.bytes.Bytes32;
import net.consensys.cava.crypto.Hash;
import net.consensys.cava.crypto.SECP256K1;
import net.consensys.cava.devp2p.PeerDiscoveryPacketDecodingException;

final class PacketHeader {
    private final Bytes hash;
    private final SECP256K1.PublicKey publicKey;
    private final SECP256K1.Signature signature;
    private final byte packetType;

    static PacketHeader decode(Bytes data) {
        SECP256K1.Signature signature;
        Bytes hash = data.slice(0, 32);
        Bytes encodedSignature = data.slice(32, 65);
        try {
            signature = SECP256K1.Signature.fromBytes((Bytes)encodedSignature);
        }
        catch (IllegalArgumentException e) {
            throw new PeerDiscoveryPacketDecodingException("Could not retrieve the public key from the signature and signed data");
        }
        Bytes signedPayload = data.slice(97, data.size() - 97);
        byte typeByte = data.get(97);
        Bytes payloadBytes = data.slice(98);
        SECP256K1.PublicKey publicKey = SECP256K1.PublicKey.recoverFromSignature((Bytes)signedPayload, (SECP256K1.Signature)signature);
        if (publicKey == null) {
            throw new PeerDiscoveryPacketDecodingException("Could not retrieve the public key from the signature and signed data");
        }
        Bytes32 computedHash = Hash.sha3_256((Bytes)Bytes.wrap((Bytes[])new Bytes[]{Bytes.wrap((Bytes[])new Bytes[]{signature.bytes(), Bytes.of((byte[])new byte[]{typeByte})}), payloadBytes}));
        if (!computedHash.equals(hash)) {
            throw new PeerDiscoveryPacketDecodingException("Hash does not match content");
        }
        return new PacketHeader(hash, publicKey, signature, typeByte);
    }

    PacketHeader(SECP256K1.KeyPair keyPair, byte packetType, Bytes payload) {
        Preconditions.checkArgument((keyPair != null ? 1 : 0) != 0, (Object)"keyPair cannot be null");
        Preconditions.checkArgument((payload != null ? 1 : 0) != 0, (Object)"payload cannot be null");
        Bytes typeBytes = Bytes.of((byte[])new byte[]{packetType});
        this.packetType = packetType;
        this.signature = SECP256K1.sign((Bytes)Bytes.wrap((Bytes[])new Bytes[]{typeBytes, payload}), (SECP256K1.KeyPair)keyPair);
        this.hash = Hash.sha3_256((Bytes)Bytes.wrap((Bytes[])new Bytes[]{this.signature.bytes(), typeBytes, payload}));
        this.publicKey = keyPair.publicKey();
    }

    PacketHeader(Bytes hash, SECP256K1.PublicKey publicKey, SECP256K1.Signature signature, byte packetType) {
        Preconditions.checkArgument((hash != null ? 1 : 0) != 0, (Object)"hash cannot be null");
        Preconditions.checkArgument((hash.size() == 32 ? 1 : 0) != 0, (Object)String.format("hash should be 32 bytes long, got %s instead", hash.size()));
        Preconditions.checkArgument((publicKey != null ? 1 : 0) != 0, (Object)"publicKey cannot be null");
        Preconditions.checkArgument((signature != null ? 1 : 0) != 0, (Object)"signature cannot be null");
        this.hash = hash;
        this.publicKey = publicKey;
        this.signature = signature;
        this.packetType = packetType;
    }

    Bytes hash() {
        return this.hash;
    }

    Bytes nodeId() {
        return this.publicKey.bytes();
    }

    byte packetType() {
        return this.packetType;
    }

    SECP256K1.Signature signature() {
        return this.signature;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PacketHeader)) {
            return false;
        }
        PacketHeader that = (PacketHeader)o;
        return this.packetType == that.packetType && Objects.equal((Object)this.hash, (Object)that.hash) && Objects.equal((Object)this.publicKey, (Object)that.publicKey) && Objects.equal((Object)this.signature, (Object)that.signature);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.hash, this.publicKey, this.signature, this.packetType});
    }
}

