/*
 * Decompiled with CFR 0.152.
 */
package net.consensys.cava.devp2p;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.time.Instant;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.consensys.cava.bytes.Bytes;
import net.consensys.cava.concurrent.ExpiringMap;
import net.consensys.cava.crypto.SECP256K1;
import net.consensys.cava.devp2p.Endpoint;
import net.consensys.cava.devp2p.FindNeighborsPayload;
import net.consensys.cava.devp2p.NeighborsPayload;
import net.consensys.cava.devp2p.Packet;
import net.consensys.cava.devp2p.PacketHeader;
import net.consensys.cava.devp2p.Peer;
import net.consensys.cava.devp2p.PeerDiscoveryPacketDecodingException;
import net.consensys.cava.devp2p.PeerRepository;
import net.consensys.cava.devp2p.PeerRoutingTable;
import net.consensys.cava.devp2p.PingPayload;
import net.consensys.cava.devp2p.PongPayload;

final class PeerLifecycleManager {
    private static final long PONG_EXPIRATION = 60000L;
    private static final long EXPIRATION_PERIOD_MS = 3000L;
    private static final int MAX_NUMBER_OF_NEIGHBORS = 5;
    private final ExpiringMap<Bytes, Bytes> awaitingPongs = new ExpiringMap();
    private final PeerRepository peerRepository;
    private final LongSupplier currentTimeSupplier;
    private final BiConsumer<Endpoint, Packet<?>> packetSender;
    private final SECP256K1.KeyPair keyPair;
    private final Endpoint endpoint;
    private final PeerRoutingTable peerRoutingTable;

    PeerLifecycleManager(PeerRepository peerRepository, List<String> bootstrapPeers, SECP256K1.KeyPair keyPair, BiConsumer<Endpoint, Packet<?>> packetSender, Endpoint endpoint, PeerRoutingTable peerRoutingTable, LongSupplier currentTimeSupplier) {
        Preconditions.checkArgument((peerRepository != null ? 1 : 0) != 0);
        Preconditions.checkArgument((bootstrapPeers != null && !bootstrapPeers.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((keyPair != null ? 1 : 0) != 0);
        Preconditions.checkArgument((peerRoutingTable != null ? 1 : 0) != 0);
        Preconditions.checkArgument((currentTimeSupplier != null ? 1 : 0) != 0);
        Preconditions.checkArgument((packetSender != null ? 1 : 0) != 0);
        this.currentTimeSupplier = currentTimeSupplier;
        this.keyPair = keyPair;
        this.packetSender = packetSender;
        this.endpoint = endpoint;
        this.peerRepository = peerRepository;
        this.peerRoutingTable = peerRoutingTable;
        peerRepository.observePeerActive(this::peerActive);
        peerRepository.observePeerAddition(this::peerAddition);
        for (String peer : bootstrapPeers) {
            peerRepository.get(peer);
        }
    }

    private void peerActive(Peer peer) {
        long now = this.currentTimeSupplier.getAsLong();
        Endpoint to = peer.endpoint().get();
        Packet<FindNeighborsPayload> findNeighbors = Packet.createFindNeighbors(peer.nodeId(), now + 3000L, this.keyPair);
        this.packetSender.accept(to, findNeighbors);
    }

    private void peerAddition(Peer peer) {
        if (!peer.endpoint().isPresent() || peer.endpoint().get().equals(this.endpoint)) {
            return;
        }
        long now = this.currentTimeSupplier.getAsLong();
        Endpoint to = peer.endpoint().get();
        this.peerRoutingTable.add(peer);
        Packet<PingPayload> pingPacket = Packet.createPing(this.endpoint, to, now + 3000L, this.keyPair);
        this.awaitingPongs.put((Object)pingPacket.header().hash(), (Object)peer.nodeId(), Instant.ofEpochMilli(now + 60000L).toEpochMilli());
        this.packetSender.accept(to, pingPacket);
    }

    @VisibleForTesting
    void handleFindNeighbors(Packet<FindNeighborsPayload> findNeighborsPayloadPacket) {
        Peer peer = this.peerRepository.get(findNeighborsPayloadPacket.header().nodeId());
        if (peer.endpoint().isPresent() && peer.isActive()) {
            peer.updateLastSeen();
            Stream<Peer> peerStream = this.peerRoutingTable.nearest(findNeighborsPayloadPacket.payload().target());
            long now = this.currentTimeSupplier.getAsLong();
            Packet<NeighborsPayload> neighborsPacket = Packet.createNeighbors(peerStream.limit(5L).map(p -> new NeighborsPayload.Neighbor(p.nodeId(), p.endpoint().get())).collect(Collectors.toList()), now + 3000L, this.keyPair);
            this.packetSender.accept(peer.endpoint().get(), neighborsPacket);
        }
    }

    @VisibleForTesting
    void handleNeighbors(Packet<NeighborsPayload> neighborsPayloadPacket) {
        Peer peer = this.peerRepository.get(neighborsPayloadPacket.header().nodeId());
        if (peer.endpoint().isPresent() && peer.isActive()) {
            peer.updateLastSeen();
            for (NeighborsPayload.Neighbor neighbor : neighborsPayloadPacket.payload().neighbors()) {
                this.peerRepository.get(neighbor.nodeId(), neighbor.endpoint());
            }
        }
    }

    @VisibleForTesting
    void handlePing(Packet<PingPayload> ping) {
        Peer peer = this.peerRepository.get(ping.header().nodeId(), ping.payload().from());
        peer.updateLastSeen();
        peer.endpoint().ifPresent(to -> {
            long now = this.currentTimeSupplier.getAsLong();
            this.packetSender.accept((Endpoint)to, Packet.createPong(to, ping.header().hash(), now + 3000L, this.keyPair));
        });
    }

    @VisibleForTesting
    void handlePong(Packet<PongPayload> pong) {
        if (this.awaitingPongs.remove((Object)pong.payload().pingHash(), (Object)pong.header().nodeId())) {
            Peer peer = this.peerRepository.get(pong.header().nodeId());
            peer.updateLastSeen();
            peer.endpoint().ifPresent(to -> {
                if (this.peerRoutingTable.contains(peer)) {
                    peer.setActive((Endpoint)to);
                }
            });
        }
    }

    void receivePacket(Bytes data) {
        PacketHeader header = PacketHeader.decode(data);
        Bytes payloadBytes = data.slice(98);
        switch (header.packetType()) {
            case 1: {
                this.handlePing(new Packet<PingPayload>(PingPayload.decode(payloadBytes), header));
                break;
            }
            case 2: {
                this.handlePong(new Packet<PongPayload>(PongPayload.decode(payloadBytes), header));
                break;
            }
            case 3: {
                this.handleFindNeighbors(new Packet<FindNeighborsPayload>(FindNeighborsPayload.decode(payloadBytes), header));
                break;
            }
            case 4: {
                this.handleNeighbors(new Packet<NeighborsPayload>(NeighborsPayload.decode(payloadBytes), header));
                break;
            }
            default: {
                throw new PeerDiscoveryPacketDecodingException(String.format("Invalid packet type %02X", header.packetType()));
            }
        }
    }
}

