/*
 * Decompiled with CFR 0.152.
 */
package net.consensys.cava.devp2p;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.consensys.cava.bytes.Bytes;
import net.consensys.cava.devp2p.Endpoint;
import net.consensys.cava.devp2p.Peer;

public final class PeerRepository {
    private static final Pattern DISCPORT_QUERY_STRING_REGEX = Pattern.compile(".*discport=([^&]+).*");
    private final Supplier<Instant> currentTimeSupplier;
    private final ConcurrentHashMap<Bytes, RepositoryPeer> peers = new ConcurrentHashMap();
    private final Set<Consumer<Peer>> peerActiveObservers = ConcurrentHashMap.newKeySet();
    private final Set<Consumer<Peer>> peerInactiveObservers = ConcurrentHashMap.newKeySet();
    private final Set<BiConsumer<Set<String>, Peer>> peerCapabilityObservers = ConcurrentHashMap.newKeySet();
    private final Set<Consumer<Peer>> peerAdditionObservers = ConcurrentHashMap.newKeySet();

    public PeerRepository() {
        this(Instant::now);
    }

    PeerRepository(Supplier<Instant> currentTimeSupplier) {
        this.currentTimeSupplier = currentTimeSupplier;
    }

    public Peer get(Bytes nodeId) {
        return this.peers.computeIfAbsent(nodeId, x$0 -> new RepositoryPeer((Bytes)x$0));
    }

    public Peer get(Bytes nodeId, Endpoint endpoint) {
        return this.peers.compute(nodeId, (id, peer) -> {
            if (peer == null) {
                return new RepositoryPeer((Bytes)id, endpoint);
            }
            peer.updateEndpointIfInactive(endpoint);
            return peer;
        });
    }

    public Peer get(String uri) {
        return this.get(URI.create(uri));
    }

    public Peer get(URI uri) {
        Matcher matcher;
        Preconditions.checkNotNull((Object)uri);
        Preconditions.checkArgument((boolean)"enode".equals(uri.getScheme()));
        Preconditions.checkArgument((uri.getUserInfo() != null ? 1 : 0) != 0, (Object)"URI does not have a nodeId");
        Bytes nodeId = Bytes.fromHexString((CharSequence)uri.getUserInfo());
        int tcpPort = 30303;
        if (uri.getPort() >= 0) {
            tcpPort = uri.getPort();
        }
        int udpPort = tcpPort;
        String query = uri.getQuery();
        if (query != null && (matcher = DISCPORT_QUERY_STRING_REGEX.matcher(query)).matches()) {
            try {
                udpPort = Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid discport query parameter");
            }
        }
        Endpoint endpoint = new Endpoint(uri.getHost(), udpPort, tcpPort);
        return this.get(nodeId, endpoint);
    }

    public boolean observePeerAddition(Consumer<Peer> fn) {
        return this.peerAdditionObservers.add(fn);
    }

    public boolean unObservePeerAddition(Consumer<Peer> fn) {
        return this.peerAdditionObservers.remove(fn);
    }

    public boolean observePeerActive(Consumer<Peer> fn) {
        return this.peerActiveObservers.add(fn);
    }

    public boolean unObservePeerActive(Consumer<Peer> fn) {
        return this.peerActiveObservers.remove(fn);
    }

    public boolean observePeerInactive(Consumer<Peer> fn) {
        return this.peerInactiveObservers.add(fn);
    }

    public boolean unObservePeerInactive(Consumer<Peer> fn) {
        return this.peerInactiveObservers.remove(fn);
    }

    public boolean observePeerCapabilities(BiConsumer<Set<String>, Peer> fn) {
        return this.peerCapabilityObservers.add(fn);
    }

    public boolean unObservePeerCapabilities(BiConsumer<Set<String>, Peer> fn) {
        return this.peerCapabilityObservers.remove(fn);
    }

    private final class RepositoryPeer
    implements Peer {
        private final Bytes nodeId;
        private boolean active;
        private Optional<Endpoint> endpoint;
        private Set<String> capabilities = Collections.emptySet();
        private Optional<Instant> lastSeen = Optional.empty();

        RepositoryPeer(Bytes nodeId) {
            this(nodeId, Optional.empty());
        }

        RepositoryPeer(Bytes nodeId, Endpoint endpoint) {
            this(nodeId, Optional.of(endpoint));
        }

        RepositoryPeer(Bytes nodeId, Optional<Endpoint> optionalEndpoint) {
            this.nodeId = nodeId;
            this.endpoint = optionalEndpoint;
            PeerRepository.this.peerAdditionObservers.forEach(o -> o.accept(this));
        }

        @Override
        public Bytes nodeId() {
            return this.nodeId;
        }

        @Override
        public Optional<Endpoint> endpoint() {
            return this.endpoint;
        }

        @Override
        public boolean isActive() {
            return this.active;
        }

        @Override
        public boolean hasCapability(String capability) {
            return this.capabilities.contains(capability);
        }

        @Override
        public Set<String> capabilities() {
            return this.capabilities;
        }

        @Override
        public Optional<Instant> lastSeen() {
            return this.lastSeen;
        }

        @Override
        public synchronized void setActive(Endpoint endpoint) {
            if (this.active) {
                return;
            }
            this.active = true;
            this.endpoint = Optional.of(endpoint);
            PeerRepository.this.peerActiveObservers.forEach(o -> o.accept(this));
        }

        @Override
        public synchronized void setInactive() {
            this.active = false;
            PeerRepository.this.peerInactiveObservers.forEach(o -> o.accept(this));
            if (!this.capabilities.isEmpty()) {
                Set<String> oldCapabilities = this.capabilities;
                this.capabilities = Collections.emptySet();
                PeerRepository.this.peerCapabilityObservers.forEach(o -> o.accept(oldCapabilities, this));
            }
        }

        @Override
        public synchronized void updateEndpointIfInactive(Endpoint endpoint) {
            if (this.active) {
                assert (this.endpoint.isPresent());
                return;
            }
            this.endpoint = Optional.of(endpoint);
        }

        @Override
        public void setCapabilities(String ... capabilities) {
            this.setCapabilities(Arrays.asList(capabilities));
        }

        @Override
        public synchronized void setCapabilities(Collection<String> capabilities) {
            if (!this.active) {
                assert (this.capabilities.isEmpty());
                return;
            }
            Set<String> oldCapabilities = this.capabilities;
            this.capabilities = new HashSet<String>(capabilities);
            PeerRepository.this.peerCapabilityObservers.forEach(o -> o.accept(oldCapabilities, this));
        }

        @Override
        public void updateLastSeen() {
            this.lastSeen = Optional.of((Instant)PeerRepository.this.currentTimeSupplier.get());
        }
    }
}

