/*
 * Decompiled with CFR 0.152.
 */
package net.consensys.cava.devp2p;

import com.google.common.base.Objects;
import net.consensys.cava.bytes.Bytes;
import net.consensys.cava.devp2p.Endpoint;
import net.consensys.cava.devp2p.Payload;
import net.consensys.cava.devp2p.PeerDiscoveryPacketDecodingException;
import net.consensys.cava.rlp.RLP;

final class PingPayload
extends Payload {
    private static final int VERSION = 4;
    private final Endpoint from;
    private final Endpoint to;

    static PingPayload decode(Bytes payloadBytes) {
        return (PingPayload)RLP.decodeList((Bytes)payloadBytes, listReader -> {
            int version = listReader.readInt();
            if (version != 4) {
                throw new PeerDiscoveryPacketDecodingException(String.format("Version mismatch in ping packet. Expected: %s, got: %s.", 4, version));
            }
            Endpoint from = (Endpoint)listReader.readList(Endpoint::read);
            Endpoint to = (Endpoint)listReader.readList(Endpoint::read);
            long expiration = listReader.readLong();
            return new PingPayload(from, to, expiration);
        });
    }

    PingPayload(Endpoint from, Endpoint to, long expiration) {
        super(expiration);
        this.from = from;
        this.to = to;
    }

    @Override
    public Bytes createPayloadBytes() {
        return RLP.encodeList(listWriter -> {
            listWriter.writeInt(4);
            listWriter.writeList(this.from::write);
            listWriter.writeList(this.to::write);
            listWriter.writeLong(this.expiration());
        });
    }

    public Endpoint from() {
        return this.from;
    }

    public Endpoint to() {
        return this.to;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PingPayload)) {
            return false;
        }
        PingPayload that = (PingPayload)o;
        return Objects.equal((Object)this.from, (Object)that.from) && Objects.equal((Object)this.to, (Object)that.to) && this.expiration() == that.expiration();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.from, this.to, this.expiration()});
    }

    public String toString() {
        return "PingPayload{from=" + this.from + ", to=" + this.to + '}';
    }
}

