/*
 * Decompiled with CFR 0.152.
 */
package net.consensys.cava.devp2p;

import com.google.common.base.Objects;
import net.consensys.cava.bytes.Bytes;
import net.consensys.cava.devp2p.Endpoint;
import net.consensys.cava.devp2p.Payload;
import net.consensys.cava.rlp.RLP;

final class PongPayload
extends Payload {
    private final Endpoint to;
    private final Bytes pingHash;

    static PongPayload decode(Bytes payloadBytes) {
        return (PongPayload)RLP.decodeList((Bytes)payloadBytes, listReader -> {
            Endpoint to = Endpoint.readFrom(listReader);
            Bytes pingHash = listReader.readValue();
            long expiration = listReader.readLong();
            return new PongPayload(to, pingHash, expiration);
        });
    }

    PongPayload(Endpoint to, Bytes pingHash, long expiration) {
        super(expiration);
        this.to = to;
        this.pingHash = pingHash;
    }

    public Bytes pingHash() {
        return this.pingHash;
    }

    public Endpoint to() {
        return this.to;
    }

    @Override
    public Bytes createPayloadBytes() {
        return RLP.encodeList(writer -> {
            writer.writeList(this.to::write);
            writer.writeValue(this.pingHash);
            writer.writeLong(this.expiration());
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PongPayload)) {
            return false;
        }
        PongPayload that = (PongPayload)o;
        return Objects.equal((Object)this.to, (Object)that.to) && Objects.equal((Object)this.pingHash, (Object)that.pingHash) && this.expiration() == that.expiration();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.to, this.pingHash, this.expiration()});
    }

    public String toString() {
        return "PongPayload{to=" + this.to + ", pingHash=" + this.pingHash + '}';
    }
}

