/*
 * Decompiled with CFR 0.152.
 */
package net.consensys.cava.devp2p;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.consensys.cava.bytes.Bytes;
import net.consensys.cava.devp2p.Peer;
import net.consensys.cava.devp2p.PeerRoutingTable;

public final class SimplePeerRoutingTable
implements PeerRoutingTable {
    private final Optional<Integer> maxEntries;
    private Set<Peer> peers = new HashSet<Peer>();

    public SimplePeerRoutingTable() {
        this.maxEntries = Optional.empty();
    }

    SimplePeerRoutingTable(int maxEntries) {
        this.maxEntries = Optional.of(maxEntries);
    }

    @Override
    public boolean add(Peer peer) {
        Preconditions.checkArgument((peer != null ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)peer.endpoint().isPresent());
        if (this.maxEntries.orElse(Integer.MAX_VALUE) <= this.peers.size()) {
            return false;
        }
        return this.peers.add(peer);
    }

    @Override
    public boolean contains(Peer peer) {
        return this.peers.contains(peer);
    }

    @Override
    public Stream<Peer> nearest(Bytes target) {
        return this.peers.stream();
    }

    @Override
    public void clear() {
        this.peers.clear();
    }
}

