/*
 * Decompiled with CFR 0.152.
 */
package net.consensys.cava.devp2p;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.datagram.DatagramPacket;
import io.vertx.core.datagram.DatagramSocket;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.vertx.core.net.SocketAddress;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.LongSupplier;
import net.consensys.cava.bytes.Bytes;
import net.consensys.cava.concurrent.AsyncCompletion;
import net.consensys.cava.concurrent.CompletableAsyncCompletion;
import net.consensys.cava.crypto.SECP256K1;
import net.consensys.cava.devp2p.Endpoint;
import net.consensys.cava.devp2p.Packet;
import net.consensys.cava.devp2p.PeerDiscoveryPacketDecodingException;
import net.consensys.cava.devp2p.PeerDiscoveryServiceException;
import net.consensys.cava.devp2p.PeerLifecycleManager;
import net.consensys.cava.devp2p.PeerRepository;
import net.consensys.cava.devp2p.PeerRoutingTable;

public final class VertxDiscoveryService {
    private static final int MAX_PACKET_SIZE_BYTES = 1280;
    private final Vertx vertx;
    private final PeerRoutingTable peerRoutingTable;
    private final PeerRepository peerRepository;
    private final List<String> bootstrapPeers;
    private final InetSocketAddress listenAddress;
    private final SECP256K1.KeyPair keyPair;
    private final LongSupplier timeSupplier;
    private final int wireProtocolPort;
    private PeerLifecycleManager peerLifecycleManager;
    private DatagramSocket socket;

    public VertxDiscoveryService(Vertx vertx, PeerRepository peerRepository, List<String> bootstrapPeers, InetSocketAddress listenAddress, PeerRoutingTable peerRoutingTable, SECP256K1.KeyPair keyPair, int wireProtocolPort, LongSupplier timeSupplier) {
        Preconditions.checkArgument((vertx != null ? 1 : 0) != 0);
        Preconditions.checkArgument((peerRepository != null ? 1 : 0) != 0);
        Preconditions.checkArgument((bootstrapPeers != null ? 1 : 0) != 0);
        Preconditions.checkArgument((!bootstrapPeers.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((listenAddress != null ? 1 : 0) != 0);
        Preconditions.checkArgument((peerRoutingTable != null ? 1 : 0) != 0);
        Preconditions.checkArgument((keyPair != null ? 1 : 0) != 0);
        Preconditions.checkArgument((timeSupplier != null ? 1 : 0) != 0);
        Preconditions.checkArgument((wireProtocolPort > 0 && wireProtocolPort < 65536 ? 1 : 0) != 0);
        this.vertx = vertx;
        this.peerRepository = peerRepository;
        this.bootstrapPeers = bootstrapPeers;
        this.listenAddress = listenAddress;
        this.peerRoutingTable = peerRoutingTable;
        this.keyPair = keyPair;
        this.timeSupplier = timeSupplier;
        this.wireProtocolPort = wireProtocolPort;
    }

    @VisibleForTesting
    void sendPacket(Endpoint to, Packet<?> packet) {
        this.socket.send(Buffer.buffer((byte[])packet.toBytes().toArrayUnsafe()), to.udpPort(), to.host(), ar -> {
            if (ar.failed()) {
                // empty if block
            }
        });
    }

    @VisibleForTesting
    void receivePacket(DatagramPacket datagram) {
        int length = datagram.data().length();
        if (length > 1280) {
            throw new PeerDiscoveryPacketDecodingException(String.format("Packet too large. Actual size (bytes): %s", length));
        }
        this.peerLifecycleManager.receivePacket(Bytes.wrapBuffer((Buffer)datagram.data()));
    }

    private void handlePacketProcessingException(Throwable throwable) {
        if (throwable instanceof PeerDiscoveryPacketDecodingException) {
            return;
        }
    }

    public OptionalInt port() {
        if (this.socket == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(this.socket.localAddress().port());
    }

    public AsyncCompletion start() {
        CompletableAsyncCompletion completion = AsyncCompletion.incomplete();
        int listenPort = this.listenAddress.getPort();
        String listenHost = this.listenAddress.getAddress().getHostAddress();
        this.vertx.createDatagramSocket(new DatagramSocketOptions()).listen(listenPort, listenHost, res -> {
            if (res.failed()) {
                Throwable cause = res.cause();
                if (cause instanceof BindException || cause instanceof SocketException) {
                    cause = new PeerDiscoveryServiceException(String.format("Failed to bind Ethereum P2P UDP listener to %s:%d: %s", listenHost, listenPort, cause.getMessage()));
                }
                completion.completeExceptionally(cause);
                return;
            }
            this.socket = (DatagramSocket)res.result();
            this.socket.exceptionHandler(this::handlePacketProcessingException);
            SocketAddress socketAddress = this.socket.localAddress();
            Endpoint thisEndpoint = new Endpoint(socketAddress.host(), socketAddress.port(), this.wireProtocolPort);
            this.peerLifecycleManager = new PeerLifecycleManager(this.peerRepository, this.bootstrapPeers, this.keyPair, this::sendPacket, thisEndpoint, this.peerRoutingTable, this.timeSupplier);
            this.socket.handler(this::receivePacket);
            completion.complete();
        });
        return completion;
    }

    public AsyncCompletion stop() {
        CompletableAsyncCompletion completion = AsyncCompletion.incomplete();
        this.socket.close(res -> {
            this.socket = null;
            if (res.failed()) {
                completion.completeExceptionally(res.cause());
            } else {
                completion.complete();
            }
        });
        return completion;
    }
}

