/*
 * Decompiled with CFR 0.152.
 */
package net.consensys.cava.devp2p;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.consensys.cava.devp2p.EndpointKt;
import net.consensys.cava.rlp.RLPException;
import net.consensys.cava.rlp.RLPReader;
import net.consensys.cava.rlp.RLPWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 )2\u00020\u0001:\u0001)B%\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007B\u001b\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\b\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\tB#\u0012\u0006\u0010\u0002\u001a\u00020\n\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0018\u001a\u00020\nH\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000fJ.\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\n2\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u001cJ\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020\u0005H\u00d6\u0001J\r\u0010!\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\"J\t\u0010#\u001a\u00020\u0003H\u00d6\u0001J\u0015\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\b(R\u0011\u0010\u0002\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0011\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013\u00a8\u0006*"}, d2={"Lnet/consensys/cava/devp2p/Endpoint;", "", "address", "", "udpPort", "", "tcpPort", "(Ljava/lang/String;ILjava/lang/Integer;)V", "Ljava/net/InetSocketAddress;", "(Ljava/net/InetSocketAddress;Ljava/lang/Integer;)V", "Ljava/net/InetAddress;", "(Ljava/net/InetAddress;ILjava/lang/Integer;)V", "getAddress", "()Ljava/net/InetAddress;", "getTcpPort", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "tcpSocketAddress", "getTcpSocketAddress", "()Ljava/net/InetSocketAddress;", "getUdpPort", "()I", "udpSocketAddress", "getUdpSocketAddress", "component1", "component2", "component3", "copy", "(Ljava/net/InetAddress;ILjava/lang/Integer;)Lnet/consensys/cava/devp2p/Endpoint;", "equals", "", "other", "hashCode", "rlpSize", "rlpSize$devp2p", "toString", "writeTo", "", "writer", "Lnet/consensys/cava/rlp/RLPWriter;", "writeTo$devp2p", "Companion", "devp2p"})
public final class Endpoint {
    @NotNull
    private final InetSocketAddress udpSocketAddress;
    @Nullable
    private final InetSocketAddress tcpSocketAddress;
    @NotNull
    private final InetAddress address;
    private final int udpPort;
    @Nullable
    private final Integer tcpPort;
    public static final int DEFAULT_PORT = 30303;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final InetSocketAddress getUdpSocketAddress() {
        return this.udpSocketAddress;
    }

    @Nullable
    public final InetSocketAddress getTcpSocketAddress() {
        return this.tcpSocketAddress;
    }

    public final void writeTo$devp2p(@NotNull RLPWriter writer) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        writer.writeByteArray(this.address.getAddress());
        writer.writeInt(this.udpPort);
        Integer n = this.tcpPort;
        writer.writeInt(n != null ? n : 0);
    }

    public final int rlpSize$devp2p() {
        return 1 + this.address.getAddress().length + 6;
    }

    @NotNull
    public final InetAddress getAddress() {
        return this.address;
    }

    public final int getUdpPort() {
        return this.udpPort;
    }

    @Nullable
    public final Integer getTcpPort() {
        return this.tcpPort;
    }

    public Endpoint(@NotNull InetAddress address, int udpPort, @Nullable Integer tcpPort) {
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        this.address = address;
        this.udpPort = udpPort;
        this.tcpPort = tcpPort;
        int n = this.udpPort;
        int n2 = n = 1 <= n && 65535 >= n ? 1 : 0;
        if (n == 0) {
            boolean bl = false;
            String string = "udpPort should be between 1 and 65535, got " + this.udpPort;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int n3 = n = this.tcpPort == null || 1 <= (n = this.tcpPort.intValue()) && 65535 >= n ? 1 : 0;
        if (n == 0) {
            boolean bl = false;
            String string = "tcpPort should be between 1 and 65535, got " + this.tcpPort;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.udpSocketAddress = new InetSocketAddress(this.address, this.udpPort);
        this.tcpSocketAddress = this.tcpPort != null ? new InetSocketAddress(this.address, (int)this.tcpPort) : null;
    }

    public /* synthetic */ Endpoint(InetAddress inetAddress, int n, Integer n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = 30303;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        this(inetAddress, n, n2);
    }

    public Endpoint(@NotNull String address, int udpPort, @Nullable Integer tcpPort) {
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        this(EndpointKt.access$parseInetAddress(address), udpPort, tcpPort);
    }

    public /* synthetic */ Endpoint(String string, int n, Integer n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = 30303;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        this(string, n, n2);
    }

    public Endpoint(@NotNull InetSocketAddress address, @Nullable Integer tcpPort) {
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        InetAddress inetAddress = address.getAddress();
        Intrinsics.checkExpressionValueIsNotNull((Object)inetAddress, (String)"address.address");
        this(inetAddress, address.getPort(), tcpPort);
    }

    public /* synthetic */ Endpoint(InetSocketAddress inetSocketAddress, Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        this(inetSocketAddress, n);
    }

    @NotNull
    public final InetAddress component1() {
        return this.address;
    }

    public final int component2() {
        return this.udpPort;
    }

    @Nullable
    public final Integer component3() {
        return this.tcpPort;
    }

    @NotNull
    public final Endpoint copy(@NotNull InetAddress address, int udpPort, @Nullable Integer tcpPort) {
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        return new Endpoint(address, udpPort, tcpPort);
    }

    @NotNull
    public static /* synthetic */ Endpoint copy$default(Endpoint endpoint, InetAddress inetAddress, int n, Integer n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            inetAddress = endpoint.address;
        }
        if ((n3 & 2) != 0) {
            n = endpoint.udpPort;
        }
        if ((n3 & 4) != 0) {
            n2 = endpoint.tcpPort;
        }
        return endpoint.copy(inetAddress, n, n2);
    }

    @NotNull
    public String toString() {
        return "Endpoint(address=" + this.address + ", udpPort=" + this.udpPort + ", tcpPort=" + this.tcpPort + ")";
    }

    public int hashCode() {
        InetAddress inetAddress = this.address;
        Integer n = this.tcpPort;
        return ((inetAddress != null ? ((Object)inetAddress).hashCode() : 0) * 31 + Integer.hashCode(this.udpPort)) * 31 + (n != null ? ((Object)n).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Endpoint)) break block3;
                Endpoint endpoint = (Endpoint)object;
                if (!Intrinsics.areEqual((Object)this.address, (Object)endpoint.address) || !(this.udpPort == endpoint.udpPort) || !Intrinsics.areEqual((Object)this.tcpPort, (Object)endpoint.tcpPort)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lnet/consensys/cava/devp2p/Endpoint$Companion;", "", "()V", "DEFAULT_PORT", "", "readFrom", "Lnet/consensys/cava/devp2p/Endpoint;", "reader", "Lnet/consensys/cava/rlp/RLPReader;", "devp2p"})
    public static final class Companion {
        @NotNull
        public final Endpoint readFrom(@NotNull RLPReader reader) {
            Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
            InetAddress addr = null;
            try {
                InetAddress inetAddress = InetAddress.getByAddress(reader.readValue().toArrayUnsafe());
                Intrinsics.checkExpressionValueIsNotNull((Object)inetAddress, (String)"InetAddress.getByAddress\u2026dValue().toArrayUnsafe())");
                addr = inetAddress;
            }
            catch (UnknownHostException e) {
                throw (Throwable)new RLPException((Throwable)e);
            }
            int udpPort = reader.readInt();
            Integer tcpPort = null;
            if (!reader.isComplete() && (tcpPort = Integer.valueOf(reader.readInt())) == 0) {
                tcpPort = null;
            }
            String string = addr.getHostAddress();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"addr.hostAddress");
            return new Endpoint(string, udpPort, tcpPort);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

