/*
 * Decompiled with CFR 0.152.
 */
package net.consensys.cava.devp2p;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.consensys.cava.bytes.Bytes;
import net.consensys.cava.bytes.Bytes32;
import net.consensys.cava.crypto.SECP256K1;
import net.consensys.cava.devp2p.DecodingException;
import net.consensys.cava.devp2p.NeighborsPacket;
import net.consensys.cava.devp2p.Node;
import net.consensys.cava.devp2p.Packet;
import net.consensys.cava.devp2p.PacketKt;
import net.consensys.cava.devp2p.PacketType;
import net.consensys.cava.devp2p.SigHash;
import net.consensys.cava.rlp.RLP;
import net.consensys.cava.rlp.RLPException;
import net.consensys.cava.rlp.RLPReader;
import net.consensys.cava.rlp.RLPWriter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B5\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lnet/consensys/cava/devp2p/NeighborsPacket;", "Lnet/consensys/cava/devp2p/Packet;", "nodeId", "Lnet/consensys/cava/crypto/SECP256K1$PublicKey;", "signature", "Lnet/consensys/cava/crypto/SECP256K1$Signature;", "hash", "Lnet/consensys/cava/bytes/Bytes32;", "nodes", "", "Lnet/consensys/cava/devp2p/Node;", "expiration", "", "(Lnet/consensys/cava/crypto/SECP256K1$PublicKey;Lnet/consensys/cava/crypto/SECP256K1$Signature;Lnet/consensys/cava/bytes/Bytes32;Ljava/util/List;J)V", "getNodes", "()Ljava/util/List;", "encodeTo", "Ljava/nio/ByteBuffer;", "dst", "Companion", "devp2p"})
public final class NeighborsPacket
extends Packet {
    @NotNull
    private final List<Node> nodes;
    public static final int RLP_MIN_SIZE = 109;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public ByteBuffer encodeTo(@NotNull ByteBuffer dst) {
        Intrinsics.checkParameterIsNotNull((Object)dst, (String)"dst");
        return this.encodeTo(dst, PacketType.NEIGHBORS, (Function1<? super RLPWriter, Unit>)((Function1)new Function1<RLPWriter, Unit>(this){
            final /* synthetic */ NeighborsPacket this$0;

            public final void invoke(@NotNull RLPWriter writer) {
                Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
                net.consensys.cava.devp2p.NeighborsPacket$Companion.access$encodeTo(NeighborsPacket.Companion, writer, this.this$0.getNodes(), this.this$0.getExpiration());
            }
            {
                this.this$0 = neighborsPacket;
                super(1);
            }
        }));
    }

    @NotNull
    public final List<Node> getNodes() {
        return this.nodes;
    }

    private NeighborsPacket(SECP256K1.PublicKey nodeId, SECP256K1.Signature signature, Bytes32 hash, List<Node> nodes, long expiration) {
        super(nodeId, signature, hash, expiration, null);
        this.nodes = nodes;
    }

    public /* synthetic */ NeighborsPacket(SECP256K1.PublicKey nodeId, SECP256K1.Signature signature, Bytes32 hash, List nodes, long expiration, DefaultConstructorMarker $constructor_marker) {
        this(nodeId, signature, hash, nodes, expiration);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ*\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ&\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J&\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u001c\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lnet/consensys/cava/devp2p/NeighborsPacket$Companion;", "", "()V", "RLP_MIN_SIZE", "", "create", "Lnet/consensys/cava/devp2p/NeighborsPacket;", "keyPair", "Lnet/consensys/cava/crypto/SECP256K1$KeyPair;", "now", "", "nodes", "", "Lnet/consensys/cava/devp2p/Node;", "createRequired", "decode", "payload", "Lnet/consensys/cava/bytes/Bytes;", "hash", "Lnet/consensys/cava/bytes/Bytes32;", "publicKey", "Lnet/consensys/cava/crypto/SECP256K1$PublicKey;", "signature", "Lnet/consensys/cava/crypto/SECP256K1$Signature;", "encodeTo", "", "writer", "Lnet/consensys/cava/rlp/RLPWriter;", "expiration", "devp2p"})
    public static final class Companion {
        @NotNull
        public final NeighborsPacket create(@NotNull SECP256K1.KeyPair keyPair, long now, @NotNull List<Node> nodes) {
            Intrinsics.checkParameterIsNotNull((Object)keyPair, (String)"keyPair");
            Intrinsics.checkParameterIsNotNull(nodes, (String)"nodes");
            long expiration = Packet.Companion.expirationFor(now);
            SigHash sigHash2 = Packet.Companion.createSignature(PacketType.NEIGHBORS, keyPair, (Function1<? super RLPWriter, Unit>)((Function1)new Function1<RLPWriter, Unit>(nodes, expiration){
                final /* synthetic */ List $nodes;
                final /* synthetic */ long $expiration;

                public final void invoke(@NotNull RLPWriter writer) {
                    Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
                    net.consensys.cava.devp2p.NeighborsPacket$Companion.access$encodeTo(NeighborsPacket.Companion, writer, this.$nodes, this.$expiration);
                }
                {
                    this.$nodes = list;
                    this.$expiration = l;
                    super(1);
                }
            }));
            SECP256K1.PublicKey publicKey = keyPair.publicKey();
            Intrinsics.checkExpressionValueIsNotNull((Object)publicKey, (String)"keyPair.publicKey()");
            return new NeighborsPacket(publicKey, sigHash2.getSignature(), sigHash2.getHash(), nodes, expiration, null);
        }

        @NotNull
        public final List<NeighborsPacket> createRequired(@NotNull SECP256K1.KeyPair keyPair, long now, @NotNull List<Node> nodes) {
            Intrinsics.checkParameterIsNotNull((Object)keyPair, (String)"keyPair");
            Intrinsics.checkParameterIsNotNull(nodes, (String)"nodes");
            List result2 = new ArrayList();
            List nodeSubset = new ArrayList();
            int size = 109;
            for (Node node2 : nodes) {
                int nodeSize = node2.rlpSize$devp2p();
                if ((size += nodeSize) > 1280) {
                    result2.add(this.create(keyPair, now, nodeSubset));
                    nodeSubset = new ArrayList();
                    size = 109 + nodeSize;
                }
                nodeSubset.add(node2);
            }
            result2.add(this.create(keyPair, now, nodeSubset));
            return result2;
        }

        @NotNull
        public final NeighborsPacket decode(@NotNull Bytes payload, @NotNull Bytes32 hash, @NotNull SECP256K1.PublicKey publicKey, @NotNull SECP256K1.Signature signature) {
            Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
            Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
            Intrinsics.checkParameterIsNotNull((Object)publicKey, (String)"publicKey");
            Intrinsics.checkParameterIsNotNull((Object)signature, (String)"signature");
            try {
                Object object = RLP.decodeList((Bytes)payload, (Function)new Function<RLPReader, T>(publicKey, signature, hash){
                    final /* synthetic */ SECP256K1.PublicKey $publicKey;
                    final /* synthetic */ SECP256K1.Signature $signature;
                    final /* synthetic */ Bytes32 $hash;

                    @NotNull
                    public final NeighborsPacket apply(RLPReader reader) {
                        List nodes = new ArrayList<E>();
                        reader.readList((Function)new Function<RLPReader, Unit>(nodes){
                            final /* synthetic */ List $nodes;

                            public final void apply(RLPReader r) {
                                while (true) {
                                    Node node2;
                                    RLPReader rLPReader = r;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)rLPReader, (String)"r");
                                    if (rLPReader.isComplete()) break;
                                    Node node3 = node2 = (Node)r.readList((Function)decode.node.1.INSTANCE);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)node3, (String)"node");
                                    this.$nodes.add(node3);
                                }
                            }
                            {
                                this.$nodes = list;
                            }
                        });
                        long expiration = reader.readLong();
                        return new NeighborsPacket(this.$publicKey, this.$signature, this.$hash, nodes, PacketKt.access$secToMsec(expiration), null);
                    }
                    {
                        this.$publicKey = publicKey;
                        this.$signature = signature;
                        this.$hash = bytes32;
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"RLP.decodeList(payload) \u2026ec(expiration))\n        }");
                return (NeighborsPacket)object;
            }
            catch (RLPException e) {
                throw (Throwable)new DecodingException("Invalid nodes packet", e);
            }
        }

        private final void encodeTo(RLPWriter writer, List<Node> nodes, long expiration) {
            writer.writeList((Consumer)new Consumer<RLPWriter>(nodes){
                final /* synthetic */ List $nodes;

                public final void accept(RLPWriter w) {
                    Iterable $receiver$iv = this.$nodes;
                    for (T element$iv : $receiver$iv) {
                        Node node2 = (Node)element$iv;
                        boolean bl = false;
                        w.writeList((Consumer)new Consumer<RLPWriter>(node2){
                            final /* synthetic */ Node $node;

                            public final void accept(RLPWriter nw) {
                                RLPWriter rLPWriter = nw;
                                Intrinsics.checkExpressionValueIsNotNull((Object)rLPWriter, (String)"nw");
                                this.$node.writeTo$devp2p(rLPWriter);
                            }
                            {
                                this.$node = node2;
                            }
                        });
                    }
                }
                {
                    this.$nodes = list;
                }
            });
            writer.writeLong(PacketKt.access$msecToSec(expiration));
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$encodeTo(Companion $this, RLPWriter writer, List nodes, long expiration) {
            $this.encodeTo(writer, nodes, expiration);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

