/*
 * Decompiled with CFR 0.152.
 */
package net.consensys.cava.devp2p;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.consensys.cava.bytes.Bytes;
import net.consensys.cava.bytes.Bytes32;
import net.consensys.cava.crypto.SECP256K1;
import net.consensys.cava.devp2p.DecodingException;
import net.consensys.cava.devp2p.Endpoint;
import net.consensys.cava.devp2p.Packet;
import net.consensys.cava.devp2p.PacketKt;
import net.consensys.cava.devp2p.PacketType;
import net.consensys.cava.devp2p.PongPacket;
import net.consensys.cava.devp2p.SigHash;
import net.consensys.cava.rlp.RLP;
import net.consensys.cava.rlp.RLPException;
import net.consensys.cava.rlp.RLPReader;
import net.consensys.cava.rlp.RLPWriter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B7\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lnet/consensys/cava/devp2p/PongPacket;", "Lnet/consensys/cava/devp2p/Packet;", "nodeId", "Lnet/consensys/cava/crypto/SECP256K1$PublicKey;", "signature", "Lnet/consensys/cava/crypto/SECP256K1$Signature;", "hash", "Lnet/consensys/cava/bytes/Bytes32;", "to", "Lnet/consensys/cava/devp2p/Endpoint;", "pingHash", "expiration", "", "(Lnet/consensys/cava/crypto/SECP256K1$PublicKey;Lnet/consensys/cava/crypto/SECP256K1$Signature;Lnet/consensys/cava/bytes/Bytes32;Lnet/consensys/cava/devp2p/Endpoint;Lnet/consensys/cava/bytes/Bytes32;J)V", "getPingHash", "()Lnet/consensys/cava/bytes/Bytes32;", "getTo", "()Lnet/consensys/cava/devp2p/Endpoint;", "encodeTo", "Ljava/nio/ByteBuffer;", "dst", "Companion", "devp2p"})
public final class PongPacket
extends Packet {
    @NotNull
    private final Endpoint to;
    @NotNull
    private final Bytes32 pingHash;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public ByteBuffer encodeTo(@NotNull ByteBuffer dst) {
        Intrinsics.checkParameterIsNotNull((Object)dst, (String)"dst");
        return this.encodeTo(dst, PacketType.PONG, (Function1<? super RLPWriter, Unit>)((Function1)new Function1<RLPWriter, Unit>(this){
            final /* synthetic */ PongPacket this$0;

            public final void invoke(@NotNull RLPWriter writer) {
                Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
                net.consensys.cava.devp2p.PongPacket$Companion.access$encodeTo(PongPacket.Companion, writer, this.this$0.getTo(), this.this$0.getPingHash(), this.this$0.getExpiration());
            }
            {
                this.this$0 = pongPacket;
                super(1);
            }
        }));
    }

    @NotNull
    public final Endpoint getTo() {
        return this.to;
    }

    @NotNull
    public final Bytes32 getPingHash() {
        return this.pingHash;
    }

    private PongPacket(SECP256K1.PublicKey nodeId, SECP256K1.Signature signature, Bytes32 hash, Endpoint to2, Bytes32 pingHash, long expiration) {
        super(nodeId, signature, hash, expiration, null);
        this.to = to2;
        this.pingHash = pingHash;
    }

    public /* synthetic */ PongPacket(@NotNull SECP256K1.PublicKey nodeId, @NotNull SECP256K1.Signature signature, @NotNull Bytes32 hash, @NotNull Endpoint to2, @NotNull Bytes32 pingHash, long expiration, DefaultConstructorMarker $constructor_marker) {
        this(nodeId, signature, hash, to2, pingHash, expiration);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ&\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J(\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\bH\u0002\u00a8\u0006\u001a"}, d2={"Lnet/consensys/cava/devp2p/PongPacket$Companion;", "", "()V", "create", "Lnet/consensys/cava/devp2p/PongPacket;", "keyPair", "Lnet/consensys/cava/crypto/SECP256K1$KeyPair;", "now", "", "to", "Lnet/consensys/cava/devp2p/Endpoint;", "pingHash", "Lnet/consensys/cava/bytes/Bytes32;", "decode", "payload", "Lnet/consensys/cava/bytes/Bytes;", "hash", "publicKey", "Lnet/consensys/cava/crypto/SECP256K1$PublicKey;", "signature", "Lnet/consensys/cava/crypto/SECP256K1$Signature;", "encodeTo", "", "writer", "Lnet/consensys/cava/rlp/RLPWriter;", "expiration", "devp2p"})
    public static final class Companion {
        @NotNull
        public final PongPacket create(@NotNull SECP256K1.KeyPair keyPair, long now, @NotNull Endpoint to2, @NotNull Bytes32 pingHash) {
            Intrinsics.checkParameterIsNotNull((Object)keyPair, (String)"keyPair");
            Intrinsics.checkParameterIsNotNull((Object)to2, (String)"to");
            Intrinsics.checkParameterIsNotNull((Object)pingHash, (String)"pingHash");
            long expiration = Packet.Companion.expirationFor(now);
            SigHash sigHash2 = Packet.Companion.createSignature(PacketType.PONG, keyPair, (Function1<? super RLPWriter, Unit>)((Function1)new Function1<RLPWriter, Unit>(to2, pingHash, expiration){
                final /* synthetic */ Endpoint $to;
                final /* synthetic */ Bytes32 $pingHash;
                final /* synthetic */ long $expiration;

                public final void invoke(@NotNull RLPWriter writer) {
                    Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
                    net.consensys.cava.devp2p.PongPacket$Companion.access$encodeTo(PongPacket.Companion, writer, this.$to, this.$pingHash, this.$expiration);
                }
                {
                    this.$to = endpoint;
                    this.$pingHash = bytes32;
                    this.$expiration = l;
                    super(1);
                }
            }));
            SECP256K1.PublicKey publicKey = keyPair.publicKey();
            Intrinsics.checkExpressionValueIsNotNull((Object)publicKey, (String)"keyPair.publicKey()");
            return new PongPacket(publicKey, sigHash2.getSignature(), sigHash2.getHash(), to2, pingHash, expiration, null);
        }

        @NotNull
        public final PongPacket decode(@NotNull Bytes payload, @NotNull Bytes32 hash, @NotNull SECP256K1.PublicKey publicKey, @NotNull SECP256K1.Signature signature) {
            Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
            Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
            Intrinsics.checkParameterIsNotNull((Object)publicKey, (String)"publicKey");
            Intrinsics.checkParameterIsNotNull((Object)signature, (String)"signature");
            try {
                Object object = RLP.decodeList((Bytes)payload, (Function)new Function<RLPReader, T>(publicKey, signature, hash){
                    final /* synthetic */ SECP256K1.PublicKey $publicKey;
                    final /* synthetic */ SECP256K1.Signature $signature;
                    final /* synthetic */ Bytes32 $hash;

                    @NotNull
                    public final PongPacket apply(RLPReader reader) {
                        Endpoint to2 = (Endpoint)reader.readList((Function)decode.to.1.INSTANCE);
                        Bytes32 pingHash = Bytes32.wrap((Bytes)reader.readValue());
                        long expiration = reader.readLong();
                        Endpoint endpoint = to2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)endpoint, (String)"to");
                        Bytes32 bytes32 = pingHash;
                        Intrinsics.checkExpressionValueIsNotNull((Object)bytes32, (String)"pingHash");
                        return new PongPacket(this.$publicKey, this.$signature, this.$hash, endpoint, bytes32, PacketKt.access$secToMsec(expiration), null);
                    }
                    {
                        this.$publicKey = publicKey;
                        this.$signature = signature;
                        this.$hash = bytes32;
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"RLP.decodeList(payload) \u2026ec(expiration))\n        }");
                return (PongPacket)object;
            }
            catch (RLPException e) {
                throw (Throwable)new DecodingException("Invalid pong packet", e);
            }
        }

        private final void encodeTo(RLPWriter writer, Endpoint to2, Bytes32 pingHash, long expiration) {
            writer.writeList((Consumer)new Consumer<RLPWriter>(to2){
                final /* synthetic */ Endpoint $to;

                public final void accept(RLPWriter w) {
                    RLPWriter rLPWriter = w;
                    Intrinsics.checkExpressionValueIsNotNull((Object)rLPWriter, (String)"w");
                    this.$to.writeTo$devp2p(rLPWriter);
                }
                {
                    this.$to = endpoint;
                }
            });
            writer.writeValue((Bytes)pingHash);
            writer.writeLong(PacketKt.access$msecToSec(expiration));
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$encodeTo(Companion $this, @NotNull RLPWriter writer, @NotNull Endpoint to2, @NotNull Bytes32 pingHash, long expiration) {
            $this.encodeTo(writer, to2, pingHash, expiration);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

