/*
 * Decompiled with CFR 0.152.
 */
package net.consensys.cava.devp2p;

import java.nio.ByteBuffer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.consensys.cava.bytes.Bytes;
import net.consensys.cava.bytes.Bytes32;
import net.consensys.cava.crypto.SECP256K1;
import net.consensys.cava.devp2p.DecodingException;
import net.consensys.cava.devp2p.Packet;
import net.consensys.cava.devp2p.PacketKt;
import net.consensys.cava.devp2p.PacketType;
import net.consensys.cava.devp2p.SigHash;
import net.consensys.cava.rlp.RLP;
import net.consensys.cava.rlp.RLPException;
import net.consensys.cava.rlp.RLPReader;
import net.consensys.cava.rlp.RLPWriter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lnet/consensys/cava/devp2p/FindNodePacket;", "Lnet/consensys/cava/devp2p/Packet;", "nodeId", "Lnet/consensys/cava/crypto/SECP256K1$PublicKey;", "signature", "Lnet/consensys/cava/crypto/SECP256K1$Signature;", "hash", "Lnet/consensys/cava/bytes/Bytes32;", "target", "expiration", "", "(Lnet/consensys/cava/crypto/SECP256K1$PublicKey;Lnet/consensys/cava/crypto/SECP256K1$Signature;Lnet/consensys/cava/bytes/Bytes32;Lnet/consensys/cava/crypto/SECP256K1$PublicKey;J)V", "getTarget", "()Lnet/consensys/cava/crypto/SECP256K1$PublicKey;", "encodeTo", "Ljava/nio/ByteBuffer;", "dst", "Companion", "devp2p"})
public final class FindNodePacket
extends Packet {
    @NotNull
    private final SECP256K1.PublicKey target;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public ByteBuffer encodeTo(@NotNull ByteBuffer dst) {
        Intrinsics.checkParameterIsNotNull((Object)dst, (String)"dst");
        return this.encodeTo(dst, PacketType.FIND_NODE, (Function1<? super RLPWriter, Unit>)((Function1)new Function1<RLPWriter, Unit>(this){
            final /* synthetic */ FindNodePacket this$0;

            public final void invoke(@NotNull RLPWriter writer) {
                Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
                net.consensys.cava.devp2p.FindNodePacket$Companion.access$encodeTo(FindNodePacket.Companion, writer, this.this$0.getTarget(), this.this$0.getExpiration());
            }
            {
                this.this$0 = findNodePacket;
                super(1);
            }
        }));
    }

    @NotNull
    public final SECP256K1.PublicKey getTarget() {
        return this.target;
    }

    private FindNodePacket(SECP256K1.PublicKey nodeId, SECP256K1.Signature signature, Bytes32 hash, SECP256K1.PublicKey target, long expiration) {
        super(nodeId, signature, hash, expiration, null);
        this.target = target;
    }

    public /* synthetic */ FindNodePacket(SECP256K1.PublicKey nodeId, SECP256K1.Signature signature, Bytes32 hash, SECP256K1.PublicKey target, long expiration, DefaultConstructorMarker $constructor_marker) {
        this(nodeId, signature, hash, target, expiration);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ&\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\bH\u0002\u00a8\u0006\u0018"}, d2={"Lnet/consensys/cava/devp2p/FindNodePacket$Companion;", "", "()V", "create", "Lnet/consensys/cava/devp2p/FindNodePacket;", "keyPair", "Lnet/consensys/cava/crypto/SECP256K1$KeyPair;", "now", "", "target", "Lnet/consensys/cava/crypto/SECP256K1$PublicKey;", "decode", "payload", "Lnet/consensys/cava/bytes/Bytes;", "hash", "Lnet/consensys/cava/bytes/Bytes32;", "publicKey", "signature", "Lnet/consensys/cava/crypto/SECP256K1$Signature;", "encodeTo", "", "writer", "Lnet/consensys/cava/rlp/RLPWriter;", "expiration", "devp2p"})
    public static final class Companion {
        @NotNull
        public final FindNodePacket create(@NotNull SECP256K1.KeyPair keyPair, long now, @NotNull SECP256K1.PublicKey target) {
            Intrinsics.checkParameterIsNotNull((Object)keyPair, (String)"keyPair");
            Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
            long expiration = Packet.Companion.expirationFor(now);
            SigHash sigHash2 = Packet.Companion.createSignature(PacketType.FIND_NODE, keyPair, (Function1<? super RLPWriter, Unit>)((Function1)new Function1<RLPWriter, Unit>(target, expiration){
                final /* synthetic */ SECP256K1.PublicKey $target;
                final /* synthetic */ long $expiration;

                public final void invoke(@NotNull RLPWriter writer) {
                    Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
                    net.consensys.cava.devp2p.FindNodePacket$Companion.access$encodeTo(FindNodePacket.Companion, writer, this.$target, this.$expiration);
                }
                {
                    this.$target = publicKey;
                    this.$expiration = l;
                    super(1);
                }
            }));
            SECP256K1.PublicKey publicKey = keyPair.publicKey();
            Intrinsics.checkExpressionValueIsNotNull((Object)publicKey, (String)"keyPair.publicKey()");
            return new FindNodePacket(publicKey, sigHash2.getSignature(), sigHash2.getHash(), target, expiration, null);
        }

        @NotNull
        public final FindNodePacket decode(@NotNull Bytes payload, @NotNull Bytes32 hash, @NotNull SECP256K1.PublicKey publicKey, @NotNull SECP256K1.Signature signature) {
            Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
            Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
            Intrinsics.checkParameterIsNotNull((Object)publicKey, (String)"publicKey");
            Intrinsics.checkParameterIsNotNull((Object)signature, (String)"signature");
            try {
                Object object = RLP.decodeList((Bytes)payload, (Function)new Function<RLPReader, T>(publicKey, signature, hash){
                    final /* synthetic */ SECP256K1.PublicKey $publicKey;
                    final /* synthetic */ SECP256K1.Signature $signature;
                    final /* synthetic */ Bytes32 $hash;

                    @NotNull
                    public final FindNodePacket apply(RLPReader reader) {
                        SECP256K1.PublicKey target = SECP256K1.PublicKey.fromBytes((Bytes)reader.readValue());
                        long expiration = reader.readLong();
                        SECP256K1.PublicKey publicKey = target;
                        Intrinsics.checkExpressionValueIsNotNull((Object)publicKey, (String)"target");
                        return new FindNodePacket(this.$publicKey, this.$signature, this.$hash, publicKey, PacketKt.access$secToMsec(expiration), null);
                    }
                    {
                        this.$publicKey = publicKey;
                        this.$signature = signature;
                        this.$hash = bytes32;
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"RLP.decodeList(payload) \u2026ec(expiration))\n        }");
                return (FindNodePacket)object;
            }
            catch (RLPException e) {
                throw (Throwable)new DecodingException("Invalid find nodes packet", e);
            }
        }

        private final void encodeTo(RLPWriter writer, SECP256K1.PublicKey target, long expiration) {
            writer.writeValue(target.bytes());
            writer.writeLong(PacketKt.access$msecToSec(expiration));
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$encodeTo(Companion $this, RLPWriter writer, SECP256K1.PublicKey target, long expiration) {
            $this.encodeTo(writer, target, expiration);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

