/*
 * Decompiled with CFR 0.152.
 */
package net.consensys.cava.kademlia;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.consensys.cava.kademlia.KademliaRoutingTable;
import net.consensys.cava.kademlia.KademliaRoutingTableKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010(\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\u0018\u0000 0*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0002/0B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00040\t\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u0015\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0016\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0017J\u001b\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010\u0016\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0019J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u001fJ\u0016\u0010 \u001a\u00020\u001d2\f\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\"H\u0016J\u0013\u0010#\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001fJ\u0015\u0010$\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010%J\b\u0010&\u001a\u00020\u001dH\u0016J\u000f\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000(H\u0096\u0002J\u0015\u0010)\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010*J\u001c\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000,2\u0006\u0010-\u001a\u00020\u00042\u0006\u0010.\u001a\u00020\u0006R\u001c\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\r0\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00061"}, d2={"Lnet/consensys/cava/kademlia/KademliaRoutingTable;", "T", "", "selfId", "", "k", "", "maxReplacements", "nodeId", "Lkotlin/Function1;", "([BIILkotlin/jvm/functions/Function1;)V", "buckets", "", "Lnet/consensys/cava/kademlia/KademliaRoutingTable$Bucket;", "[Lnet/consensys/cava/kademlia/KademliaRoutingTable$Bucket;", "distanceCache", "Lcom/google/common/cache/Cache;", "idBitSize", "size", "getSize", "()I", "add", "node", "(Ljava/lang/Object;)Ljava/lang/Object;", "bucketFor", "(Ljava/lang/Object;)Lnet/consensys/cava/kademlia/KademliaRoutingTable$Bucket;", "clear", "", "contains", "", "element", "(Ljava/lang/Object;)Z", "containsAll", "elements", "", "evict", "idForNode", "(Ljava/lang/Object;)[B", "isEmpty", "iterator", "", "logDistToSelf", "(Ljava/lang/Object;)I", "nearest", "", "targetId", "limit", "Bucket", "Companion", "kademlia"})
public final class KademliaRoutingTable<T>
implements Set<T>,
KMappedMarker {
    private final int idBitSize;
    private final Bucket<T>[] buckets;
    private final Cache<T, Integer> distanceCache;
    private final byte[] selfId;
    private final Function1<T, byte[]> nodeId;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    public int getSize() {
        void var3_3;
        void $receiver$iv;
        int initial$iv;
        Bucket<T>[] bucketArray = this.buckets;
        int accumulator$iv = initial$iv = 0;
        void var4_4 = $receiver$iv;
        int n = ((void)var4_4).length;
        for (int j = 0; j < n; ++j) {
            void bucket;
            void element$iv;
            void var8_8 = element$iv = var4_4[j];
            int acc = accumulator$iv;
            accumulator$iv = acc + bucket.size();
        }
        return (int)var3_3;
    }

    @Override
    public boolean isEmpty() {
        Bucket<T> bucket;
        block1: {
            Bucket<T>[] bucketArray;
            Bucket<T>[] bucketArray2;
            for (Bucket<T> bucket2 : bucketArray2 = (bucketArray = this.buckets)) {
                Bucket<T> bucket3 = bucket2;
                if (!(!bucket3.isEmpty())) continue;
                bucket = bucket2;
                break block1;
            }
            bucket = null;
        }
        return bucket == null;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return SequencesKt.flatMap((Sequence)ArraysKt.asSequence((Object[])this.buckets), (Function1)iterator.1.INSTANCE).iterator();
    }

    @Override
    public boolean contains(Object element) {
        return this.bucketFor(element).contains(element);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Bucket<T>[] $receiver$iv;
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        Set peers = CollectionsKt.toMutableSet((Iterable)elements);
        Bucket<T>[] bucketArray = $receiver$iv = this.buckets;
        int n = bucketArray.length;
        for (int j = 0; j < n; ++j) {
            void $receiver$iv$iv;
            void $receiver$iv2;
            Bucket<T> element$iv;
            Bucket<T> bucket = element$iv = bucketArray[j];
            Iterable iterable = peers;
            Set set = peers;
            void var11_11 = $receiver$iv2;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                Object peer = element$iv$iv;
                if (!bucket.contains(peer)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            set.removeAll(list);
            if (!peers.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public final List<T> nearest(@NotNull byte[] targetId, int limit) {
        Intrinsics.checkParameterIsNotNull((Object)targetId, (String)"targetId");
        List results = new ArrayList();
        for (Bucket<T> bucket : this.buckets) {
            for (T node : bucket) {
                byte[] nodeId = this.idForNode(node);
                KademliaRoutingTableKt.orderedInsert(results, node, (Function2)new Function2<T, T, Integer>(this, targetId, nodeId){
                    final /* synthetic */ KademliaRoutingTable this$0;
                    final /* synthetic */ byte[] $targetId;
                    final /* synthetic */ byte[] $nodeId;

                    public final int invoke(T a, T $noName_1) {
                        return KademliaRoutingTableKt.xorDistCmp(this.$targetId, KademliaRoutingTable.access$idForNode(this.this$0, a), this.$nodeId);
                    }
                    {
                        this.this$0 = kademliaRoutingTable;
                        this.$targetId = byArray;
                        this.$nodeId = byArray2;
                        super(2);
                    }
                });
                if (results.size() <= limit) continue;
                results.remove(CollectionsKt.getLastIndex((List)results));
            }
        }
        return results;
    }

    @Nullable
    public final T add(T node) {
        return this.bucketFor(node).add(node);
    }

    public final boolean evict(T node) {
        return this.bucketFor(node).evict(node);
    }

    @Override
    public final void clear() {
        Bucket<T>[] $receiver$iv;
        Bucket<T>[] bucketArray = $receiver$iv = this.buckets;
        int n = bucketArray.length;
        for (int j = 0; j < n; ++j) {
            Bucket<T> element$iv;
            Bucket<T> bucket = element$iv = bucketArray[j];
            bucket.clear();
        }
    }

    private final byte[] idForNode(T node) {
        boolean bl;
        boolean bl2;
        byte[] id = (byte[])this.nodeId.invoke(node);
        boolean bl3 = bl2 = id.length == this.selfId.length;
        if (!bl2) {
            String string = "id obtained for node is not the correct length";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        byte[] byArray = id;
        byte[] $i$a$1$require = this.selfId;
        boolean bl4 = bl = !Arrays.equals(byArray, $i$a$1$require);
        if (!bl) {
            String string = "id obtained for node is the same as self";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return id;
    }

    private final Bucket<T> bucketFor(T node) {
        return this.buckets[this.logDistToSelf(node)];
    }

    private final int logDistToSelf(T node) {
        Object object = this.distanceCache.get(node, (Callable)new Callable<Integer>(this, node){
            final /* synthetic */ KademliaRoutingTable this$0;
            final /* synthetic */ Object $node;

            public final int call() {
                return KademliaRoutingTableKt.xorDist(KademliaRoutingTable.access$idForNode(this.this$0, this.$node), KademliaRoutingTable.access$getSelfId$p(this.this$0));
            }
            {
                this.this$0 = kademliaRoutingTable;
                this.$node = object;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"distanceCache.get(node) \u2026de(node) xorDist selfId }");
        return ((Number)object).intValue();
    }

    /*
     * WARNING - void declaration
     */
    public KademliaRoutingTable(@NotNull byte[] selfId, int k, int maxReplacements, @NotNull Function1<? super T, byte[]> nodeId) {
        Bucket[] bucketArray;
        void size$iv;
        int n;
        byte[] byArray;
        Intrinsics.checkParameterIsNotNull((Object)selfId, (String)"selfId");
        Intrinsics.checkParameterIsNotNull(nodeId, (String)"nodeId");
        this.selfId = selfId;
        this.nodeId = nodeId;
        byte[] byArray2 = byArray = this.selfId;
        int n2 = n = !(byArray2.length == 0) ? 1 : 0;
        if (n == 0) {
            String string = "self id must not be empty";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int n3 = n = k > 0 ? 1 : 0;
        if (n == 0) {
            String string = "k value must be positive";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.idBitSize = this.selfId.length * 8;
        n = this.idBitSize + 1;
        KademliaRoutingTable kademliaRoutingTable = this;
        Bucket[] result$iv = new Bucket[size$iv];
        int n4 = 0;
        int n5 = result$iv.length;
        while (n4 < n5) {
            Bucket bucket;
            void i$iv;
            void var9_13 = i$iv;
            void var14_15 = i$iv++;
            bucketArray = result$iv;
            bucketArray[var14_15] = bucket = new Bucket(k, maxReplacements);
        }
        bucketArray = result$iv;
        kademliaRoutingTable.buckets = bucketArray;
        Cache cache = CacheBuilder.newBuilder().maximumSize((1L + (long)this.idBitSize) * (long)k).weakKeys().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)cache, (String)"CacheBuilder.newBuilder(\u2026) * k).weakKeys().build()");
        this.distanceCache = cache;
    }

    public /* synthetic */ KademliaRoutingTable(byte[] byArray, int n, int n2, Function1 function1, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n2 = n;
        }
        this(byArray, n, n2, function1);
    }

    @NotNull
    public static final /* synthetic */ byte[] access$idForNode(KademliaRoutingTable $this, Object node) {
        return $this.idForNode(node);
    }

    @NotNull
    public static final /* synthetic */ byte[] access$getSelfId$p(KademliaRoutingTable $this) {
        return $this.selfId;
    }

    @Override
    public boolean add(T t) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean removeAll(Collection<? extends Object> collection) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean retainAll(Collection<? extends Object> collection) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return CollectionToArray.toArray((Collection)this, (Object[])TArray);
    }

    @JvmStatic
    @NotNull
    public static final <T> KademliaRoutingTable<T> create(@NotNull byte[] selfId, int k, @NotNull Function<T, byte[]> nodeId) {
        return Companion.create(selfId, k, nodeId);
    }

    @JvmStatic
    @NotNull
    public static final <T> KademliaRoutingTable<T> create(@NotNull byte[] selfId, int k, int maxReplacements, @NotNull Function<T, byte[]> nodeId) {
        return Companion.create(selfId, k, maxReplacements, nodeId);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\b\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010*\n\u0002\b\u0004\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006B%\b\u0002\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\u000e\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u000f\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u0001H\u0096\u0003\u00a2\u0006\u0002\u0010\u0016J\u0017\u0010\u0017\u001a\u00020\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00010\u0019H\u0096\u0001J\u0013\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010\u001b\u001a\u00028\u00012\u0006\u0010\u001c\u001a\u00020\u0004H\u0096\u0003\u00a2\u0006\u0002\u0010\u001dJ\u0016\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00028\u0001H\u0096\u0001\u00a2\u0006\u0002\u0010\u001fJ\t\u0010 \u001a\u00020\u0014H\u0096\u0001J\u000f\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00010\"H\u0096\u0003J\u0016\u0010#\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00028\u0001H\u0096\u0001\u00a2\u0006\u0002\u0010\u001fJ\u000f\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00010%H\u0096\u0001J\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00010%2\u0006\u0010\u001c\u001a\u00020\u0004H\u0096\u0001J\u001f\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00010\u00022\u0006\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u0004H\u0096\u0001R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\u0004X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006)"}, d2={"Lnet/consensys/cava/kademlia/KademliaRoutingTable$Bucket;", "E", "", "k", "", "maxReplacements", "(II)V", "entries", "", "(Ljava/util/List;II)V", "replacementCache", "size", "getSize", "()I", "add", "node", "(Ljava/lang/Object;)Ljava/lang/Object;", "clear", "", "contains", "", "element", "(Ljava/lang/Object;)Z", "containsAll", "elements", "", "evict", "get", "index", "(I)Ljava/lang/Object;", "indexOf", "(Ljava/lang/Object;)I", "isEmpty", "iterator", "", "lastIndexOf", "listIterator", "", "subList", "fromIndex", "toIndex", "kademlia"})
    private static final class Bucket<E>
    implements List<E>,
    KMappedMarker {
        private final List<E> replacementCache;
        private final List<E> entries;
        private final int k;
        private final int maxReplacements;

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final synchronized E add(E node) {
            this.replacementCache.remove(node);
            int n = 0;
            int n2 = ((Collection)this.entries).size();
            while (n < n2) {
                void i2;
                if (Intrinsics.areEqual(this.entries.get((int)i2), node)) {
                    this.entries.remove((int)i2);
                    this.entries.add(0, node);
                    return null;
                }
                ++i2;
            }
            int n3 = n = this.entries.size() <= this.k ? 1 : 0;
            if (_Assertions.ENABLED && n == 0) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            if (this.entries.size() == this.k) {
                int n4 = n = this.replacementCache.size() <= this.maxReplacements ? 1 : 0;
                if (_Assertions.ENABLED && n == 0) {
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                if (this.replacementCache.size() == this.maxReplacements) {
                    this.replacementCache.remove(0);
                }
                this.replacementCache.add(node);
                return (E)CollectionsKt.last(this.entries);
            }
            this.entries.add(0, node);
            return null;
        }

        public final synchronized boolean evict(E node) {
            if (!this.entries.remove(node)) {
                return false;
            }
            if (!this.replacementCache.isEmpty()) {
                E replacement = this.replacementCache.remove(CollectionsKt.getLastIndex(this.replacementCache));
                this.entries.add(0, replacement);
            }
            return true;
        }

        @Override
        public final synchronized void clear() {
            this.entries.clear();
            this.replacementCache.clear();
        }

        private Bucket(List<E> entries, int k, int maxReplacements) {
            boolean bl;
            List list;
            this.entries = entries;
            this.k = k;
            this.maxReplacements = maxReplacements;
            Bucket bucket = this;
            bucket.replacementCache = list = (List)new ArrayList();
            boolean bl2 = bl = this.k > 0;
            if (!bl) {
                String string = "k value must be positive";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }

        public Bucket(int k, int maxReplacements) {
            Bucket<E> bucket = this;
            List list = new ArrayList();
            bucket(list, k, maxReplacements);
        }

        public int getSize() {
            return this.entries.size();
        }

        @Override
        public boolean contains(Object element) {
            return this.entries.contains(element);
        }

        @Override
        public boolean containsAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            return this.entries.containsAll(elements);
        }

        @Override
        public E get(int index) {
            return this.entries.get(index);
        }

        @Override
        public int indexOf(Object element) {
            return this.entries.indexOf(element);
        }

        @Override
        public boolean isEmpty() {
            return this.entries.isEmpty();
        }

        @Override
        @NotNull
        public Iterator<E> iterator() {
            return this.entries.iterator();
        }

        @Override
        public int lastIndexOf(Object element) {
            return this.entries.lastIndexOf(element);
        }

        @Override
        @NotNull
        public ListIterator<E> listIterator() {
            return this.entries.listIterator();
        }

        @Override
        @NotNull
        public ListIterator<E> listIterator(int index) {
            return this.entries.listIterator(index);
        }

        @Override
        @NotNull
        public List<E> subList(int fromIndex, int toIndex) {
            return this.entries.subList(fromIndex, toIndex);
        }

        @Override
        public boolean add(E e) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public void add(int n, E e) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public boolean addAll(int n, Collection<? extends E> collection) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public boolean removeAll(Collection<? extends Object> collection) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public E remove(int n) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public void replaceAll(UnaryOperator<E> unaryOperator) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public boolean retainAll(Collection<? extends Object> collection) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public E set(int n, E e) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public void sort(Comparator<? super E> comparator) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public Object[] toArray() {
            return CollectionToArray.toArray((Collection)this);
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return CollectionToArray.toArray((Collection)this, (Object[])TArray);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0001\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00070\u000bH\u0007J@\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0001\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00070\u000bH\u0007\u00a8\u0006\r"}, d2={"Lnet/consensys/cava/kademlia/KademliaRoutingTable$Companion;", "", "()V", "create", "Lnet/consensys/cava/kademlia/KademliaRoutingTable;", "T", "selfId", "", "k", "", "nodeId", "Ljava/util/function/Function;", "maxReplacements", "kademlia"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final <T> KademliaRoutingTable<T> create(@NotNull byte[] selfId, int k, @NotNull Function<T, byte[]> nodeId) {
            Intrinsics.checkParameterIsNotNull((Object)selfId, (String)"selfId");
            Intrinsics.checkParameterIsNotNull(nodeId, (String)"nodeId");
            return new KademliaRoutingTable(selfId, k, 0, new Function1<T, byte[]>(nodeId){

                @NotNull
                public final byte[] invoke(T p1) {
                    return (byte[])((Function)this.receiver).apply(p1);
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(Function.class);
                }

                public final String getName() {
                    return "apply";
                }

                public final String getSignature() {
                    return "apply(Ljava/lang/Object;)Ljava/lang/Object;";
                }
            }, 4, null);
        }

        @JvmStatic
        @NotNull
        public final <T> KademliaRoutingTable<T> create(@NotNull byte[] selfId, int k, int maxReplacements, @NotNull Function<T, byte[]> nodeId) {
            Intrinsics.checkParameterIsNotNull((Object)selfId, (String)"selfId");
            Intrinsics.checkParameterIsNotNull(nodeId, (String)"nodeId");
            return new KademliaRoutingTable(selfId, k, maxReplacements, (Function1)new Function1<T, byte[]>(nodeId){

                @NotNull
                public final byte[] invoke(T p1) {
                    return (byte[])((Function)this.receiver).apply(p1);
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(Function.class);
                }

                public final String getName() {
                    return "apply";
                }

                public final String getSignature() {
                    return "apply(Ljava/lang/Object;)Ljava/lang/Object;";
                }
            });
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

