/*
 * Decompiled with CFR 0.152.
 */
package net.consensys.cava.rlpx.wire;

import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.consensys.cava.bytes.Bytes;
import net.consensys.cava.concurrent.AsyncCompletion;
import net.consensys.cava.concurrent.CompletableAsyncCompletion;
import net.consensys.cava.rlpx.RLPxMessage;
import net.consensys.cava.rlpx.wire.Capability;
import net.consensys.cava.rlpx.wire.DisconnectMessage;
import net.consensys.cava.rlpx.wire.DisconnectReason;
import net.consensys.cava.rlpx.wire.HelloMessage;
import net.consensys.cava.rlpx.wire.SubProtocol;
import net.consensys.cava.rlpx.wire.SubProtocolHandler;
import net.consensys.cava.rlpx.wire.SubProtocolIdentifier;
import net.consensys.cava.rlpx.wire.WireConnection;
import org.logl.Logger;

public final class DefaultWireConnection
implements WireConnection {
    private final Bytes nodeId;
    private final Bytes peerNodeId;
    private final Logger logger;
    private final String id;
    private final Consumer<RLPxMessage> writer;
    private final Consumer<HelloMessage> afterHandshakeListener;
    private final Runnable disconnectHandler;
    private final LinkedHashMap<SubProtocol, SubProtocolHandler> subprotocols;
    private final int p2pVersion;
    private final String clientId;
    private final int advertisedPort;
    private CompletableAsyncCompletion awaitingPong;
    private HelloMessage myHelloMessage;
    private HelloMessage peerHelloMessage;
    private RangeMap<Integer, SubProtocol> subprotocolRangeMap = TreeRangeMap.create();

    public DefaultWireConnection(String id, Bytes nodeId, Bytes peerNodeId, Logger logger, Consumer<RLPxMessage> writer, Consumer<HelloMessage> afterHandshakeListener, Runnable disconnectHandler, LinkedHashMap<SubProtocol, SubProtocolHandler> subprotocols, int p2pVersion, String clientId, int advertisedPort) {
        this.id = id;
        this.nodeId = nodeId;
        this.peerNodeId = peerNodeId;
        this.logger = logger;
        this.writer = writer;
        this.afterHandshakeListener = afterHandshakeListener;
        this.disconnectHandler = disconnectHandler;
        this.subprotocols = subprotocols;
        this.p2pVersion = p2pVersion;
        this.clientId = clientId;
        this.advertisedPort = advertisedPort;
        logger.debug((CharSequence)"New wire connection created");
    }

    public void messageReceived(RLPxMessage message) {
        if (message.messageId() == 0) {
            this.peerHelloMessage = HelloMessage.read(message.content());
            this.logger.debug("Received peer Hello message {}", (Object)this.peerHelloMessage);
            this.initSupportedRange(this.peerHelloMessage.capabilities());
            if (this.peerHelloMessage.nodeId() == null || this.peerHelloMessage.nodeId().isEmpty()) {
                this.disconnect(DisconnectReason.NULL_NODE_IDENTITY_RECEIVED);
                return;
            }
            if (!this.peerHelloMessage.nodeId().equals(this.peerNodeId)) {
                this.disconnect(DisconnectReason.UNEXPECTED_IDENTITY);
                return;
            }
            if (this.peerHelloMessage.nodeId().equals(this.nodeId)) {
                this.disconnect(DisconnectReason.CONNECTED_TO_SELF);
                return;
            }
            if (this.peerHelloMessage.p2pVersion() > this.p2pVersion) {
                this.disconnect(DisconnectReason.INCOMPATIBLE_DEVP2P_VERSION);
                return;
            }
            if (this.myHelloMessage == null) {
                this.sendHello();
            }
            this.afterHandshakeListener.accept(this.peerHelloMessage);
            for (SubProtocol subProtocol : this.subprotocolRangeMap.asMapOfRanges().values()) {
                this.subprotocols.get(subProtocol).handleNewPeerConnection(this.id);
            }
            return;
        }
        if (message.messageId() == 1) {
            DisconnectMessage.read(message.content());
            this.disconnectHandler.run();
            return;
        }
        if (this.peerHelloMessage == null || this.myHelloMessage == null) {
            this.logger.debug("Message sent before hello exchanged {}", (Object)message.messageId());
            this.disconnect(DisconnectReason.PROTOCOL_BREACH);
        }
        if (message.messageId() == 2) {
            this.sendPong();
        } else if (message.messageId() == 3) {
            if (this.awaitingPong != null) {
                this.awaitingPong.complete();
            }
        } else {
            Map.Entry subProtocolEntry = this.subprotocolRangeMap.getEntry((Comparable)Integer.valueOf(message.messageId()));
            if (subProtocolEntry == null) {
                this.disconnect(DisconnectReason.PROTOCOL_BREACH);
            } else {
                int offset = (Integer)((Range)subProtocolEntry.getKey()).lowerEndpoint();
                this.subprotocols.get(subProtocolEntry.getValue()).handle(this.id, message.messageId() - offset, message.content());
            }
        }
    }

    private void initSupportedRange(List<Capability> capabilities) {
        int startRange = 17;
        block0: for (Capability cap : capabilities) {
            for (SubProtocol sp : this.subprotocols.keySet()) {
                if (!sp.supports(SubProtocolIdentifier.of(cap.name(), cap.version()))) continue;
                int numberOfMessageTypes = sp.versionRange(cap.version());
                this.subprotocolRangeMap.put(Range.range((Comparable)Integer.valueOf(startRange), (BoundType)BoundType.CLOSED, (Comparable)Integer.valueOf(startRange + numberOfMessageTypes), (BoundType)BoundType.CLOSED), (Object)sp);
                startRange += numberOfMessageTypes + 1;
                continue block0;
            }
        }
    }

    public void disconnect(DisconnectReason reason) {
        this.logger.debug("Sending disconnect message with reason {}", (Object)reason);
        this.writer.accept(new RLPxMessage(1, new DisconnectMessage(reason).toBytes()));
        this.disconnectHandler.run();
    }

    public AsyncCompletion sendPing() {
        this.logger.debug((CharSequence)"Sending ping message");
        this.writer.accept(new RLPxMessage(2, Bytes.EMPTY));
        this.awaitingPong = AsyncCompletion.incomplete();
        return this.awaitingPong;
    }

    private void sendPong() {
        this.logger.debug((CharSequence)"Sending pong message");
        this.writer.accept(new RLPxMessage(3, Bytes.EMPTY));
    }

    void sendHello() {
        this.myHelloMessage = HelloMessage.create(this.nodeId, this.advertisedPort, this.p2pVersion, this.clientId, this.subprotocols.keySet().stream().map(sp -> new Capability(sp.id().name(), sp.id().version())).collect(Collectors.toList()));
        this.logger.debug("Sending hello message {}", (Object)this.myHelloMessage);
        this.writer.accept(new RLPxMessage(0, this.myHelloMessage.toBytes()));
    }

    @Override
    public String id() {
        return this.id;
    }

    public void sendMessage(SubProtocolIdentifier subProtocolIdentifier, int messageType, Bytes message) {
        this.logger.debug("Sending sub-protocol message {}", (Object)message);
        Integer offset = null;
        for (Map.Entry entry : this.subprotocolRangeMap.asMapOfRanges().entrySet()) {
            if (!((SubProtocol)entry.getValue()).supports(subProtocolIdentifier)) continue;
            offset = (Integer)((Range)entry.getKey()).lowerEndpoint();
            break;
        }
        if (offset == null) {
            throw new UnsupportedOperationException();
        }
        this.writer.accept(new RLPxMessage(messageType + offset, message));
    }

    public void handleConnectionStart() {
        this.sendHello();
    }

    public String toString() {
        return this.peerNodeId.toHexString();
    }
}

