/*
 * Decompiled with CFR 0.152.
 */
package net.consensys.cava.rlpx;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.function.Consumer;
import java.util.function.Function;
import net.consensys.cava.bytes.Bytes;
import net.consensys.cava.bytes.Bytes32;
import net.consensys.cava.concurrent.AsyncResult;
import net.consensys.cava.crypto.Hash;
import net.consensys.cava.crypto.SECP256K1;
import net.consensys.cava.rlpx.EthereumIESEncryptionEngine;
import net.consensys.cava.rlpx.HandshakeMessage;
import net.consensys.cava.rlpx.InitiatorHandshakeMessage;
import net.consensys.cava.rlpx.InvalidMACException;
import net.consensys.cava.rlpx.RLPxConnection;
import net.consensys.cava.rlpx.ResponderHandshakeMessage;
import org.bouncycastle.crypto.BasicAgreement;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DerivationFunction;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.modes.SICBlockCipher;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.IESWithCipherParameters;
import org.bouncycastle.crypto.params.KDFParameters;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.BigIntegers;

public final class RLPxConnectionFactory {
    private static final SecureRandom random = new SecureRandom();

    public static AsyncResult<RLPxConnection> createHandshake(SECP256K1.KeyPair keyPair, SECP256K1.PublicKey remotePublicKey, Function<Bytes, AsyncResult<Bytes>> initAndResponse) {
        Bytes32 nonce = RLPxConnectionFactory.generateRandomBytes32();
        SECP256K1.KeyPair ephemeralKeyPair = SECP256K1.KeyPair.random();
        Bytes initHandshakeMessage = RLPxConnectionFactory.init(keyPair, remotePublicKey, ephemeralKeyPair, nonce);
        AsyncResult<Bytes> response = initAndResponse.apply(initHandshakeMessage);
        return response.thenApply(responseBytes -> {
            HandshakeMessage responseMessage = RLPxConnectionFactory.readResponse(responseBytes, keyPair.secretKey());
            return RLPxConnectionFactory.createConnection(true, initHandshakeMessage, responseBytes, ephemeralKeyPair.secretKey(), responseMessage.ephemeralPublicKey(), nonce, responseMessage.nonce(), keyPair.publicKey(), remotePublicKey);
        });
    }

    public static RLPxConnection respondToHandshake(Bytes initiatorMessageBytes, SECP256K1.KeyPair keyPair, Consumer<Bytes> responseHandler) {
        InitiatorHandshakeMessage initiatorHandshakeMessage = RLPxConnectionFactory.read(initiatorMessageBytes, keyPair.secretKey());
        Bytes32 nonce = Bytes32.wrap((byte[])new byte[32]);
        random.nextBytes(nonce.toArrayUnsafe());
        SECP256K1.KeyPair ephemeralKeyPair = SECP256K1.KeyPair.random();
        SECP256K1.PublicKey initiatorPublicKey = initiatorHandshakeMessage.publicKey();
        ResponderHandshakeMessage responderMessage = ResponderHandshakeMessage.create(ephemeralKeyPair.publicKey(), nonce);
        Bytes responseBytes = RLPxConnectionFactory.encryptMessage(responderMessage.encode(), initiatorPublicKey);
        responseHandler.accept(responseBytes);
        return RLPxConnectionFactory.createConnection(false, initiatorMessageBytes, responseBytes, ephemeralKeyPair.secretKey(), initiatorHandshakeMessage.ephemeralPublicKey(), initiatorHandshakeMessage.nonce(), nonce, keyPair.publicKey(), initiatorPublicKey);
    }

    public static Bytes init(SECP256K1.KeyPair keyPair, SECP256K1.PublicKey remotePublicKey, SECP256K1.KeyPair ephemeralKeyPair, Bytes32 initiatorNonce) {
        Bytes32 sharedSecret = SECP256K1.calculateKeyAgreement((SECP256K1.SecretKey)keyPair.secretKey(), (SECP256K1.PublicKey)remotePublicKey);
        InitiatorHandshakeMessage message = InitiatorHandshakeMessage.create(keyPair.publicKey(), ephemeralKeyPair, sharedSecret, initiatorNonce);
        return RLPxConnectionFactory.encryptMessage(message.encode(), remotePublicKey);
    }

    public static HandshakeMessage readResponse(Bytes response, SECP256K1.SecretKey privateKey) {
        return ResponderHandshakeMessage.decode(RLPxConnectionFactory.decryptMessage(response, privateKey));
    }

    public static Bytes32 generateRandomBytes32() {
        Bytes32 nonce = Bytes32.wrap((byte[])new byte[32]);
        random.nextBytes(nonce.toArrayUnsafe());
        return nonce;
    }

    public static RLPxConnection createConnection(boolean initiator, Bytes initiatorMessage, Bytes responderMessage, SECP256K1.SecretKey ourEphemeralPrivateKey, SECP256K1.PublicKey peerEphemeralPublicKey, Bytes32 initiatorNonce, Bytes32 responderNonce, SECP256K1.PublicKey ourPublicKey, SECP256K1.PublicKey peerPublicKey) {
        Bytes32 agreedSecret = SECP256K1.calculateKeyAgreement((SECP256K1.SecretKey)ourEphemeralPrivateKey, (SECP256K1.PublicKey)peerEphemeralPublicKey);
        Bytes32 sharedSecret = Hash.keccak256((Bytes)Bytes.concatenate((Bytes[])new Bytes[]{agreedSecret, Hash.keccak256((Bytes)Bytes.concatenate((Bytes[])new Bytes[]{responderNonce, initiatorNonce}))}));
        Bytes32 aesSecret = Hash.keccak256((Bytes)Bytes.concatenate((Bytes[])new Bytes[]{agreedSecret, sharedSecret}));
        Bytes32 macSecret = Hash.keccak256((Bytes)Bytes.concatenate((Bytes[])new Bytes[]{agreedSecret, aesSecret}));
        Bytes32 token = Hash.keccak256((Bytes)sharedSecret);
        Bytes initiatorMac = Bytes.concatenate((Bytes[])new Bytes[]{macSecret.xor(responderNonce), initiatorMessage});
        Bytes responderMac = Bytes.concatenate((Bytes[])new Bytes[]{macSecret.xor(initiatorNonce), responderMessage});
        if (initiator) {
            return new RLPxConnection(aesSecret, macSecret, token, initiatorMac, responderMac, ourPublicKey, peerPublicKey);
        }
        return new RLPxConnection(aesSecret, macSecret, token, responderMac, initiatorMac, ourPublicKey, peerPublicKey);
    }

    static InitiatorHandshakeMessage read(Bytes payload, SECP256K1.SecretKey privateKey) {
        return InitiatorHandshakeMessage.decode(RLPxConnectionFactory.decryptMessage(payload, privateKey), privateKey);
    }

    static Bytes encryptMessage(Bytes message, SECP256K1.PublicKey remoteKey) {
        byte[] encrypted;
        byte[] ivb = new byte[16];
        random.nextBytes(ivb);
        Bytes iv = Bytes.wrap((byte[])ivb);
        SECP256K1.KeyPair ephemeralKeyPair = SECP256K1.KeyPair.random();
        Bytes bytes = RLPxConnectionFactory.addPadding(message);
        int size = bytes.size() + 65 + 16 + 32;
        Bytes sizePrefix = Bytes.of((byte[])new byte[]{(byte)(size >>> 8), (byte)size});
        EthereumIESEncryptionEngine engine = RLPxConnectionFactory.forEncryption(remoteKey, iv, sizePrefix, ephemeralKeyPair);
        try {
            encrypted = engine.processBlock(bytes.toArrayUnsafe(), 0, bytes.size());
        }
        catch (InvalidCipherTextException e) {
            throw new IllegalArgumentException(e);
        }
        Bytes finalBytes = Bytes.concatenate((Bytes[])new Bytes[]{Bytes.of((byte[])new byte[]{sizePrefix.get(0), sizePrefix.get(1), 4}), ephemeralKeyPair.publicKey().bytes(), iv, Bytes.wrap((byte[])encrypted)});
        return finalBytes;
    }

    private static EthereumIESEncryptionEngine forEncryption(SECP256K1.PublicKey pubKey, Bytes iv, Bytes commonMac, SECP256K1.KeyPair ephemeralKeyPair) {
        ECPublicKeyParameters pubParam = new ECPublicKeyParameters(pubKey.asEcPoint(), SECP256K1.Parameters.CURVE);
        ECPrivateKeyParameters privParam = new ECPrivateKeyParameters(ephemeralKeyPair.secretKey().bytes().toUnsignedBigInteger(), SECP256K1.Parameters.CURVE);
        ECDHBasicAgreement agree = new ECDHBasicAgreement();
        agree.init((CipherParameters)privParam);
        BigInteger z = agree.calculateAgreement((CipherParameters)pubParam);
        byte[] zbytes = BigIntegers.asUnsignedByteArray((int)agree.getFieldSize(), (BigInteger)z);
        IESWithCipherParameters iesWithCipherParameters = new IESWithCipherParameters(new byte[0], new byte[0], 128, 128);
        EthereumIESEncryptionEngine.ECIESHandshakeKDFFunction kdf = new EthereumIESEncryptionEngine.ECIESHandshakeKDFFunction(1, (Digest)new SHA256Digest());
        kdf.init((DerivationParameters)new KDFParameters(zbytes, iesWithCipherParameters.getDerivationV()));
        EthereumIESEncryptionEngine engine = new EthereumIESEncryptionEngine((BasicAgreement)agree, (DerivationFunction)kdf, (Mac)new HMac((Digest)new SHA256Digest()), commonMac.toArrayUnsafe(), new BufferedBlockCipher((BlockCipher)new SICBlockCipher((BlockCipher)new AESEngine())));
        ParametersWithIV cipherParameters = new ParametersWithIV((CipherParameters)iesWithCipherParameters, iv.toArrayUnsafe());
        engine.init(true, (CipherParameters)privParam, (CipherParameters)pubParam, (CipherParameters)cipherParameters);
        return engine;
    }

    public static int messageSize(Bytes msgBytes) {
        Bytes commonMac = msgBytes.slice(0, 2);
        int size = (commonMac.get(1) & 0xFF) + ((commonMac.get(0) & 0xFF) << 8);
        return size + 2;
    }

    static Bytes decryptMessage(Bytes msgBytes, SECP256K1.SecretKey ourKey) {
        byte[] result;
        Bytes commonMac = msgBytes.slice(0, 2);
        int size = (commonMac.get(1) & 0xFF) + ((commonMac.get(0) & 0xFF) << 8);
        SECP256K1.PublicKey ephemeralPublicKey = SECP256K1.PublicKey.fromBytes((Bytes)msgBytes.slice(3, 64));
        Bytes iv = msgBytes.slice(67, 16);
        Bytes encrypted = msgBytes.slice(83, size - 81);
        EthereumIESEncryptionEngine decryptor = RLPxConnectionFactory.forDecryption(ourKey, ephemeralPublicKey, iv, commonMac);
        try {
            result = decryptor.processBlock(encrypted.toArrayUnsafe(), 0, encrypted.size());
        }
        catch (InvalidCipherTextException e) {
            throw new InvalidMACException(e);
        }
        return Bytes.wrap((byte[])result);
    }

    private static Bytes addPadding(Bytes message) {
        int padding = 100 + random.nextInt(200);
        byte[] paddingBytes = new byte[padding];
        random.nextBytes(paddingBytes);
        return Bytes.concatenate((Bytes[])new Bytes[]{message, Bytes.wrap((byte[])paddingBytes)});
    }

    private static EthereumIESEncryptionEngine forDecryption(SECP256K1.SecretKey privateKey, SECP256K1.PublicKey ephemeralPublicKey, Bytes iv, Bytes commonMac) {
        ECPublicKeyParameters pubParam = new ECPublicKeyParameters(ephemeralPublicKey.asEcPoint(), SECP256K1.Parameters.CURVE);
        ECPrivateKeyParameters privParam = new ECPrivateKeyParameters(privateKey.bytes().toUnsignedBigInteger(), SECP256K1.Parameters.CURVE);
        ECDHBasicAgreement agreement = new ECDHBasicAgreement();
        agreement.init((CipherParameters)privParam);
        byte[] agreementValue = BigIntegers.asUnsignedByteArray((int)agreement.getFieldSize(), (BigInteger)agreement.calculateAgreement((CipherParameters)pubParam));
        IESWithCipherParameters iesWithCipherParameters = new IESWithCipherParameters(new byte[0], new byte[0], 128, 128);
        EthereumIESEncryptionEngine.ECIESHandshakeKDFFunction kdf = new EthereumIESEncryptionEngine.ECIESHandshakeKDFFunction(1, (Digest)new SHA256Digest());
        kdf.init((DerivationParameters)new KDFParameters(agreementValue, iesWithCipherParameters.getDerivationV()));
        EthereumIESEncryptionEngine engine = new EthereumIESEncryptionEngine((BasicAgreement)agreement, (DerivationFunction)kdf, (Mac)new HMac((Digest)new SHA256Digest()), commonMac.toArrayUnsafe(), new BufferedBlockCipher((BlockCipher)new SICBlockCipher((BlockCipher)new AESEngine())));
        ParametersWithIV cipherParameters = new ParametersWithIV((CipherParameters)iesWithCipherParameters, iv.toArrayUnsafe());
        engine.init(false, (CipherParameters)privParam, (CipherParameters)pubParam, (CipherParameters)cipherParameters);
        return engine;
    }
}

