/*
 * Decompiled with CFR 0.152.
 */
package net.consensys.cava.rlpx;

import net.consensys.cava.bytes.Bytes;
import net.consensys.cava.bytes.Bytes32;
import net.consensys.cava.crypto.SECP256K1;
import net.consensys.cava.rlp.RLP;
import net.consensys.cava.rlpx.HandshakeMessage;

final class ResponderHandshakeMessage
implements HandshakeMessage {
    private final SECP256K1.PublicKey ephemeralPublicKey;
    private final Bytes32 nonce;

    static ResponderHandshakeMessage create(SECP256K1.PublicKey ephemeralPublicKey, Bytes32 nonce) {
        return new ResponderHandshakeMessage(ephemeralPublicKey, nonce);
    }

    static ResponderHandshakeMessage decode(Bytes payload) {
        return (ResponderHandshakeMessage)RLP.decodeList((Bytes)payload, reader -> new ResponderHandshakeMessage(SECP256K1.PublicKey.fromBytes((Bytes)reader.readValue()), Bytes32.wrap((Bytes)reader.readValue())));
    }

    private ResponderHandshakeMessage(SECP256K1.PublicKey ephemeralPublicKey, Bytes32 nonce) {
        this.ephemeralPublicKey = ephemeralPublicKey;
        this.nonce = nonce;
    }

    @Override
    public SECP256K1.PublicKey ephemeralPublicKey() {
        return this.ephemeralPublicKey;
    }

    @Override
    public Bytes32 nonce() {
        return this.nonce;
    }

    Bytes encode() {
        return RLP.encodeList(writer -> {
            writer.writeValue(this.ephemeralPublicKey.bytes());
            writer.writeValue((Bytes)this.nonce);
            writer.writeInt(4);
        });
    }
}

