/*
 * Decompiled with CFR 0.152.
 */
package net.consensys.cava.rlpx.wire;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.consensys.cava.bytes.Bytes;
import net.consensys.cava.rlp.RLP;
import net.consensys.cava.rlpx.wire.Capability;
import net.consensys.cava.rlpx.wire.WireProtocolMessage;

public final class HelloMessage
implements WireProtocolMessage {
    private final Bytes nodeId;
    private final int listenPort;
    private final String clientId;
    private final int p2pVersion;
    private final List<Capability> capabilities;

    private HelloMessage(Bytes nodeId, int listenPort, String clientId, int p2pVersion, List<Capability> capabilities) {
        this.nodeId = nodeId;
        this.listenPort = listenPort;
        this.clientId = clientId;
        this.p2pVersion = p2pVersion;
        this.capabilities = capabilities;
    }

    static HelloMessage create(Bytes nodeId, int listenPort, int p2pVersion, String clientId, List<Capability> capabilities) {
        return new HelloMessage(nodeId, listenPort, clientId, p2pVersion, capabilities);
    }

    static HelloMessage read(Bytes data) {
        return (HelloMessage)RLP.decodeList((Bytes)data, reader -> {
            int p2pVersion = reader.readInt();
            String clientId = reader.readString();
            List capabilities = (List)reader.readList(capabilitiesReader -> {
                ArrayList<Capability> caps = new ArrayList<Capability>();
                while (!capabilitiesReader.isComplete()) {
                    caps.add((Capability)capabilitiesReader.readList(capabilityReader -> new Capability(capabilityReader.readString(), capabilityReader.readInt())));
                }
                return caps;
            });
            int listenPort = reader.readInt();
            Bytes nodeId = reader.readValue();
            return new HelloMessage(nodeId, listenPort, clientId, p2pVersion, capabilities);
        });
    }

    @Override
    public Bytes toBytes() {
        return RLP.encodeList(writer -> {
            writer.writeInt(this.p2pVersion);
            writer.writeString(this.clientId);
            writer.writeList(capabilitiesWriter -> {
                for (Capability cap : this.capabilities) {
                    capabilitiesWriter.writeList(capabilityWriter -> {
                        capabilityWriter.writeString(cap.name());
                        capabilityWriter.writeInt(cap.version());
                    });
                }
            });
            writer.writeInt(this.listenPort);
            writer.writeValue(this.nodeId);
        });
    }

    @Override
    public int messageType() {
        return 0;
    }

    Bytes nodeId() {
        return this.nodeId;
    }

    List<Capability> capabilities() {
        return this.capabilities;
    }

    public int p2pVersion() {
        return this.p2pVersion;
    }

    String clientId() {
        return this.clientId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HelloMessage that = (HelloMessage)o;
        if (this.capabilities.size() != that.capabilities.size()) {
            return false;
        }
        for (int i = 0; i < this.capabilities.size(); ++i) {
            if (Objects.equals(this.capabilities.get(i), that.capabilities.get(i))) continue;
            return false;
        }
        return this.listenPort == that.listenPort && this.p2pVersion == that.p2pVersion && Objects.equals(this.nodeId, that.nodeId) && Objects.equals(this.clientId, that.clientId);
    }

    public int hashCode() {
        return Objects.hash(this.nodeId, this.listenPort, this.clientId, this.p2pVersion, this.capabilities);
    }

    public String toString() {
        return "HelloMessage{nodeId=" + this.nodeId + ", listenPort=" + this.listenPort + ", clientId='" + this.clientId + '\'' + ", p2pVersion=" + this.p2pVersion + ", capabilities=" + this.capabilities + '}';
    }
}

