/*
 * Decompiled with CFR 0.152.
 */
package net.consensys.cava.ssz;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.LongFunction;
import java.util.function.Supplier;
import net.consensys.cava.bytes.Bytes;
import net.consensys.cava.ssz.EndOfSSZException;
import net.consensys.cava.ssz.InvalidSSZTypeException;
import net.consensys.cava.ssz.SSZReader;
import net.consensys.cava.units.bigints.UInt256;

final class BytesSSZReader
implements SSZReader {
    private final Bytes content;
    private int index = 0;

    BytesSSZReader(Bytes content) {
        this.content = content;
    }

    @Override
    public Bytes readBytes(int limit) {
        int size;
        int byteLength = 4;
        this.ensureBytes(byteLength, () -> "SSZ encoded data is not a byte array");
        try {
            size = this.content.getInt(this.index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new EndOfSSZException();
        }
        if (size < 0 || size > limit) {
            throw new InvalidSSZTypeException("length of bytes would exceed limit");
        }
        this.index += 4;
        if (this.content.size() - this.index - size < 0) {
            throw new InvalidSSZTypeException("SSZ encoded data has insufficient bytes for decoded byte array length");
        }
        return this.consumeBytes(size);
    }

    @Override
    public int readInt(int bitLength) {
        Preconditions.checkArgument((bitLength % 8 == 0 ? 1 : 0) != 0, (Object)"bitLength must be a multiple of 8");
        int byteLength = bitLength / 8;
        this.ensureBytes(byteLength, () -> "SSZ encoded data has insufficient length to read a " + bitLength + "-bit integer");
        Bytes bytes = this.content.slice(this.index, byteLength);
        int zeroBytes = bytes.numberOfLeadingZeroBytes();
        if (byteLength - zeroBytes > 4) {
            throw new InvalidSSZTypeException("decoded integer is too large for an int");
        }
        this.index += byteLength;
        return bytes.slice(zeroBytes).toInt();
    }

    @Override
    public long readLong(int bitLength) {
        Preconditions.checkArgument((bitLength % 8 == 0 ? 1 : 0) != 0, (Object)"bitLength must be a multiple of 8");
        int byteLength = bitLength / 8;
        this.ensureBytes(byteLength, () -> "SSZ encoded data has insufficient length to read a " + bitLength + "-bit integer");
        Bytes bytes = this.content.slice(this.index, byteLength);
        int zeroBytes = this.content.numberOfLeadingZeroBytes();
        if (byteLength - zeroBytes > 8) {
            throw new InvalidSSZTypeException("decoded integer is too large for an int");
        }
        this.index += byteLength;
        return bytes.slice(zeroBytes).toLong();
    }

    @Override
    public BigInteger readBigInteger(int bitLength) {
        Preconditions.checkArgument((bitLength % 8 == 0 ? 1 : 0) != 0, (Object)"bitLength must be a multiple of 8");
        int byteLength = bitLength / 8;
        this.ensureBytes(byteLength, () -> "SSZ encoded data has insufficient length to read a " + bitLength + "-bit integer");
        return this.consumeBytes(byteLength).toBigInteger();
    }

    @Override
    public BigInteger readUnsignedBigInteger(int bitLength) {
        Preconditions.checkArgument((bitLength % 8 == 0 ? 1 : 0) != 0, (Object)"bitLength must be a multiple of 8");
        int byteLength = bitLength / 8;
        this.ensureBytes(byteLength, () -> "SSZ encoded data has insufficient length to read a " + bitLength + "-bit integer");
        return this.consumeBytes(byteLength).toUnsignedBigInteger();
    }

    @Override
    public UInt256 readUInt256() {
        this.ensureBytes(32, () -> "SSZ encoded data has insufficient length to read a 256-bit integer");
        return UInt256.fromBytes((Bytes)this.consumeBytes(32));
    }

    @Override
    public Bytes readAddress() {
        this.ensureBytes(20, () -> "SSZ encoded data has insufficient length to read a 20-byte address");
        return this.consumeBytes(20);
    }

    @Override
    public Bytes readHash(int hashLength) {
        this.ensureBytes(hashLength, () -> "SSZ encoded data has insufficient length to read a " + hashLength + "-byte hash");
        return this.consumeBytes(hashLength);
    }

    @Override
    public List<Bytes> readBytesList(int limit) {
        return this.readList(remaining -> this.readByteArray(limit), Bytes::wrap);
    }

    @Override
    public List<String> readStringList(int limit) {
        return this.readList(remaining -> this.readByteArray(limit), (byte[] byteArray) -> new String((byte[])byteArray, StandardCharsets.UTF_8));
    }

    @Override
    public List<Integer> readIntList(int bitLength) {
        Preconditions.checkArgument((bitLength % 8 == 0 ? 1 : 0) != 0, (Object)"bitLength must be a multiple of 8");
        return this.readList(bitLength / 8, () -> this.readInt(bitLength));
    }

    @Override
    public List<Long> readLongIntList(int bitLength) {
        Preconditions.checkArgument((bitLength % 8 == 0 ? 1 : 0) != 0, (Object)"bitLength must be a multiple of 8");
        return this.readList(bitLength / 8, () -> this.readLong(bitLength));
    }

    @Override
    public List<BigInteger> readBigIntegerList(int bitLength) {
        Preconditions.checkArgument((bitLength % 8 == 0 ? 1 : 0) != 0, (Object)"bitLength must be a multiple of 8");
        return this.readList(bitLength / 8, () -> this.readBigInteger(bitLength));
    }

    @Override
    public List<BigInteger> readUnsignedBigIntegerList(int bitLength) {
        Preconditions.checkArgument((bitLength % 8 == 0 ? 1 : 0) != 0, (Object)"bitLength must be a multiple of 8");
        return this.readList(bitLength / 8, () -> this.readUnsignedBigInteger(bitLength));
    }

    @Override
    public List<UInt256> readUInt256List() {
        return this.readList(32, this::readUInt256);
    }

    @Override
    public List<Bytes> readAddressList() {
        return this.readList(20, this::readAddress);
    }

    @Override
    public List<Bytes> readHashList(int hashLength) {
        return this.readList(hashLength, () -> this.readHash(hashLength));
    }

    @Override
    public List<Boolean> readBooleanList() {
        return this.readList(1, this::readBoolean);
    }

    @Override
    public boolean isComplete() {
        return this.index >= this.content.size();
    }

    private void ensureBytes(int byteLength, Supplier<String> message) {
        if (this.index == this.content.size()) {
            throw new EndOfSSZException();
        }
        if (this.content.size() - this.index - byteLength < 0) {
            throw new InvalidSSZTypeException(message.get());
        }
    }

    private Bytes consumeBytes(int size) {
        Bytes bytes = this.content.slice(this.index, size);
        this.index += size;
        return bytes;
    }

    private <T> List<T> readList(LongFunction<byte[]> bytesSupplier, Function<byte[], T> converter) {
        ArrayList<T> elements;
        this.ensureBytes(4, () -> "SSZ encoded data is not a list");
        int originalIndex = this.index;
        try {
            long listSize = this.consumeBytes(4).toLong();
            elements = new ArrayList<T>();
            while (listSize > 0L) {
                byte[] bytes = bytesSupplier.apply(listSize);
                elements.add(converter.apply(bytes));
                if ((listSize -= (long)bytes.length) >= 0L) continue;
                throw new InvalidSSZTypeException("SSZ encoded list length does not align with lengths of its elements");
            }
        }
        catch (Exception e) {
            this.index = originalIndex;
            throw e;
        }
        return elements;
    }

    private <T> List<T> readList(int elementSize, Supplier<T> elementSupplier) {
        ArrayList<T> bytesList;
        this.ensureBytes(4, () -> "SSZ encoded data is not a list");
        int originalIndex = this.index;
        try {
            int listSize = this.consumeBytes(4).toInt();
            if (listSize % elementSize != 0) {
                throw new InvalidSSZTypeException("SSZ encoded list length does not align with lengths of its elements");
            }
            int nElements = listSize / elementSize;
            bytesList = new ArrayList<T>(nElements);
            for (int i = 0; i < nElements; ++i) {
                bytesList.add(elementSupplier.get());
            }
        }
        catch (Exception e) {
            this.index = originalIndex;
            throw e;
        }
        return bytesList;
    }
}

