/*
 * Decompiled with CFR 0.152.
 */
package net.consensys.cava.ssz;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.consensys.cava.bytes.Bytes;
import net.consensys.cava.ssz.ByteBufferSSZWriter;
import net.consensys.cava.ssz.BytesSSZReader;
import net.consensys.cava.ssz.BytesSSZWriter;
import net.consensys.cava.ssz.SSZReader;
import net.consensys.cava.ssz.SSZWriter;
import net.consensys.cava.units.bigints.UInt256;

public final class SSZ {
    private static final Bytes TRUE = Bytes.of((byte[])new byte[]{1});
    private static final Bytes FALSE = Bytes.of((byte[])new byte[]{0});

    private SSZ() {
    }

    public static Bytes encode(Consumer<SSZWriter> fn) {
        Objects.requireNonNull(fn);
        BytesSSZWriter writer = new BytesSSZWriter();
        fn.accept(writer);
        return writer.toBytes();
    }

    public static <T extends ByteBuffer> T encodeTo(T buffer, Consumer<SSZWriter> fn) {
        Objects.requireNonNull(buffer);
        Objects.requireNonNull(fn);
        ByteBufferSSZWriter writer = new ByteBufferSSZWriter(buffer);
        fn.accept(writer);
        return buffer;
    }

    public static Bytes encodeBytes(Bytes value) {
        Bytes lengthBytes = SSZ.encodeLong(value.size(), 32);
        return Bytes.wrap((Bytes[])new Bytes[]{lengthBytes, value});
    }

    static void encodeBytesTo(Bytes value, Consumer<Bytes> appender) {
        appender.accept(SSZ.encodeLong(value.size(), 32));
        appender.accept(value);
    }

    public static Bytes encodeByteArray(byte[] value) {
        return SSZ.encodeBytes(Bytes.wrap((byte[])value));
    }

    static void encodeByteArrayTo(byte[] value, Consumer<byte[]> appender) {
        appender.accept(SSZ.encodeLongToByteArray(value.length, 32));
        appender.accept(value);
    }

    public static Bytes encodeString(String str) {
        return SSZ.encodeByteArray(str.getBytes(StandardCharsets.UTF_8));
    }

    static void encodeStringTo(String str, Consumer<byte[]> appender) {
        SSZ.encodeByteArrayTo(str.getBytes(StandardCharsets.UTF_8), appender);
    }

    public static Bytes encodeInt(int value, int bitLength) {
        return SSZ.encodeLong(value, bitLength);
    }

    public static Bytes encodeLong(long value, int bitLength) {
        return Bytes.wrap((byte[])SSZ.encodeLongToByteArray(value, bitLength));
    }

    static byte[] encodeLongToByteArray(long value, int bitLength) {
        Preconditions.checkArgument((bitLength % 8 == 0 ? 1 : 0) != 0, (Object)"bitLength must be a multiple of 8");
        int zeros = value >= 0L ? Long.numberOfLeadingZeros(value) : Long.numberOfLeadingZeros(-1L - value) - 1;
        int valueBytes = 8 - zeros / 8;
        int byteLength = bitLength / 8;
        Preconditions.checkArgument((valueBytes <= byteLength ? 1 : 0) != 0, (Object)"value is too large for the desired bitLength");
        byte[] encoded = new byte[byteLength];
        int shift = 0;
        for (int i = 1; i <= valueBytes; ++i) {
            encoded[byteLength - i] = (byte)(value >> shift & 0xFFL);
            shift += 8;
        }
        if (value < 0L) {
            int padLength = byteLength - valueBytes;
            for (int i = 0; i < padLength; ++i) {
                encoded[i] = -1;
            }
        }
        return encoded;
    }

    public static Bytes encodeBigInteger(BigInteger value, int bitLength) {
        return Bytes.wrap((byte[])SSZ.encodeBigIntegerToByteArray(value, bitLength));
    }

    public static byte[] encodeBigIntegerToByteArray(BigInteger value, int bitLength) {
        int byteLength;
        Preconditions.checkArgument((bitLength % 8 == 0 ? 1 : 0) != 0, (Object)"bitLength must be a multiple of 8");
        byte[] bytes = value.toByteArray();
        int valueBytes = bytes.length;
        int offset = 0;
        if (value.signum() >= 0 && bytes[0] == 0) {
            valueBytes = bytes.length - 1;
            offset = 1;
        }
        Preconditions.checkArgument((valueBytes <= (byteLength = bitLength / 8) ? 1 : 0) != 0, (Object)"value is too large for the desired bitLength");
        if (valueBytes == byteLength && offset == 0) {
            return bytes;
        }
        byte[] encoded = new byte[byteLength];
        int padLength = byteLength - valueBytes;
        System.arraycopy(bytes, offset, encoded, padLength, valueBytes);
        if (value.signum() < 0) {
            for (int i = 0; i < padLength; ++i) {
                encoded[i] = -1;
            }
        }
        return encoded;
    }

    public static Bytes encodeInt8(int value) {
        return SSZ.encodeInt(value, 8);
    }

    public static Bytes encodeInt16(int value) {
        return SSZ.encodeInt(value, 16);
    }

    public static Bytes encodeInt32(int value) {
        return SSZ.encodeInt(value, 32);
    }

    public static Bytes encodeInt64(long value) {
        return SSZ.encodeLong(value, 64);
    }

    public static Bytes encodeUInt(int value, int bitLength) {
        return SSZ.encodeULong(value, bitLength);
    }

    public static Bytes encodeULong(long value, int bitLength) {
        return Bytes.wrap((byte[])SSZ.encodeULongToByteArray(value, bitLength));
    }

    static byte[] encodeULongToByteArray(long value, int bitLength) {
        Preconditions.checkArgument((bitLength % 8 == 0 ? 1 : 0) != 0, (Object)"bitLength must be a multiple of 8");
        int zeros = Long.numberOfLeadingZeros(value);
        int valueBytes = 8 - zeros / 8;
        int byteLength = bitLength / 8;
        Preconditions.checkArgument((valueBytes <= byteLength ? 1 : 0) != 0, (Object)"value is too large for the desired bitLength");
        byte[] encoded = new byte[byteLength];
        int shift = 0;
        for (int i = 1; i <= valueBytes; ++i) {
            encoded[byteLength - i] = (byte)(value >> shift & 0xFFL);
            shift += 8;
        }
        return encoded;
    }

    public static Bytes encodeUInt8(int value) {
        return SSZ.encodeUInt(value, 8);
    }

    public static Bytes encodeUInt16(int value) {
        return SSZ.encodeUInt(value, 16);
    }

    public static Bytes encodeUInt32(long value) {
        return SSZ.encodeULong(value, 32);
    }

    public static Bytes encodeUInt64(long value) {
        return SSZ.encodeULong(value, 64);
    }

    public static Bytes encodeUInt256(UInt256 value) {
        return value.toBytes();
    }

    public static Bytes encodeBoolean(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static Bytes encodeAddress(Bytes address) {
        Preconditions.checkArgument((address.size() == 20 ? 1 : 0) != 0, (Object)"address is not 20 bytes");
        return address;
    }

    public static Bytes encodeHash(Bytes hash) {
        return hash;
    }

    public static Bytes encodeBytesList(Bytes ... elements) {
        ArrayList encoded = new ArrayList(elements.length * 2 + 1);
        SSZ.encodeBytesListTo(elements, encoded::add);
        return Bytes.wrap((Bytes[])encoded.toArray(new Bytes[0]));
    }

    static void encodeBytesListTo(Bytes[] elements, Consumer<Bytes> appender) {
        long listSize = 0L;
        for (Bytes bytes : elements) {
            listSize += 4L;
            if ((listSize += (long)bytes.size()) <= Integer.MAX_VALUE) continue;
            throw new IllegalArgumentException("Cannot serialize list: overall length is too large");
        }
        appender.accept(SSZ.encodeUInt32(listSize));
        for (Bytes bytes : elements) {
            SSZ.encodeBytesTo(bytes, appender);
        }
    }

    public static Bytes encodeStringList(String ... elements) {
        ArrayList encoded = new ArrayList(elements.length * 2 + 1);
        SSZ.encodeStringListTo(elements, b -> encoded.add(Bytes.wrap((Bytes[])new Bytes[]{b})));
        return Bytes.wrap((Bytes[])encoded.toArray(new Bytes[0]));
    }

    static void encodeStringListTo(String[] elements, Consumer<Bytes> appender) {
        Bytes[] elementBytes = new Bytes[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            elementBytes[i] = Bytes.wrap((byte[])elements[i].getBytes(StandardCharsets.UTF_8));
        }
        SSZ.encodeBytesListTo(elementBytes, appender);
    }

    public static Bytes encodeIntList(int bitLength, int ... elements) {
        ArrayList encoded = new ArrayList(elements.length + 1);
        SSZ.encodeIntListTo(bitLength, elements, b -> encoded.add(Bytes.wrap((byte[])b)));
        return Bytes.wrap((Bytes[])encoded.toArray(new Bytes[0]));
    }

    static void encodeIntListTo(int bitLength, int[] elements, Consumer<byte[]> appender) {
        Preconditions.checkArgument((bitLength % 8 == 0 ? 1 : 0) != 0, (Object)"bitLength must be a multiple of 8");
        appender.accept(SSZ.listLengthPrefix(elements.length, bitLength / 8));
        for (int value : elements) {
            appender.accept(SSZ.encodeLongToByteArray(value, bitLength));
        }
    }

    public static Bytes encodeLongIntList(int bitLength, long ... elements) {
        ArrayList encoded = new ArrayList(elements.length + 1);
        SSZ.encodeLongIntListTo(bitLength, elements, b -> encoded.add(Bytes.wrap((byte[])b)));
        return Bytes.wrap((Bytes[])encoded.toArray(new Bytes[0]));
    }

    static void encodeLongIntListTo(int bitLength, long[] elements, Consumer<byte[]> appender) {
        Preconditions.checkArgument((bitLength % 8 == 0 ? 1 : 0) != 0, (Object)"bitLength must be a multiple of 8");
        appender.accept(SSZ.listLengthPrefix(elements.length, bitLength / 8));
        for (long value : elements) {
            appender.accept(SSZ.encodeLongToByteArray(value, bitLength));
        }
    }

    public static Bytes encodeBigIntegerList(int bitLength, BigInteger ... elements) {
        ArrayList encoded = new ArrayList(elements.length + 1);
        SSZ.encodeBigIntegerListTo(bitLength, elements, b -> encoded.add(Bytes.wrap((byte[])b)));
        return Bytes.wrap((Bytes[])encoded.toArray(new Bytes[0]));
    }

    static void encodeBigIntegerListTo(int bitLength, BigInteger[] elements, Consumer<byte[]> appender) {
        Preconditions.checkArgument((bitLength % 8 == 0 ? 1 : 0) != 0, (Object)"bitLength must be a multiple of 8");
        appender.accept(SSZ.listLengthPrefix(elements.length, bitLength / 8));
        for (BigInteger value : elements) {
            appender.accept(SSZ.encodeBigIntegerToByteArray(value, bitLength));
        }
    }

    public static Bytes encodeInt8List(int ... elements) {
        return SSZ.encodeIntList(8, elements);
    }

    public static Bytes encodeInt16List(int ... elements) {
        return SSZ.encodeIntList(16, elements);
    }

    public static Bytes encodeInt32List(int ... elements) {
        return SSZ.encodeIntList(32, elements);
    }

    public static Bytes encodeInt64List(long ... elements) {
        return SSZ.encodeLongIntList(64, elements);
    }

    public static Bytes encodeUIntList(int bitLength, int ... elements) {
        ArrayList encoded = new ArrayList(elements.length + 1);
        SSZ.encodeUIntListTo(bitLength, elements, b -> encoded.add(Bytes.wrap((byte[])b)));
        return Bytes.wrap((Bytes[])encoded.toArray(new Bytes[0]));
    }

    static void encodeUIntListTo(int bitLength, int[] elements, Consumer<byte[]> appender) {
        Preconditions.checkArgument((bitLength % 8 == 0 ? 1 : 0) != 0, (Object)"bitLength must be a multiple of 8");
        appender.accept(SSZ.listLengthPrefix(elements.length, bitLength / 8));
        for (int value : elements) {
            appender.accept(SSZ.encodeULongToByteArray(value, bitLength));
        }
    }

    public static Bytes encodeULongIntList(int bitLength, long ... elements) {
        ArrayList encoded = new ArrayList(elements.length + 1);
        SSZ.encodeULongIntListTo(bitLength, elements, b -> encoded.add(Bytes.wrap((byte[])b)));
        return Bytes.wrap((Bytes[])encoded.toArray(new Bytes[0]));
    }

    static void encodeULongIntListTo(int bitLength, long[] elements, Consumer<byte[]> appender) {
        Preconditions.checkArgument((bitLength % 8 == 0 ? 1 : 0) != 0, (Object)"bitLength must be a multiple of 8");
        appender.accept(SSZ.listLengthPrefix(elements.length, bitLength / 8));
        for (long value : elements) {
            appender.accept(SSZ.encodeULongToByteArray(value, bitLength));
        }
    }

    public static Bytes encodeUInt8List(int ... elements) {
        return SSZ.encodeUIntList(8, elements);
    }

    public static Bytes encodeUInt16List(int ... elements) {
        return SSZ.encodeUIntList(16, elements);
    }

    public static Bytes encodeUInt32List(long ... elements) {
        return SSZ.encodeULongIntList(32, elements);
    }

    public static Bytes encodeUInt64List(long ... elements) {
        return SSZ.encodeULongIntList(64, elements);
    }

    public static Bytes encodeUInt256List(UInt256 ... elements) {
        ArrayList encoded = new ArrayList(elements.length + 1);
        SSZ.encodeUInt256ListTo(elements, b -> encoded.add(Bytes.wrap((Bytes[])new Bytes[]{b})));
        return Bytes.wrap((Bytes[])encoded.toArray(new Bytes[0]));
    }

    static void encodeUInt256ListTo(UInt256[] elements, Consumer<Bytes> appender) {
        appender.accept(Bytes.wrap((byte[])SSZ.listLengthPrefix(elements.length, 32)));
        for (UInt256 value : elements) {
            appender.accept(SSZ.encodeUInt256(value));
        }
    }

    public static Bytes encodeHashList(Bytes ... elements) {
        ArrayList encoded = new ArrayList(elements.length + 1);
        SSZ.encodeHashListTo(elements, b -> encoded.add(Bytes.wrap((Bytes[])new Bytes[]{b})));
        return Bytes.wrap((Bytes[])encoded.toArray(new Bytes[0]));
    }

    static void encodeHashListTo(Bytes[] elements, Consumer<Bytes> appender) {
        int hashLength = 0;
        for (Bytes bytes : elements) {
            if (hashLength == 0) {
                hashLength = bytes.size();
                continue;
            }
            Preconditions.checkArgument((bytes.size() == hashLength ? 1 : 0) != 0, (Object)"Hashes must be all of the same size");
        }
        appender.accept(Bytes.wrap((byte[])SSZ.listLengthPrefix(elements.length, 32)));
        for (Bytes bytes : elements) {
            appender.accept(bytes);
        }
    }

    public static Bytes encodeAddressList(Bytes ... elements) {
        ArrayList encoded = new ArrayList(elements.length + 1);
        SSZ.encodeAddressListTo(elements, b -> encoded.add(Bytes.wrap((Bytes[])new Bytes[]{b})));
        return Bytes.wrap((Bytes[])encoded.toArray(new Bytes[0]));
    }

    static void encodeAddressListTo(Bytes[] elements, Consumer<Bytes> appender) {
        appender.accept(Bytes.wrap((byte[])SSZ.listLengthPrefix(elements.length, 20)));
        for (Bytes bytes : elements) {
            appender.accept(SSZ.encodeAddress(bytes));
        }
    }

    public static Bytes encodeBooleanList(boolean ... elements) {
        ArrayList encoded = new ArrayList(elements.length + 1);
        SSZ.encodeBooleanListTo(elements, b -> encoded.add(Bytes.wrap((Bytes[])new Bytes[]{b})));
        return Bytes.wrap((Bytes[])encoded.toArray(new Bytes[0]));
    }

    static void encodeBooleanListTo(boolean[] elements, Consumer<Bytes> appender) {
        appender.accept(SSZ.encodeInt32(elements.length));
        for (boolean value : elements) {
            appender.accept(SSZ.encodeBoolean(value));
        }
    }

    private static byte[] listLengthPrefix(long nElements, int elementBytes) {
        long listSize;
        try {
            listSize = Math.multiplyExact(nElements, elementBytes);
        }
        catch (ArithmeticException e) {
            listSize = Long.MAX_VALUE;
        }
        if (listSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cannot serialize list: overall length is too large");
        }
        return SSZ.encodeLongToByteArray(listSize, 32);
    }

    public static <T> T decode(Bytes source, Function<SSZReader, T> fn) {
        Objects.requireNonNull(source);
        Objects.requireNonNull(fn);
        return fn.apply(new BytesSSZReader(source));
    }

    public static Bytes decodeBytes(Bytes source) {
        return SSZ.decode(source, SSZReader::readBytes);
    }

    public static Bytes decodeBytes(Bytes source, int limit) {
        return SSZ.decode(source, r -> r.readBytes(limit));
    }

    public static String decodeString(Bytes source) {
        return SSZ.decode(source, SSZReader::readString);
    }

    public static String decodeString(Bytes source, int limit) {
        return SSZ.decode(source, r -> r.readString(limit));
    }

    public static int decodeInt(Bytes source, int bitLength) {
        return SSZ.decode(source, r -> r.readInt(bitLength));
    }

    public static long decodeLong(Bytes source, int bitLength) {
        return SSZ.decode(source, r -> r.readLong(bitLength));
    }

    public static BigInteger decodeBigInteger(Bytes source, int bitLength) {
        return SSZ.decode(source, r -> r.readBigInteger(bitLength));
    }

    public static int decodeInt8(Bytes source) {
        return SSZ.decodeInt(source, 8);
    }

    public static int decodeInt16(Bytes source) {
        return SSZ.decodeInt(source, 16);
    }

    public static int decodeInt32(Bytes source) {
        return SSZ.decodeInt(source, 32);
    }

    public static long decodeInt64(Bytes source) {
        return SSZ.decodeLong(source, 64);
    }

    public static int decodeUInt(Bytes source, int bitLength) {
        return SSZ.decode(source, r -> r.readUInt(bitLength));
    }

    public static long decodeULong(Bytes source, int bitLength) {
        return SSZ.decode(source, r -> r.readULong(bitLength));
    }

    public static BigInteger decodeUnsignedBigInteger(Bytes source, int bitLength) {
        return SSZ.decode(source, r -> r.readBigInteger(bitLength));
    }

    public static int decodeUInt8(Bytes source) {
        return SSZ.decodeUInt(source, 8);
    }

    public static int decodeUInt16(Bytes source) {
        return SSZ.decodeUInt(source, 16);
    }

    public static long decodeUInt32(Bytes source) {
        return SSZ.decodeULong(source, 32);
    }

    public static long decodeUInt64(Bytes source) {
        return SSZ.decodeLong(source, 64);
    }

    public static UInt256 decodeUInt256(Bytes source) {
        return SSZ.decode(source, SSZReader::readUInt256);
    }

    public static boolean decodeBoolean(Bytes source) {
        return SSZ.decode(source, SSZReader::readBoolean);
    }

    public static Bytes decodeAddress(Bytes source) {
        return SSZ.decode(source, SSZReader::readAddress);
    }

    public static Bytes decodeHash(Bytes source, int hashLength) {
        return SSZ.decode(source, r -> r.readHash(hashLength));
    }

    public static List<Bytes> decodeBytesList(Bytes source) {
        return SSZ.decode(source, SSZReader::readBytesList);
    }

    public static List<Bytes> decodeBytesList(Bytes source, int limit) {
        return SSZ.decode(source, r -> r.readBytesList(limit));
    }

    public static List<byte[]> decodeByteArrayList(Bytes source) {
        return SSZ.decode(source, SSZReader::readByteArrayList);
    }

    public static List<byte[]> decodeByteArrayList(Bytes source, int limit) {
        return SSZ.decode(source, r -> r.readByteArrayList(limit));
    }

    public static List<String> decodeStringList(Bytes source) {
        return SSZ.decode(source, SSZReader::readStringList);
    }

    public static List<String> decodeStringList(Bytes source, int limit) {
        return SSZ.decode(source, r -> r.readStringList(limit));
    }

    public static List<Integer> decodeIntList(Bytes source, int bitLength) {
        return SSZ.decode(source, r -> r.readIntList(bitLength));
    }

    public static List<Long> decodeLongIntList(Bytes source, int bitLength) {
        return SSZ.decode(source, r -> r.readLongIntList(bitLength));
    }

    public static List<BigInteger> decodeBigIntegerList(Bytes source, int bitLength) {
        return SSZ.decode(source, r -> r.readBigIntegerList(bitLength));
    }

    public static List<Integer> decodeInt8List(Bytes source) {
        return SSZ.decode(source, SSZReader::readInt8List);
    }

    public static List<Integer> decodeInt16List(Bytes source) {
        return SSZ.decode(source, SSZReader::readInt16List);
    }

    public static List<Integer> decodeInt32List(Bytes source) {
        return SSZ.decode(source, SSZReader::readInt32List);
    }

    public static List<Long> decodeInt64List(Bytes source) {
        return SSZ.decode(source, SSZReader::readInt64List);
    }

    public static List<Integer> decodeUIntList(Bytes source, int bitLength) {
        return SSZ.decode(source, r -> r.readUIntList(bitLength));
    }

    public static List<Long> decodeULongIntList(Bytes source, int bitLength) {
        return SSZ.decode(source, r -> r.readULongIntList(bitLength));
    }

    public static List<BigInteger> decodeUnsignedBigIntegerList(Bytes source, int bitLength) {
        return SSZ.decode(source, r -> r.readUnsignedBigIntegerList(bitLength));
    }

    public static List<Integer> decodeUInt8List(Bytes source) {
        return SSZ.decode(source, SSZReader::readUInt8List);
    }

    public static List<Integer> decodeUInt16List(Bytes source) {
        return SSZ.decode(source, SSZReader::readUInt16List);
    }

    public static List<Long> decodeUInt32List(Bytes source) {
        return SSZ.decode(source, SSZReader::readUInt32List);
    }

    public static List<Long> decodeUInt64List(Bytes source) {
        return SSZ.decode(source, SSZReader::readUInt64List);
    }

    public static List<UInt256> decodeUInt256List(Bytes source) {
        return SSZ.decode(source, SSZReader::readUInt256List);
    }

    public static List<Bytes> decodeAddressList(Bytes source) {
        return SSZ.decode(source, SSZReader::readAddressList);
    }

    public static List<Bytes> decodeHashList(Bytes source, int hashLength) {
        return SSZ.decode(source, r -> r.readHashList(hashLength));
    }

    public static List<Boolean> decodeBooleanList(Bytes source) {
        return SSZ.decode(source, SSZReader::readBooleanList);
    }
}

