/*
 * Decompiled with CFR 0.152.
 */
package net.consensys.cava.ssz;

import java.math.BigInteger;
import net.consensys.cava.bytes.Bytes;
import net.consensys.cava.ssz.SSZ;
import net.consensys.cava.units.bigints.UInt256;

public interface SSZWriter {
    public void writeSSZ(Bytes var1);

    default public void writeSSZ(byte[] value) {
        this.writeSSZ(Bytes.wrap((byte[])value));
    }

    default public void writeBytes(Bytes value) {
        SSZ.encodeBytesTo(value, this::writeSSZ);
    }

    default public void writeBytes(byte[] value) {
        SSZ.encodeByteArrayTo(value, this::writeSSZ);
    }

    default public void writeString(String str) {
        SSZ.encodeStringTo(str, this::writeSSZ);
    }

    default public void writeInt(int value, int bitLength) {
        this.writeSSZ(SSZ.encodeLongToByteArray(value, bitLength));
    }

    default public void writeLong(long value, int bitLength) {
        this.writeSSZ(SSZ.encodeLongToByteArray(value, bitLength));
    }

    default public void writeBigInteger(BigInteger value, int bitLength) {
        this.writeSSZ(SSZ.encodeBigIntegerToByteArray(value, bitLength));
    }

    default public void writeInt8(int value) {
        this.writeInt(value, 8);
    }

    default public void writeInt16(int value) {
        this.writeInt(value, 16);
    }

    default public void writeInt32(int value) {
        this.writeInt(value, 32);
    }

    default public void writeInt64(long value) {
        this.writeLong(value, 64);
    }

    default public void writeUInt(int value, int bitLength) {
        this.writeSSZ(SSZ.encodeULongToByteArray(value, bitLength));
    }

    default public void writeULong(long value, int bitLength) {
        this.writeSSZ(SSZ.encodeULongToByteArray(value, bitLength));
    }

    default public void writeUInt8(int value) {
        this.writeUInt(value, 8);
    }

    default public void writeUInt16(int value) {
        this.writeUInt(value, 16);
    }

    default public void writeUInt32(long value) {
        this.writeULong(value, 32);
    }

    default public void writeUInt64(long value) {
        this.writeULong(value, 64);
    }

    default public void writeUInt256(UInt256 value) {
        this.writeSSZ(SSZ.encodeUInt256(value));
    }

    default public void writeBoolean(boolean value) {
        this.writeSSZ(SSZ.encodeBoolean(value));
    }

    default public void writeAddress(Bytes address) {
        this.writeSSZ(SSZ.encodeAddress(address));
    }

    default public void writeHash(Bytes hash) {
        this.writeSSZ(SSZ.encodeHash(hash));
    }

    default public void writeBytesList(Bytes ... elements) {
        SSZ.encodeBytesListTo(elements, this::writeSSZ);
    }

    default public void writeStringList(String ... elements) {
        SSZ.encodeStringListTo(elements, this::writeSSZ);
    }

    default public void writeIntList(int bitLength, int ... elements) {
        SSZ.encodeIntListTo(bitLength, elements, this::writeSSZ);
    }

    default public void writeLongIntList(int bitLength, long ... elements) {
        SSZ.encodeLongIntListTo(bitLength, elements, this::writeSSZ);
    }

    default public void writeBigIntegerList(int bitLength, BigInteger ... elements) {
        SSZ.encodeBigIntegerListTo(bitLength, elements, this::writeSSZ);
    }

    default public void writeInt8List(int ... elements) {
        this.writeIntList(8, elements);
    }

    default public void writeInt16List(int ... elements) {
        this.writeIntList(16, elements);
    }

    default public void writeInt32List(int ... elements) {
        this.writeIntList(32, elements);
    }

    default public void writeInt64List(int ... elements) {
        this.writeIntList(64, elements);
    }

    default public void writeUIntList(int bitLength, int ... elements) {
        SSZ.encodeUIntListTo(bitLength, elements, this::writeSSZ);
    }

    default public void writeULongIntList(int bitLength, long ... elements) {
        SSZ.encodeULongIntListTo(bitLength, elements, this::writeSSZ);
    }

    default public void writeUInt8List(int ... elements) {
        this.writeUIntList(8, elements);
    }

    default public void writeUInt16List(int ... elements) {
        this.writeUIntList(16, elements);
    }

    default public void writeUInt32List(long ... elements) {
        this.writeULongIntList(32, elements);
    }

    default public void writeUInt64List(long ... elements) {
        this.writeULongIntList(64, elements);
    }

    default public void writeUInt256List(UInt256 ... elements) {
        SSZ.encodeUInt256ListTo(elements, this::writeSSZ);
    }

    default public void writeHashList(Bytes ... elements) {
        SSZ.encodeHashListTo(elements, this::writeSSZ);
    }

    default public void writeAddressList(Bytes ... elements) {
        SSZ.encodeAddressListTo(elements, this::writeSSZ);
    }

    default public void writeBooleanList(boolean ... elements) {
        SSZ.encodeBooleanListTo(elements, this::writeSSZ);
    }
}

