/*
 * Decompiled with CFR 0.152.
 */
package net.consensys.cava.ssz.experimental;

import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.ExperimentalUnsignedTypes;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.consensys.cava.bytes.Bytes;
import net.consensys.cava.ssz.InvalidSSZTypeException;
import net.consensys.cava.units.bigints.UInt256;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\r\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\bg\u0018\u00002\u00020\u0001J\b\u0010\u0005\u001a\u00020\u0006H&J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH&J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH&J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000b\u001a\u00020\fH&J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\bH&J\u0012\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\fH\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\bH\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\b2\u0006\u0010\u0012\u001a\u00020\fH&J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\fH&J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\u0012\u001a\u00020\fH&J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\fH&J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\u0017\u001a\u00020\fH&J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH&J\b\u0010\u001a\u001a\u00020\fH\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\bH\u0016J\b\u0010\u001c\u001a\u00020\fH\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\bH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\bH\u0016J\b\u0010!\u001a\u00020\fH\u0016J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\f0\bH\u0016J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\f0\b2\u0006\u0010\u000b\u001a\u00020\fH&J\u0010\u0010$\u001a\u00020\u001f2\u0006\u0010\u000b\u001a\u00020\fH&J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001f0\b2\u0006\u0010\u000b\u001a\u00020\fH&J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u0012\u001a\u00020\fH\u0016J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020'0\bH\u0016J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020'0\b2\u0006\u0010\u0012\u001a\u00020\fH&J\u0018\u0010)\u001a\u00020*2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010+J\u0010\u0010,\u001a\u00020*H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010-J\u0011\u0010.\u001a\b\u0012\u0004\u0012\u00020*0\bH\u0016\u00f8\u0001\u0000J\b\u0010/\u001a\u000200H&J\u000e\u00101\u001a\b\u0012\u0004\u0012\u0002000\bH&J\u0010\u00102\u001a\u000203H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0002\u00104J\u0011\u00105\u001a\b\u0012\u0004\u0012\u0002030\bH\u0016\u00f8\u0001\u0000J\u0010\u00106\u001a\u000203H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0002\u00104J\u0011\u00107\u001a\b\u0012\u0004\u0012\u0002030\bH\u0016\u00f8\u0001\u0000J\u0010\u00108\u001a\u00020*H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010-J\u0011\u00109\u001a\b\u0012\u0004\u0012\u00020*0\bH\u0016\u00f8\u0001\u0000J\u0019\u0010:\u001a\b\u0012\u0004\u0012\u00020*0\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00f8\u0001\u0000J\u0018\u0010;\u001a\u0002032\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010<J\u0019\u0010=\u001a\b\u0012\u0004\u0012\u0002030\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00f8\u0001\u0000J\u0010\u0010>\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH&J\u0016\u0010?\u001a\b\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000b\u001a\u00020\fH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0004\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006@"}, d2={"Lnet/consensys/cava/ssz/experimental/SSZReader;", "", "isComplete", "", "()Z", "readAddress", "Lnet/consensys/cava/bytes/Bytes;", "readAddressList", "", "readBigInteger", "Ljava/math/BigInteger;", "bitLength", "", "readBigIntegerList", "readBoolean", "readBooleanList", "readByteArray", "", "limit", "readByteArrayList", "readBytes", "readBytesList", "readHash", "hashLength", "readHashList", "readInt", "readInt16", "readInt16List", "readInt32", "readInt32List", "readInt64", "", "readInt64List", "readInt8", "readInt8List", "readIntList", "readLong", "readLongIntList", "readString", "", "readStringList", "readUInt", "Lkotlin/UInt;", "(I)I", "readUInt16", "()I", "readUInt16List", "readUInt256", "Lnet/consensys/cava/units/bigints/UInt256;", "readUInt256List", "readUInt32", "Lkotlin/ULong;", "()J", "readUInt32List", "readUInt64", "readUInt64List", "readUInt8", "readUInt8List", "readUIntList", "readULong", "(I)J", "readULongIntList", "readUnsignedBigInteger", "readUnsignedBigIntegerList", "ssz"})
@ExperimentalUnsignedTypes
public interface SSZReader {
    @NotNull
    public Bytes readBytes(int var1);

    @NotNull
    public byte[] readByteArray(int var1);

    @NotNull
    public String readString(int var1);

    public int readInt(int var1);

    public long readLong(int var1);

    @NotNull
    public BigInteger readBigInteger(int var1);

    public int readInt8();

    public int readInt16();

    public int readInt32();

    public long readInt64();

    public int readUInt(int var1);

    public long readULong(int var1);

    @NotNull
    public BigInteger readUnsignedBigInteger(int var1);

    public int readUInt8();

    public int readUInt16();

    public long readUInt32();

    public long readUInt64();

    @NotNull
    public UInt256 readUInt256();

    public boolean readBoolean();

    @NotNull
    public Bytes readAddress();

    @NotNull
    public Bytes readHash(int var1);

    @NotNull
    public List<Bytes> readBytesList();

    @NotNull
    public List<Bytes> readBytesList(int var1);

    @NotNull
    public List<byte[]> readByteArrayList();

    @NotNull
    public List<byte[]> readByteArrayList(int var1);

    @NotNull
    public List<String> readStringList();

    @NotNull
    public List<String> readStringList(int var1);

    @NotNull
    public List<Integer> readIntList(int var1);

    @NotNull
    public List<Long> readLongIntList(int var1);

    @NotNull
    public List<BigInteger> readBigIntegerList(int var1);

    @NotNull
    public List<Integer> readInt8List();

    @NotNull
    public List<Integer> readInt16List();

    @NotNull
    public List<Integer> readInt32List();

    @NotNull
    public List<Long> readInt64List();

    @NotNull
    public List<UInt> readUIntList(int var1);

    @NotNull
    public List<ULong> readULongIntList(int var1);

    @NotNull
    public List<BigInteger> readUnsignedBigIntegerList(int var1);

    @NotNull
    public List<UInt> readUInt8List();

    @NotNull
    public List<UInt> readUInt16List();

    @NotNull
    public List<ULong> readUInt32List();

    @NotNull
    public List<ULong> readUInt64List();

    @NotNull
    public List<UInt256> readUInt256List();

    @NotNull
    public List<Bytes> readAddressList();

    @NotNull
    public List<Bytes> readHashList(int var1);

    @NotNull
    public List<Boolean> readBooleanList();

    public boolean isComplete();

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @NotNull
        public static byte[] readByteArray(SSZReader $this, int limit) {
            byte[] byArray = $this.readBytes(limit).toArrayUnsafe();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"readBytes(limit).toArrayUnsafe()");
            return byArray;
        }

        @NotNull
        public static /* synthetic */ byte[] readByteArray$default(SSZReader sSZReader, int n, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: readByteArray");
            }
            if ((n2 & 1) != 0) {
                n = Integer.MAX_VALUE;
            }
            return sSZReader.readByteArray(n);
        }

        @NotNull
        public static String readString(SSZReader $this, int limit) {
            byte[] byArray = $this.readByteArray(limit);
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"UTF_8");
            Charset charset2 = charset;
            return new String(byArray, charset2);
        }

        public static int readInt8(SSZReader $this) {
            return $this.readInt(8);
        }

        public static int readInt16(SSZReader $this) {
            return $this.readInt(16);
        }

        public static int readInt32(SSZReader $this) {
            return $this.readInt(32);
        }

        public static long readInt64(SSZReader $this) {
            return $this.readLong(64);
        }

        public static int readUInt(SSZReader $this, int bitLength) {
            int n = $this.readInt(bitLength);
            return UInt.constructor-impl((int)n);
        }

        public static long readULong(SSZReader $this, int bitLength) {
            long l = $this.readLong(bitLength);
            return ULong.constructor-impl((long)l);
        }

        public static int readUInt8(SSZReader $this) {
            return $this.readUInt(8);
        }

        public static int readUInt16(SSZReader $this) {
            return $this.readUInt(16);
        }

        public static long readUInt32(SSZReader $this) {
            return $this.readULong(32);
        }

        public static long readUInt64(SSZReader $this) {
            return $this.readULong(64);
        }

        public static boolean readBoolean(SSZReader $this) {
            boolean bl;
            switch ($this.readInt(8)) {
                case 0: {
                    bl = false;
                    break;
                }
                case 1: {
                    bl = true;
                    break;
                }
                default: {
                    throw (Throwable)new InvalidSSZTypeException("decoded value is not a boolean");
                }
            }
            return bl;
        }

        @NotNull
        public static List<Bytes> readBytesList(SSZReader $this) {
            return $this.readBytesList(Integer.MAX_VALUE);
        }

        @NotNull
        public static List<byte[]> readByteArrayList(SSZReader $this) {
            return $this.readByteArrayList(Integer.MAX_VALUE);
        }

        @NotNull
        public static List<String> readStringList(SSZReader $this) {
            return $this.readStringList(Integer.MAX_VALUE);
        }

        @NotNull
        public static List<Integer> readInt8List(SSZReader $this) {
            return $this.readIntList(8);
        }

        @NotNull
        public static List<Integer> readInt16List(SSZReader $this) {
            return $this.readIntList(16);
        }

        @NotNull
        public static List<Integer> readInt32List(SSZReader $this) {
            return $this.readIntList(32);
        }

        @NotNull
        public static List<Long> readInt64List(SSZReader $this) {
            return $this.readLongIntList(64);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static List<UInt> readUIntList(SSZReader $this, int bitLength) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)$this.readIntList(bitLength);
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void i;
                int n = ((Number)item$iv$iv).intValue();
                Collection collection = destination$iv$iv;
                void var8_8 = i;
                UInt uInt = UInt.box-impl((int)UInt.constructor-impl((int)var8_8));
                collection.add(uInt);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static List<ULong> readULongIntList(SSZReader $this, int bitLength) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)$this.readLongIntList(bitLength);
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void i;
                long l = ((Number)item$iv$iv).longValue();
                Collection collection = destination$iv$iv;
                void var9_8 = i;
                ULong uLong = ULong.box-impl((long)ULong.constructor-impl((long)var9_8));
                collection.add(uLong);
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public static List<UInt> readUInt8List(SSZReader $this) {
            return $this.readUIntList(8);
        }

        @NotNull
        public static List<UInt> readUInt16List(SSZReader $this) {
            return $this.readUIntList(16);
        }

        @NotNull
        public static List<ULong> readUInt32List(SSZReader $this) {
            return $this.readULongIntList(32);
        }

        @NotNull
        public static List<ULong> readUInt64List(SSZReader $this) {
            return $this.readULongIntList(64);
        }
    }
}

