/*
 * Decompiled with CFR 0.152.
 */
package net.koofr.api.v2;

import java.util.Arrays;
import net.koofr.api.v2.OAuthStorageApi;
import net.koofr.api.v2.StorageApi;
import net.koofr.api.v2.StorageApiException;
import net.koofr.api.v2.TokenStorageApi;
import net.koofr.api.v2.util.HttpsClientHelper;
import net.koofr.api.v2.util.KoofrTokenAuthenticator;
import org.restlet.Client;
import org.restlet.Context;
import org.restlet.data.Protocol;
import org.restlet.engine.Engine;
import org.restlet.ext.jackson.JacksonConverter;

public class DefaultClientFactory {
    private static Client prepareClient() {
        Engine.getInstance().getRegisteredConverters().clear();
        Engine.getInstance().getRegisteredConverters().add(new JacksonConverter());
        Engine.getInstance().getRegisteredClients().clear();
        Engine.getInstance().getRegisteredClients().add(new HttpsClientHelper(null));
        Context context = new Context();
        context.getParameters().set("maxTotalConnections", "16");
        context.getParameters().set("maxConnectionsPerHost", "8");
        Client client = new Client(context, Arrays.asList(Protocol.HTTPS), HttpsClientHelper.class.getName());
        return client;
    }

    public static OAuthStorageApi createOAuth(String string) {
        Client client = DefaultClientFactory.prepareClient();
        return new OAuthStorageApi("https://" + string, client);
    }

    private static TokenStorageApi createToken(String string, KoofrTokenAuthenticator koofrTokenAuthenticator) {
        Engine.getInstance().getRegisteredAuthenticators().clear();
        Engine.getInstance().getRegisteredAuthenticators().add(koofrTokenAuthenticator);
        Client client = DefaultClientFactory.prepareClient();
        return new TokenStorageApi("https://" + string, client);
    }

    public static StorageApi createToken(String string, String string2) {
        KoofrTokenAuthenticator koofrTokenAuthenticator = new KoofrTokenAuthenticator();
        TokenStorageApi tokenStorageApi = DefaultClientFactory.createToken(string, koofrTokenAuthenticator);
        koofrTokenAuthenticator.setToken(string2);
        tokenStorageApi.setAuthToken(string2);
        return tokenStorageApi;
    }

    public static StorageApi createToken(String string, String string2, String string3) throws StorageApiException {
        KoofrTokenAuthenticator koofrTokenAuthenticator = new KoofrTokenAuthenticator();
        TokenStorageApi tokenStorageApi = DefaultClientFactory.createToken(string, koofrTokenAuthenticator);
        String string4 = tokenStorageApi.authenticate("https://" + string + "/token", string2, string3);
        tokenStorageApi.setAuthToken(string4);
        koofrTokenAuthenticator.setToken(string4);
        return tokenStorageApi;
    }
}

