/*
 * Decompiled with CFR 0.152.
 */
package net.koofr.api.v2;

import java.util.Date;
import net.koofr.api.v2.StorageApi;
import net.koofr.api.v2.StorageApiException;
import net.koofr.api.v2.util.OAuthClientResource;
import org.apache.http.message.AbstractHttpMessage;
import org.restlet.Client;
import org.restlet.data.Reference;
import org.restlet.ext.oauth.AccessTokenClientResource;
import org.restlet.ext.oauth.GrantType;
import org.restlet.ext.oauth.OAuthParameters;
import org.restlet.ext.oauth.internal.Token;
import org.restlet.resource.ClientResource;
import org.restlet.resource.ResourceException;

public class OAuthStorageApi
extends StorageApi {
    private String clientId;
    private String clientSecret;
    private OAuthToken oauthToken;
    private long EXPIRATION_THRESHOLD = 300000L;

    public OAuthStorageApi(String string, Client client) {
        super(string, client);
    }

    public void setClientCredentials(String string, String string2) {
        this.clientId = string;
        this.clientSecret = string2;
    }

    public String getOAuthAccessToken() {
        if (null != this.oauthToken) {
            return this.oauthToken.access;
        }
        return null;
    }

    public String getOAuthRefreshToken() {
        if (null != this.oauthToken) {
            return this.oauthToken.refresh;
        }
        return null;
    }

    @Override
    protected void prepareRequest() throws StorageApiException {
        this.renewIfNeccessary();
    }

    @Override
    protected void prepareHttpMessage(AbstractHttpMessage abstractHttpMessage) throws StorageApiException {
        if (this.oauthToken != null) {
            abstractHttpMessage.addHeader("Authorization", "Bearer " + this.oauthToken.access);
        }
    }

    @Override
    protected ClientResource createResource(Reference reference) throws StorageApiException {
        OAuthClientResource oAuthClientResource = new OAuthClientResource(reference);
        if (this.oauthToken != null) {
            oAuthClientResource.setToken(this.oauthToken.token);
        }
        return oAuthClientResource;
    }

    private boolean renewIfNeccessary() throws StorageApiException {
        if (this.oauthToken != null && (this.oauthToken.access == null || this.oauthToken.token == null || this.oauthToken.expires - this.EXPIRATION_THRESHOLD > new Date().getTime())) {
            return false;
        }
        if (this.oauthToken == null || this.oauthToken.refresh == null) {
            throw new StorageApiException(new ResourceException(401));
        }
        this.setOAuthRefreshToken(this.oauthToken.refresh);
        return true;
    }

    public void clearOAuthTokens() {
        this.oauthToken = null;
    }

    public OAuthToken setOAuthCode(String string, String string2) throws StorageApiException {
        Reference reference = new Reference(new Reference(this.baseUrl), "/oauth2/token");
        AccessTokenClientResource accessTokenClientResource = new AccessTokenClientResource(reference);
        accessTokenClientResource.setClientCredentials(this.clientId, this.clientSecret);
        OAuthParameters oAuthParameters = new OAuthParameters();
        oAuthParameters.code(string);
        oAuthParameters.grantType(GrantType.authorization_code);
        oAuthParameters.add("client_id", this.clientId);
        oAuthParameters.add("client_secret", this.clientSecret);
        oAuthParameters.redirectURI(string2);
        try {
            Token token = accessTokenClientResource.requestToken(oAuthParameters);
            this.oauthToken = new OAuthToken(token);
            return this.oauthToken;
        }
        catch (Exception exception) {
            throw new StorageApiException(exception);
        }
    }

    public OAuthToken setOAuthRefreshToken(String string) throws StorageApiException {
        Reference reference = new Reference(new Reference(this.baseUrl), "/oauth2/token");
        AccessTokenClientResource accessTokenClientResource = new AccessTokenClientResource(reference);
        accessTokenClientResource.setClientCredentials(this.clientId, this.clientSecret);
        OAuthParameters oAuthParameters = new OAuthParameters();
        oAuthParameters.refreshToken(string);
        oAuthParameters.grantType(GrantType.refresh_token);
        oAuthParameters.add("client_id", this.clientId);
        oAuthParameters.add("client_secret", this.clientSecret);
        try {
            Token token = accessTokenClientResource.requestToken(oAuthParameters);
            this.oauthToken = new OAuthToken(token);
            return this.oauthToken;
        }
        catch (Exception exception) {
            throw new StorageApiException(exception);
        }
    }

    public class OAuthToken {
        public String refresh;
        public String access;
        public long expires;
        protected Token token;

        public OAuthToken(String string) {
            this.refresh = string;
            this.access = null;
            this.expires = 0L;
            this.token = null;
        }

        protected OAuthToken(Token token) {
            this.token = token;
            this.refresh = token.getRefreshToken();
            this.access = token.getAccessToken();
            this.expires = new Date().getTime() + (long)(token.getExpirePeriod() * 1000);
        }
    }
}

