/*
 * Decompiled with CFR 0.152.
 */
package net.koofr.api.v2;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import net.koofr.api.v2.StorageApiException;
import net.koofr.api.v2.StorageApiExceptionHandler;
import net.koofr.api.v2.resources.Bookmark;
import net.koofr.api.v2.resources.Comment;
import net.koofr.api.v2.resources.ConnectionList;
import net.koofr.api.v2.resources.Device;
import net.koofr.api.v2.resources.File;
import net.koofr.api.v2.resources.Group;
import net.koofr.api.v2.resources.Hit;
import net.koofr.api.v2.resources.JsonBase;
import net.koofr.api.v2.resources.Link;
import net.koofr.api.v2.resources.Mount;
import net.koofr.api.v2.resources.NotificationSettings;
import net.koofr.api.v2.resources.PathInfo;
import net.koofr.api.v2.resources.Permissions;
import net.koofr.api.v2.resources.SecuritySettings;
import net.koofr.api.v2.resources.User;
import net.koofr.api.v2.resources.UserInfo;
import net.koofr.api.v2.transfer.ProgressListener;
import net.koofr.api.v2.transfer.upload.MultipartEntityProgress;
import net.koofr.api.v2.transfer.upload.UploadData;
import net.koofr.api.v2.util.Https;
import net.koofr.api.v2.util.Log;
import net.koofr.api.v2.util.TokenClientResource;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.SingleClientConnManager;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.restlet.Client;
import org.restlet.Uniform;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.resource.ClientResource;
import org.restlet.resource.ResourceException;

public abstract class StorageApi {
    public static final String TAG = StorageApi.class.getName();
    public static final int DOWNLOAD_BUFFER_SIZE = 65536;
    protected String baseUrl;
    protected Client client;
    protected Log log;
    protected StorageApiExceptionHandler xhandler;

    public void setLog(Log log) {
        this.log = log;
    }

    private void debug(String string, String string2) {
        if (null != this.log) {
            this.log.debug(string, string2);
        }
    }

    private void debug(String string, String string2, Throwable throwable) {
        if (null != this.log) {
            this.log.debug(string, string2, throwable);
        }
    }

    public StorageApi(String string, Client client) {
        this.baseUrl = string;
        this.client = client;
        this.log = null;
        this.xhandler = null;
    }

    public void setExceptionHandler(StorageApiExceptionHandler storageApiExceptionHandler) {
        this.xhandler = storageApiExceptionHandler;
    }

    protected void fireExceptionHandler(Exception exception) throws StorageApiException {
        if (this.xhandler != null && this.xhandler.handle(exception)) {
            throw new StorageApiException();
        }
    }

    protected abstract void prepareRequest() throws StorageApiException;

    protected abstract ClientResource createResource(Reference var1) throws StorageApiException;

    protected abstract void prepareHttpMessage(AbstractHttpMessage var1) throws StorageApiException;

    protected ClientResource getResource(String string) throws StorageApiException {
        this.debug(TAG, "Resource path: " + string);
        this.prepareRequest();
        Reference reference = new Reference(new Reference(this.baseUrl), string);
        ClientResource clientResource = this.createResource(reference);
        clientResource.setNext((Uniform)this.client);
        return clientResource;
    }

    protected ClientResource getResource(String string, String ... stringArray) throws StorageApiException {
        this.debug(TAG, "Resource path: " + string);
        this.prepareRequest();
        Reference reference = new Reference(new Reference(this.baseUrl), string);
        for (int i = 0; i < stringArray.length - 1; i += 2) {
            reference = reference.addQueryParameter(stringArray[i], stringArray[i + 1]);
        }
        ClientResource clientResource = this.createResource(reference);
        clientResource.setNext((Uniform)this.client);
        return clientResource;
    }

    protected ClientResource getResource(Reference reference) throws StorageApiException {
        this.debug(TAG, "Resource path: " + reference.getPath());
        this.prepareRequest();
        ClientResource clientResource = this.createResource(reference);
        clientResource.setNext((Uniform)this.client);
        return clientResource;
    }

    private HttpClient getHttpClient() {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("https", (SocketFactory)Https.getFactory(), 443));
        schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        BasicHttpParams basicHttpParams = new BasicHttpParams();
        SingleClientConnManager singleClientConnManager = new SingleClientConnManager((HttpParams)basicHttpParams, schemeRegistry);
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient((ClientConnectionManager)singleClientConnManager, (HttpParams)basicHttpParams);
        return defaultHttpClient;
    }

    public UserInfo getUserInfo() throws StorageApiException {
        try {
            return (UserInfo)this.getResource("/api/v2/user").get(UserInfo.class);
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public ConnectionList getUserConnections() throws StorageApiException {
        try {
            return (ConnectionList)this.getResource("/api/v2/user/connections").get(ConnectionList.class);
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public void updateUserInfo(String string, String string2) throws StorageApiException {
        UserUpdate userUpdate = new UserUpdate();
        userUpdate.setFirstName(string);
        userUpdate.setLastName(string2);
        try {
            this.getResource("/api/v2/user").put((Object)userUpdate);
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public void updateUserPassword(String string, String string2) throws StorageApiException {
        UserPasswordUpdate userPasswordUpdate = new UserPasswordUpdate();
        userPasswordUpdate.setNewPassword(string);
        userPasswordUpdate.setOldPassword(string2);
        try {
            this.getResource("/api/v2/user/password").put((Object)userPasswordUpdate);
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public NotificationSettings getNotificationSettings() throws StorageApiException {
        try {
            return (NotificationSettings)this.getResource("/api/v2/user/settings/notifications").get(NotificationSettings.class);
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public void updateNotificationSettings(NotificationSettings notificationSettings) throws StorageApiException {
        try {
            this.getResource("/api/v2/user/settings/notifications").put((Object)notificationSettings);
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public SecuritySettings getSecuritySettings() throws StorageApiException {
        try {
            return (SecuritySettings)this.getResource("/api/v2/user/settings/security").get(SecuritySettings.class);
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public void updateSecuritySettings(SecuritySettings securitySettings) throws StorageApiException {
        try {
            this.getResource("/api/v2/user/settings/security").put((Object)securitySettings);
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public List<Bookmark> getBookmarks() throws StorageApiException {
        try {
            BookmarkList bookmarkList = (BookmarkList)this.getResource("/api/v2/user/bookmarks").get(BookmarkList.class);
            if (null != bookmarkList) {
                return bookmarkList.getBookmarks();
            }
            return null;
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public void putBookmarks(List<Bookmark> list) throws StorageApiException {
        BookmarkList bookmarkList = new BookmarkList();
        bookmarkList.setBookmarks(list);
        try {
            this.getResource("/api/v2/user/bookmarks").put((Object)bookmarkList);
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public void deleteBookmark(String string, String string2) throws StorageApiException {
        try {
            this.getResource("/api/v2/user/bookmarks", "mountId", string, "path", string2).delete();
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public void addBookmark(String string, String string2, String string3) throws StorageApiException {
        Bookmark bookmark = new Bookmark();
        bookmark.setMountId(string);
        bookmark.setPath(string2);
        bookmark.setName(string3);
        try {
            this.getResource("/api/v2/user/bookmarks").post((Object)bookmark);
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public InputStream getProfilePicture(String string) throws StorageApiException {
        try {
            return this.getResource("/content/api/v2/users/" + string + "/profile-picture").get(MediaType.IMAGE_ALL).getStream();
        }
        catch (Exception exception) {
            this.fireExceptionHandler(exception);
            throw new StorageApiException(exception);
        }
    }

    public Group newGroup(String string) throws StorageApiException {
        NameRequest nameRequest = new NameRequest();
        nameRequest.setName(string);
        try {
            return (Group)this.getResource("/api/v2/groups").post((Object)nameRequest, Group.class);
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public List<Group> getGroups() throws StorageApiException {
        try {
            GroupList groupList = (GroupList)this.getResource("/api/v2/groups").get(GroupList.class);
            if (null != groupList) {
                return groupList.getGroups();
            }
            return null;
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public Group getGroup(String string) throws StorageApiException {
        try {
            return (Group)this.getResource("/api/v2/groups/" + string).get(Group.class);
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public void updateGroup(String string, String string2) throws StorageApiException {
        NameRequest nameRequest = new NameRequest();
        nameRequest.setName(string2);
        try {
            this.getResource("/api/v2/groups/" + string).put((Object)nameRequest);
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public User addUserToGroup(String string, String string2, Permissions permissions) throws StorageApiException {
        AddUserRequest addUserRequest = new AddUserRequest();
        addUserRequest.setEmail(string2);
        addUserRequest.setPermissions(permissions);
        try {
            return (User)this.getResource("/api/v2/groups/" + string + "/users").post((Object)addUserRequest, User.class);
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public void updateGroupUser(String string, String string2, Permissions permissions) throws StorageApiException {
        UpdatePermissionsRequest updatePermissionsRequest = new UpdatePermissionsRequest();
        updatePermissionsRequest.setPermissions(permissions);
        try {
            this.getResource("/api/v2/groups/" + string + "/users/" + string2).put((Object)updatePermissionsRequest);
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public void deleteGroupUser(String string, String string2) throws StorageApiException {
        try {
            this.getResource("/api/v2/groups/" + string + "/users/" + string2).delete();
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public void deleteGroup(String string) throws StorageApiException {
        try {
            this.getResource("/api/v2/groups/" + string).delete();
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public List<Device> getDevices() throws StorageApiException {
        try {
            DeviceList deviceList = (DeviceList)this.getResource("/api/v2/devices").get(DeviceList.class);
            if (null != deviceList) {
                return deviceList.getDevices();
            }
            return null;
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public Device createDevice(String string, String string2) throws StorageApiException {
        DeviceCreateRequest deviceCreateRequest = new DeviceCreateRequest();
        deviceCreateRequest.setName(string);
        deviceCreateRequest.setProviderName(string2);
        try {
            return (Device)this.getResource("/api/v2/devices").post((Object)deviceCreateRequest, Device.class);
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public Device getDevice(String string) throws StorageApiException {
        try {
            return (Device)this.getResource("/api/v2/devices/" + string).get(Device.class);
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public void updateDevice(String string, String string2) throws StorageApiException {
        NameRequest nameRequest = new NameRequest();
        nameRequest.setName(string2);
        try {
            this.getResource("/api/v2/devices/" + string).put((Object)nameRequest);
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public void deleteDevice(String string) throws StorageApiException {
        try {
            this.getResource("/api/v2/devices/" + string).delete();
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public List<Mount> getMounts() throws StorageApiException {
        try {
            MountList mountList = (MountList)this.getResource("/api/v2/mounts").get(MountList.class);
            if (null != mountList) {
                return mountList.getMounts();
            }
            return null;
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public Mount getMount(String string) throws StorageApiException {
        try {
            return (Mount)this.getResource("/api/v2/mounts/" + string).get(Mount.class);
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public Mount createMount(String string, String string2, String string3) throws StorageApiException {
        CreateMountRequest createMountRequest = new CreateMountRequest();
        createMountRequest.setName(string3);
        createMountRequest.setPath(string2);
        try {
            return (Mount)this.getResource("/api/v2/mounts/" + string + "/submounts").post((Object)createMountRequest, Mount.class);
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public void updateMount(String string, String string2) throws StorageApiException {
        NameRequest nameRequest = new NameRequest();
        nameRequest.setName(string2);
        try {
            this.getResource("/api/v2/mounts/" + string).put((Object)nameRequest);
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public User addUserToMount(String string, String string2, Permissions permissions) throws StorageApiException {
        AddUserRequest addUserRequest = new AddUserRequest();
        addUserRequest.setEmail(string2);
        addUserRequest.setPermissions(permissions);
        try {
            return (User)this.getResource("/api/v2/mounts/" + string + "/users").post((Object)addUserRequest, User.class);
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public void updateMountUser(String string, String string2, Permissions permissions) throws StorageApiException {
        UpdatePermissionsRequest updatePermissionsRequest = new UpdatePermissionsRequest();
        updatePermissionsRequest.setPermissions(permissions);
        try {
            this.getResource("/api/v2/mounts/" + string + "/users/" + string2).put((Object)updatePermissionsRequest);
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public void deleteMountUser(String string, String string2) throws StorageApiException {
        try {
            this.getResource("/api/v2/mounts/" + string + "/users/" + string2).delete();
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public void updateMountGroup(String string, String string2, Permissions permissions) throws StorageApiException {
        UpdatePermissionsRequest updatePermissionsRequest = new UpdatePermissionsRequest();
        updatePermissionsRequest.setPermissions(permissions);
        try {
            this.getResource("/api/v2/mounts/" + string + "/groups/" + string2).put((Object)updatePermissionsRequest);
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public void deleteMountGroup(String string, String string2) throws StorageApiException {
        try {
            this.getResource("/api/v2/mounts/" + string + "/groups/" + string2).delete();
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public void deleteMount(String string) throws StorageApiException {
        try {
            this.getResource("/api/v2/mounts/" + string).delete();
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public void createFolder(String string, String string2, String string3) throws StorageApiException {
        NameRequest nameRequest = new NameRequest();
        nameRequest.setName(string3);
        try {
            this.getResource("/api/v2/mounts/" + string + "/files/folder", "path", string2).post((Object)nameRequest);
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public String getUploadURL(String string, String string2) throws StorageApiException {
        try {
            FileLink fileLink = (FileLink)this.getResource("/api/v2/mounts/" + string + "/files/upload", "path", string2).get(FileLink.class);
            if (null != fileLink) {
                return fileLink.getLink();
            }
            return null;
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public String getDownloadURL(String string, String string2) throws StorageApiException {
        try {
            FileLink fileLink = (FileLink)this.getResource("/api/v2/mounts/" + string + "/files/download", "path", string2).get(FileLink.class);
            if (null != fileLink) {
                return fileLink.getLink();
            }
            return null;
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public List<File> listFiles(String string, String string2) throws StorageApiException {
        try {
            FileList fileList = (FileList)this.getResource("/api/v2/mounts/" + string + "/files/list", "path", string2).get(FileList.class);
            if (null != fileList) {
                return fileList.getFiles();
            }
            return null;
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public PathInfo getPathInfo(String string, String string2) throws StorageApiException {
        try {
            return (PathInfo)this.getResource("/api/v2/mounts/" + string + "/bundle", "path", string2).get(PathInfo.class);
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public File getFileInfo(String string, String string2) throws StorageApiException {
        try {
            return (File)this.getResource("/api/v2/mounts/" + string + "/files/info", "path", string2).get(File.class);
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public void renamePath(String string, String string2, String string3) throws StorageApiException {
        NameRequest nameRequest = new NameRequest();
        nameRequest.setName(string3);
        try {
            this.getResource("/api/v2/mounts/" + string + "/files/rename", "path", string2).put((Object)nameRequest);
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public void removePath(String string, String string2) throws StorageApiException {
        try {
            this.getResource("/api/v2/mounts/" + string + "/files/remove", "path", string2).delete();
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public String copyPath(String string, String string2, String string3, String string4) throws StorageApiException {
        try {
            DestinationRequest destinationRequest = new DestinationRequest();
            destinationRequest.setToMountId(string3);
            destinationRequest.setToPath(string4);
            NameRequest nameRequest = (NameRequest)this.getResource("/api/v2/mounts/" + string + "/files/copy", "path", string2).put((Object)destinationRequest, NameRequest.class);
            if (null != nameRequest) {
                return nameRequest.getName();
            }
            return null;
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public String movePath(String string, String string2, String string3, String string4) throws StorageApiException {
        try {
            DestinationRequest destinationRequest = new DestinationRequest();
            destinationRequest.setToMountId(string3);
            destinationRequest.setToPath(string4);
            NameRequest nameRequest = (NameRequest)this.getResource("/api/v2/mounts/" + string + "/files/move", "path", string2).put((Object)destinationRequest, NameRequest.class);
            if (null != nameRequest) {
                return nameRequest.getName();
            }
            return null;
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public Comment postComment(String string, String string2) throws StorageApiException {
        PostCommentRequest postCommentRequest = new PostCommentRequest();
        postCommentRequest.setContent(string2);
        try {
            return (Comment)this.getResource("/api/v2/mounts/" + string + "/comments").post((Object)postCommentRequest, Comment.class);
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public List<Comment> getComments(String string) throws StorageApiException {
        return this.getComments(string, -1, -1);
    }

    public List<Comment> getComments(String string, int n, int n2) throws StorageApiException {
        ClientResource clientResource = n >= 0 && n2 > 0 ? this.getResource("/api/v2/mounts/" + string + "/comments", "from", String.valueOf(n), "limit", String.valueOf(n2)) : this.getResource("/api/v2/mounts/" + string + "/comments");
        try {
            CommentList commentList = (CommentList)clientResource.get(CommentList.class);
            return commentList.getComments();
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public Comment getComment(String string, String string2) throws StorageApiException {
        try {
            return (Comment)this.getResource("/api/v2/mounts/" + string + "/comments/" + string2).get(Comment.class);
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public void deleteComment(String string, String string2) throws StorageApiException {
        try {
            this.getResource("/api/v2/mounts/" + string + "/comments/" + string2).delete();
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public Link createReceiver(String string, String string2) throws StorageApiException {
        PathRequest pathRequest = new PathRequest();
        pathRequest.setPath(string2);
        try {
            return (Link)this.getResource("/api/v2/mounts/" + string + "/receivers").post((Object)pathRequest, Link.class);
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public List<Link> getReceivers(String string) throws StorageApiException {
        try {
            LinkList linkList = (LinkList)this.getResource("/api/v2/mounts/" + string).get(LinkList.class);
            if (null != linkList) {
                return linkList.getLinks();
            }
            return null;
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public Link getReceiver(String string, String string2) throws StorageApiException {
        try {
            return (Link)this.getResource("/api/v2/mounts/" + string + "/receivers/" + string2).get(Link.class);
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public Link getReceiverForPath(String string, String string2) throws StorageApiException {
        try {
            return (Link)this.getResource("/api/v2/mounts/" + string + "/receivers", "path", string2).get(Link.class);
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public List<Link> getReceiversInParent(String string, String string2) throws StorageApiException {
        try {
            LinkList linkList = (LinkList)this.getResource("/api/v2/mounts/" + string + "/receivers", "parent", string2).get(LinkList.class);
            if (null != linkList) {
                return linkList.getLinks();
            }
            return null;
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public void setReceiverURLPath(String string, String string2, String string3) throws StorageApiException {
        HashRequest hashRequest = new HashRequest();
        hashRequest.setHash(string3);
        try {
            this.getResource("/api/v2/mounts/" + string + "/receivers/" + string2 + "/urlHash").put((Object)hashRequest);
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public Link resetReceiverPassword(String string, String string2) throws StorageApiException {
        try {
            return (Link)this.getResource("/api/v2/mounts/" + string + "/receivers/" + string2 + "/password/reset").put(null, Link.class);
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public void deleteReceiverPassword(String string, String string2) throws StorageApiException {
        try {
            this.getResource("/api/v2/mounts/" + string + "/receivers/" + string2 + "/password").delete();
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public void deleteReceiver(String string, String string2) throws StorageApiException {
        try {
            this.getResource("/api/v2/mounts/" + string + "/receivers/" + string2).delete();
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public Link createLink(String string, String string2) throws StorageApiException {
        PathRequest pathRequest = new PathRequest();
        pathRequest.setPath(string2);
        try {
            return (Link)this.getResource("/api/v2/mounts/" + string + "/links").post((Object)pathRequest, Link.class);
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public List<Link> getLinks(String string) throws StorageApiException {
        try {
            LinkList linkList = (LinkList)this.getResource("/api/v2/mounts/" + string).get(LinkList.class);
            if (null != linkList) {
                return linkList.getLinks();
            }
            return null;
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public Link getLink(String string, String string2) throws StorageApiException {
        try {
            return (Link)this.getResource("/api/v2/mounts/" + string + "/links/" + string2).get(Link.class);
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public Link getLinkForPath(String string, String string2) throws StorageApiException {
        try {
            return (Link)this.getResource("/api/v2/mounts/" + string + "/links", "path", string2).get(Link.class);
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public List<Link> getLinksInParent(String string, String string2) throws StorageApiException {
        try {
            LinkList linkList = (LinkList)this.getResource("/api/v2/mounts/" + string + "/links", "parent", string2).get(LinkList.class);
            if (null != linkList) {
                return linkList.getLinks();
            }
            return null;
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public void setLinkURLPath(String string, String string2, String string3) throws StorageApiException {
        HashRequest hashRequest = new HashRequest();
        hashRequest.setHash(string3);
        try {
            this.getResource("/api/v2/mounts/" + string + "/links/" + string2 + "/urlHash").put((Object)hashRequest);
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public Link resetLinkPassword(String string, String string2) throws StorageApiException {
        try {
            return (Link)this.getResource("/api/v2/mounts/" + string + "/links/" + string2 + "/password/reset").put(null, Link.class);
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public void deleteLinkPassword(String string, String string2) throws StorageApiException {
        try {
            this.getResource("/api/v2/mounts/" + string + "/links/" + string2 + "/password").delete();
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public void deleteLink(String string, String string2) throws StorageApiException {
        try {
            this.getResource("/api/v2/mounts/" + string + "/links/" + string2).delete();
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public List<Hit> search(String string) throws StorageApiException {
        try {
            QueryResults queryResults = (QueryResults)this.getResource("/api/v2/search", "query", string).get(QueryResults.class);
            if (null != queryResults) {
                ArrayList<Hit> arrayList = new ArrayList<Hit>();
                for (Hit hit : queryResults.hits) {
                    if (!queryResults.mounts.containsKey(hit.getMountId())) continue;
                    hit.setMount(queryResults.mounts.get(hit.getMountId()));
                    arrayList.add(hit);
                }
                return arrayList;
            }
            return null;
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public List<Hit> search(String string, String string2, String string3) throws StorageApiException {
        try {
            QueryResults queryResults = (QueryResults)this.getResource("/api/v2/search", "query", string, "mountId", string2, "path", string3).get(QueryResults.class);
            if (null != queryResults) {
                ArrayList<Hit> arrayList = new ArrayList<Hit>();
                for (Hit hit : queryResults.hits) {
                    if (!queryResults.mounts.containsKey(hit.getMountId())) continue;
                    hit.setMount(queryResults.mounts.get(hit.getMountId()));
                    arrayList.add(hit);
                }
                return arrayList;
            }
            return null;
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public boolean checkAuthentication() throws StorageApiException {
        try {
            return this.getUserInfo() != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean filesUpload(String string, String string2, UploadData uploadData, ProgressListener progressListener) throws StorageApiException {
        try {
            this.prepareRequest();
            String string3 = this.baseUrl + "/content/api/v2/mounts/" + string + "/files/put";
            try {
                string3 = string3 + "?path=" + URLEncoder.encode(string2, "UTF-8") + "&filename=" + URLEncoder.encode(uploadData.getName(), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new StorageApiException(unsupportedEncodingException);
            }
            HttpPost httpPost = new HttpPost(string3);
            this.prepareHttpMessage((AbstractHttpMessage)httpPost);
            MultipartEntityProgress multipartEntityProgress = new MultipartEntityProgress(HttpMultipartMode.BROWSER_COMPATIBLE, progressListener);
            multipartEntityProgress.addPart("file", (ContentBody)uploadData.getBody());
            progressListener.setTotal(multipartEntityProgress.getContentLength());
            httpPost.setEntity((HttpEntity)multipartEntityProgress);
            HttpClient httpClient = this.getHttpClient();
            try {
                HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
                return httpResponse.getStatusLine().getStatusCode() == 200;
            }
            catch (Exception exception) {
                this.fireExceptionHandler(exception);
                throw new StorageApiException(exception);
            }
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public String filesDownload(String string, String string2, String string3, ProgressListener progressListener) throws StorageApiException {
        return this.filesDownload(string, string2, string3, progressListener, null);
    }

    public String filesDownload(String string, String string2, String string3, ProgressListener progressListener, String string4) throws StorageApiException {
        return this.filesDownload(string, string2, string3, progressListener, string4, null);
    }

    public String filesDownload(String string, String string2, String string3, ProgressListener progressListener, String string4, String string5) throws StorageApiException {
        String string6;
        Object object;
        String[] stringArray = string2.split("/");
        FilterOutputStream filterOutputStream = null;
        FileOutputStream fileOutputStream = null;
        InputStream inputStream = null;
        if (string5 == null) {
            string5 = stringArray[stringArray.length - 1];
            object = "";
            if (string2.endsWith("/")) {
                object = ".zip";
            } else {
                int n = string5.lastIndexOf(46);
                if (n >= 0) {
                    object = string5.substring(n).toLowerCase();
                    string5 = string5.substring(0, n);
                } else {
                    object = "";
                }
            }
            string6 = string3 + java.io.File.separator + string5 + (String)object;
            java.io.File file = new java.io.File(string6);
            int n = 1;
            while (file.exists()) {
                string6 = string3 + java.io.File.separator + string5 + "(" + n + ")" + (String)object;
                file = new java.io.File(string6);
                ++n;
            }
        } else {
            string6 = string3 + java.io.File.separator + string5;
        }
        try {
            inputStream = this.filesDownload(string, string2, progressListener, string4);
            fileOutputStream = new FileOutputStream(string6);
            filterOutputStream = new BufferedOutputStream(fileOutputStream, 65536);
            object = new byte[65536];
            int n = 0;
            long l = 0L;
            while (!progressListener.isCanceled() && (n = inputStream.read((byte[])object, 0, ((Object)object).length)) >= 0) {
                ((BufferedOutputStream)filterOutputStream).write((byte[])object, 0, n);
                progressListener.transferred(l += (long)n);
            }
            if (progressListener.isCanceled()) {
                new java.io.File(string6).delete();
                String string7 = null;
                return string7;
            }
            String string8 = string6;
            return string8;
        }
        catch (IOException iOException) {
            this.fireExceptionHandler(iOException);
            throw new StorageApiException(iOException);
        }
        finally {
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (Exception exception) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public InputStream filesDownload(String string, String string2, ProgressListener progressListener, String string3) throws StorageApiException {
        try {
            this.prepareRequest();
            String string4 = this.baseUrl + "/content/api/v2/mounts/" + string + "/files/get?path=";
            try {
                string4 = string4 + URLEncoder.encode(string2, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string4 = string4 + string2;
            }
            if (string3 != null) {
                string4 = string4 + "&thumb=" + string3;
            }
            final HttpGet httpGet = new HttpGet(string4);
            this.prepareHttpMessage((AbstractHttpMessage)httpGet);
            HttpClient httpClient = this.getHttpClient();
            try {
                HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);
                if (httpResponse.getStatusLine().getStatusCode() != 200) {
                    httpResponse.getEntity().consumeContent();
                    return null;
                }
                HttpEntity httpEntity = httpResponse.getEntity();
                progressListener.setTotal(httpEntity.getContentLength());
                BufferedInputStream bufferedInputStream = new BufferedInputStream(httpEntity.getContent(), 65536){

                    @Override
                    public void close() throws IOException {
                        httpGet.abort();
                        super.close();
                    }
                };
                return bufferedInputStream;
            }
            catch (Exception exception) {
                this.fireExceptionHandler(exception);
                throw new StorageApiException(exception);
            }
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    public String getMyIp() throws StorageApiException {
        try {
            Reference reference = new Reference(this.baseUrl + "/ip");
            TokenClientResource tokenClientResource = new TokenClientResource(reference);
            tokenClientResource.setNext((Uniform)this.client);
            return tokenClientResource.get().getText();
        }
        catch (IOException iOException) {
            this.fireExceptionHandler(iOException);
            throw new StorageApiException(iOException);
        }
    }

    public HashMap getAttributes() throws StorageApiException {
        try {
            return (HashMap)this.getResource("/api/v2/user/attributes").get(HashMap.class);
        }
        catch (Exception exception) {
            this.fireExceptionHandler(exception);
            throw new StorageApiException(exception);
        }
    }

    public static class QueryResults
    extends JsonBase
    implements Serializable {
        private static final long serialVersionUID = 1L;
        List<Hit> hits;
        Hashtable<String, Mount> mounts;

        public List<Hit> getHits() {
            return this.hits;
        }

        public void setHits(List<Hit> list) {
            this.hits = list;
        }

        public Hashtable<String, Mount> getMounts() {
            return this.mounts;
        }

        public void setMounts(Hashtable<String, Mount> hashtable) {
            this.mounts = hashtable;
        }
    }

    private static class HashRequest
    extends JsonBase
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String hash;

        private HashRequest() {
        }

        public String getHash() {
            return this.hash;
        }

        public void setHash(String string) {
            this.hash = string;
        }
    }

    private static class LinkList
    extends JsonBase
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private List<Link> links;

        private LinkList() {
        }

        public List<Link> getLinks() {
            return this.links;
        }

        public void setLinks(List<Link> list) {
            this.links = list;
        }
    }

    private static class PathRequest
    extends JsonBase
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String path;

        private PathRequest() {
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String string) {
            this.path = string;
        }
    }

    private static class CommentList
    extends JsonBase
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private List<Comment> comments;

        private CommentList() {
        }

        public List<Comment> getComments() {
            return this.comments;
        }

        public void setComments(List<Comment> list) {
            this.comments = list;
        }
    }

    private static class PostCommentRequest
    extends JsonBase
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String content;

        private PostCommentRequest() {
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String string) {
            this.content = string;
        }
    }

    private static class DestinationRequest
    extends JsonBase
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String toMountId;
        private String toPath;

        private DestinationRequest() {
        }

        public String getToMountId() {
            return this.toMountId;
        }

        public void setToMountId(String string) {
            this.toMountId = string;
        }

        public String getToPath() {
            return this.toPath;
        }

        public void setToPath(String string) {
            this.toPath = string;
        }
    }

    private static class FileList
    extends JsonBase
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private List<File> files;

        private FileList() {
        }

        public List<File> getFiles() {
            return this.files;
        }

        public void setFiles(List<File> list) {
            this.files = list;
        }
    }

    private static class FileLink
    extends JsonBase
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String link;

        private FileLink() {
        }

        public String getLink() {
            return this.link;
        }

        public void setLink(String string) {
            this.link = string;
        }
    }

    private static class CreateMountRequest
    extends JsonBase
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String path;
        private String name;

        private CreateMountRequest() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String string) {
            this.path = string;
        }
    }

    private static class MountList
    extends JsonBase
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private List<Mount> mounts;

        private MountList() {
        }

        public List<Mount> getMounts() {
            return this.mounts;
        }

        public void setMounts(List<Mount> list) {
            this.mounts = list;
        }
    }

    private static class DeviceCreateRequest
    extends JsonBase
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String name;
        private String providerName;

        private DeviceCreateRequest() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getProviderName() {
            return this.providerName;
        }

        public void setProviderName(String string) {
            this.providerName = string;
        }
    }

    private static class DeviceList
    extends JsonBase
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private List<Device> devices;

        private DeviceList() {
        }

        public List<Device> getDevices() {
            return this.devices;
        }

        public void setDevices(List<Device> list) {
            this.devices = list;
        }
    }

    private static class UpdatePermissionsRequest
    extends JsonBase
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Permissions permissions;

        private UpdatePermissionsRequest() {
        }

        public Permissions getPermissions() {
            return this.permissions;
        }

        public void setPermissions(Permissions permissions) {
            this.permissions = permissions;
        }
    }

    private static class AddUserRequest
    extends JsonBase
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String email;
        private Permissions permissions;

        private AddUserRequest() {
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String string) {
            this.email = string;
        }

        public Permissions getPermissions() {
            return this.permissions;
        }

        public void setPermissions(Permissions permissions) {
            this.permissions = permissions;
        }
    }

    private static class GroupList
    extends JsonBase
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private List<Group> groups;

        private GroupList() {
        }

        public List<Group> getGroups() {
            return this.groups;
        }

        public void setGroups(List<Group> list) {
            this.groups = list;
        }
    }

    private static class NameRequest
    extends JsonBase
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String name;

        private NameRequest() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }
    }

    private static class BookmarkList
    extends JsonBase
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private List<Bookmark> bookmarks;

        private BookmarkList() {
        }

        public List<Bookmark> getBookmarks() {
            return this.bookmarks;
        }

        public void setBookmarks(List<Bookmark> list) {
            this.bookmarks = list;
        }
    }

    private static class UserPasswordUpdate
    extends JsonBase
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String newPassword;
        private String oldPassword;

        private UserPasswordUpdate() {
        }

        public String getNewPassword() {
            return this.newPassword;
        }

        public void setNewPassword(String string) {
            this.newPassword = string;
        }

        public String getOldPassword() {
            return this.oldPassword;
        }

        public void setOldPassword(String string) {
            this.oldPassword = string;
        }
    }

    private static class UserUpdate
    extends JsonBase
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String firstName;
        private String lastName;

        private UserUpdate() {
        }

        public String getFirstName() {
            return this.firstName;
        }

        public void setFirstName(String string) {
            this.firstName = string;
        }

        public String getLastName() {
            return this.lastName;
        }

        public void setLastName(String string) {
            this.lastName = string;
        }
    }
}

