/*
 * Decompiled with CFR 0.152.
 */
package net.koofr.api.v2;

import net.koofr.api.v2.StorageApi;
import net.koofr.api.v2.StorageApiException;
import net.koofr.api.v2.util.KoofrTokenAuthenticator;
import net.koofr.api.v2.util.TokenClientResource;
import org.apache.http.message.AbstractHttpMessage;
import org.restlet.Client;
import org.restlet.Uniform;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.Header;
import org.restlet.data.Reference;
import org.restlet.resource.ClientResource;
import org.restlet.resource.ResourceException;
import org.restlet.util.Series;

public class TokenStorageApi
extends StorageApi {
    public static final String HEADER_KOOFR_USERNAME = "X-Koofr-Email";
    public static final String HEADER_KOOFR_PASSWORD = "X-Koofr-Password";
    public static final String HEADER_KOOFR_TOKEN = "X-Koofr-Token";
    private String token;

    public TokenStorageApi(String string, Client client) {
        super(string, client);
    }

    @Override
    protected ClientResource createResource(Reference reference) {
        TokenClientResource tokenClientResource = new TokenClientResource(reference);
        this.setAuthenticationHeader(tokenClientResource);
        return tokenClientResource;
    }

    @Override
    protected void prepareHttpMessage(AbstractHttpMessage abstractHttpMessage) {
        if (this.token != null) {
            abstractHttpMessage.addHeader("Authorization", "Token token=\"" + this.token + "\"");
        }
    }

    @Override
    protected void prepareRequest() {
    }

    public void setAuthToken(String string) {
        this.token = string;
    }

    public String getAuthToken() {
        return this.token;
    }

    public String authenticate(String string, String string2, String string3) throws StorageApiException {
        Reference reference = new Reference(string);
        TokenClientResource tokenClientResource = new TokenClientResource(reference);
        Series series = (Series)tokenClientResource.getRequestAttributes().get("org.restlet.http.headers");
        if (series == null) {
            series = new Series(Header.class);
            tokenClientResource.getRequestAttributes().put("org.restlet.http.headers", series);
        }
        series.set(HEADER_KOOFR_PASSWORD, string3);
        series.set(HEADER_KOOFR_USERNAME, string2);
        tokenClientResource.setNext((Uniform)this.client);
        try {
            tokenClientResource.get();
            series = (Series)tokenClientResource.getResponseAttributes().get("org.restlet.http.headers");
            String string4 = series.getValues(HEADER_KOOFR_TOKEN);
            return string4;
        }
        catch (ResourceException resourceException) {
            this.fireExceptionHandler((Exception)((Object)resourceException));
            throw new StorageApiException(resourceException);
        }
    }

    protected void setAuthenticationHeader(ClientResource clientResource) {
        clientResource.setChallengeResponse(new ChallengeResponse(KoofrTokenAuthenticator.KOOFR_CHALLENGE_SCHEME));
    }
}

