/*
 * Decompiled with CFR 0.152.
 */
package net.koofr.api.v2.transfer.upload;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import net.koofr.api.v2.transfer.ProgressListener;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;

public class MultipartEntityProgress
extends MultipartEntity {
    private ProgressListener listener;

    public MultipartEntityProgress(ProgressListener progressListener) {
        this.listener = progressListener;
    }

    public MultipartEntityProgress(HttpMultipartMode httpMultipartMode, String string, Charset charset, ProgressListener progressListener) {
        super(httpMultipartMode, string, charset);
        this.listener = progressListener;
    }

    public MultipartEntityProgress(HttpMultipartMode httpMultipartMode, ProgressListener progressListener) {
        super(httpMultipartMode);
        this.listener = progressListener;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        super.writeTo((OutputStream)new CountingOutputStream(outputStream, this.listener));
    }

    public static class CountingOutputStream
    extends FilterOutputStream {
        private ProgressListener listener;
        private long transferred = 0L;

        public CountingOutputStream(OutputStream outputStream, ProgressListener progressListener) {
            super(outputStream);
            this.listener = progressListener;
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            super.write(byArray, n, n2);
            this.transferred += (long)n2;
            this.listener.transferred(this.transferred);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            super.write(byArray);
            this.transferred += (long)byArray.length;
            this.listener.transferred(this.transferred);
        }

        @Override
        public void write(int n) throws IOException {
            super.write(n);
            ++this.transferred;
            this.listener.transferred(this.transferred);
        }
    }
}

