/*
 * Decompiled with CFR 0.152.
 */
package net.koofr.api.http.errors;

import java.io.IOException;
import net.koofr.api.http.Response;

public class HttpException
extends IOException {
    static final long serialVersionUID = 1L;
    int code;

    public int getCode() {
        return this.code;
    }

    public static Response checkResponse(Response response) throws IOException {
        int n = response.getStatus();
        if (n / 100 == 2) {
            return response;
        }
        switch (n) {
            case 404: {
                throw new NotFound();
            }
            case 401: {
                throw new Unauthorized();
            }
            case 403: {
                throw new Forbidden();
            }
            case 409: {
                throw new Conflict();
            }
        }
        throw new HttpException(n);
    }

    protected HttpException(int n) {
        super("Server responded with: " + n);
        this.code = n;
    }

    protected HttpException(int n, String string) {
        super(string);
        this.code = n;
    }

    public static class Forbidden
    extends HttpException {
        private static final long serialVersionUID = 1L;

        protected Forbidden() {
            super(403, "Forbidden");
        }
    }

    public static class NotFound
    extends HttpException {
        private static final long serialVersionUID = 1L;

        protected NotFound() {
            super(404, "Not found");
        }
    }

    public static class Unauthorized
    extends HttpException {
        private static final long serialVersionUID = 1L;

        protected Unauthorized() {
            super(401, "Unauthorized");
        }
    }

    public static class Conflict
    extends HttpException {
        private static final long serialVersionUID = 1L;

        protected Conflict() {
            super(409, "Conflict");
        }
    }
}

