/*
 * Decompiled with CFR 0.152.
 */
package net.koofr.api.json;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.koofr.api.json.JsonBase;
import net.koofr.api.json.JsonException;
import net.koofr.api.util.Log;
import net.koofr.api.util.StdLog;

public class Transmogrifier {
    static Log log = new StdLog();

    protected static boolean jsonHasField(JsonValue jsonValue, String string) {
        if (jsonValue.isObject()) {
            for (String string2 : jsonValue.asObject().names()) {
                if (!string.equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    public static JsonValue mapObject(Object object) throws JsonException {
        try {
            return Transmogrifier.mapObjectUnsafe(object);
        }
        catch (Exception exception) {
            throw new JsonException("Transmogrification bug. Check ur code.", exception);
        }
    }

    public static void dumpObject(Object object) {
        if (object == null) {
            System.out.print("null");
        } else if (object instanceof Integer || object instanceof Long || object instanceof Double || object instanceof Boolean || object instanceof String) {
            System.out.print(object);
        } else if (object.getClass().isArray()) {
            System.out.print("[");
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                Transmogrifier.dumpObject(object);
                System.out.print(",");
            }
            System.out.print("]");
        } else if (object instanceof JsonBase) {
            Field[] fieldArray = object.getClass().getFields();
            System.out.print("{");
            for (Field field : fieldArray) {
                if ((field.getModifiers() & 1) == 0 || (field.getModifiers() & 8) != 0 || (field.getModifiers() & 0x80) != 0 || (field.getModifiers() & 0x40) != 0 || (field.getModifiers() & 0x100) != 0) continue;
                System.out.print(field.getName() + ":");
                try {
                    Transmogrifier.dumpObject(field.get(object));
                }
                catch (Exception exception) {
                    System.out.print("INACCESSIBLE");
                }
                System.out.print(",");
            }
            System.out.print("}");
        } else if (List.class.isAssignableFrom(object.getClass())) {
            System.out.print("[");
            for (Object e : (List)object) {
                Transmogrifier.dumpObject(e);
                System.out.print(",");
            }
            System.out.print("]");
        } else if (Map.class.isAssignableFrom(object.getClass())) {
            System.out.print("{");
            Map map = (Map)Map.class.cast(object);
            for (Object k : map.keySet()) {
                System.out.print(k + ":");
                Transmogrifier.dumpObject(map.get(k));
                System.out.print(",");
            }
            System.out.print("}");
        } else {
            System.out.print(object);
        }
    }

    protected static JsonValue mapObjectUnsafe(Object object) throws JsonException, IllegalAccessException {
        if (object == null) {
            return null;
        }
        if (object instanceof Integer) {
            return Json.value((int)((Integer)object));
        }
        if (object instanceof Long) {
            return Json.value((long)((Long)object));
        }
        if (object instanceof Double) {
            return Json.value((double)((Double)object));
        }
        if (object instanceof Boolean) {
            return Json.value((boolean)((Boolean)object));
        }
        if (object instanceof String) {
            return Json.value((String)((String)object));
        }
        if (object.getClass().isArray()) {
            JsonArray jsonArray = new JsonArray();
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                JsonValue jsonValue = Transmogrifier.mapObjectUnsafe(Array.get(object, i));
                if (jsonValue == null) continue;
                jsonArray.add(jsonValue);
            }
            return jsonArray;
        }
        if (object instanceof JsonBase) {
            Field[] fieldArray;
            JsonObject jsonObject = new JsonObject();
            for (Field field : fieldArray = object.getClass().getFields()) {
                JsonValue jsonValue;
                if ((field.getModifiers() & 1) == 0 || (field.getModifiers() & 8) != 0 || (field.getModifiers() & 0x80) != 0 || (field.getModifiers() & 0x40) != 0 || (field.getModifiers() & 0x100) != 0 || (jsonValue = Transmogrifier.mapObjectUnsafe(field.get(object))) == null) continue;
                jsonObject.add(field.getName(), jsonValue);
            }
            return jsonObject;
        }
        if (List.class.isAssignableFrom(object.getClass())) {
            JsonArray jsonArray = new JsonArray();
            for (Object e : (List)List.class.cast(object)) {
                JsonValue jsonValue = Transmogrifier.mapObjectUnsafe(e);
                if (jsonValue == null) continue;
                jsonArray.add(jsonValue);
            }
            return jsonArray;
        }
        if (Map.class.isAssignableFrom(object.getClass())) {
            JsonObject jsonObject = new JsonObject();
            Map map = (Map)Map.class.cast(object);
            for (Object k : map.keySet()) {
                JsonValue jsonValue = Transmogrifier.mapObjectUnsafe(map.get(k));
                if (jsonValue == null) continue;
                jsonObject.add((String)k, jsonValue);
            }
            return jsonObject;
        }
        throw new JsonException("Unsupported source type: " + object.getClass().getName());
    }

    public static <T> T mappedJsonResponse(JsonValue jsonValue, Class<T> clazz) throws JsonException {
        try {
            return Transmogrifier.mappedJsonResponseUnsafe(jsonValue, clazz, null);
        }
        catch (JsonException jsonException) {
            throw jsonException;
        }
        catch (Exception exception) {
            throw new JsonException("Transmogrification bug. Check ur code.", exception);
        }
    }

    public static <T> T mappedJsonResponse(InputStream inputStream, Class<T> clazz) throws IOException, JsonException {
        JsonValue jsonValue = Json.parse((Reader)new InputStreamReader(inputStream, "UTF-8"));
        return Transmogrifier.mappedJsonResponse(jsonValue, clazz);
    }

    public static Map<String, Object> genericJsonResponse(JsonObject jsonObject) throws JsonException {
        return (Map)Transmogrifier.genericJsonResponse((JsonValue)jsonObject);
    }

    public static List<Object> genericJsonResponse(JsonArray jsonArray) throws JsonException {
        return (List)Transmogrifier.genericJsonResponse((JsonValue)jsonArray);
    }

    public static Object genericJsonResponse(JsonValue jsonValue) throws JsonException {
        if (jsonValue.isNumber()) {
            return jsonValue.asDouble();
        }
        if (jsonValue.isString()) {
            return jsonValue.asString();
        }
        if (jsonValue.isArray()) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            JsonArray jsonArray = jsonValue.asArray();
            int n = jsonArray.size();
            for (int i = 0; i < n; ++i) {
                arrayList.add(Transmogrifier.genericJsonResponse(jsonArray.get(i)));
            }
            return arrayList;
        }
        if (jsonValue.isBoolean()) {
            return jsonValue.asBoolean();
        }
        if (jsonValue.isObject()) {
            Iterator iterator = jsonValue.asObject().iterator();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            while (iterator.hasNext()) {
                JsonObject.Member member = (JsonObject.Member)iterator.next();
                JsonValue jsonValue2 = member.getValue();
                hashMap.put(member.getName(), Transmogrifier.genericJsonResponse(jsonValue2));
            }
            return hashMap;
        }
        throw new JsonException("Unsupported type: " + jsonValue + " (" + jsonValue.getClass().getName() + ")");
    }

    protected static <T> T mappedJsonResponseUnsafe(JsonValue jsonValue, Class<T> clazz, Class clazz2) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException, InstantiationException, JsonException {
        if (jsonValue.isNull()) {
            return null;
        }
        if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            if (!jsonValue.isNumber()) {
                throw new JsonException("Value not an integer.");
            }
            Constructor<T> constructor = clazz.getConstructor(Integer.TYPE);
            return constructor.newInstance(jsonValue.asInt());
        }
        if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            if (!jsonValue.isNumber()) {
                throw new JsonException("Value not a long.");
            }
            Constructor<T> constructor = clazz.getConstructor(Long.TYPE);
            return constructor.newInstance(jsonValue.asLong());
        }
        if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            if (!jsonValue.isNumber()) {
                throw new JsonException("Value not a double.");
            }
            Constructor<T> constructor = clazz.getConstructor(Double.TYPE);
            return constructor.newInstance(jsonValue.asDouble());
        }
        if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            if (!jsonValue.isBoolean()) {
                throw new JsonException("Value not a boolean.");
            }
            Constructor<T> constructor = clazz.getConstructor(Boolean.TYPE);
            return constructor.newInstance(jsonValue.asBoolean());
        }
        if (clazz.equals(String.class)) {
            if (!jsonValue.isString()) {
                throw new JsonException("Value not a string.");
            }
            Constructor<T> constructor = clazz.getConstructor(String.class);
            return constructor.newInstance(jsonValue.asString());
        }
        if (clazz.isArray()) {
            if (!jsonValue.isArray()) {
                throw new JsonException("Value not an array.");
            }
            JsonArray jsonArray = jsonValue.asArray();
            Class<?> clazz3 = clazz.getComponentType();
            int n = jsonArray.size();
            Object object = Array.newInstance(clazz3, n);
            for (int i = 0; i < n; ++i) {
                Array.set(object, i, Transmogrifier.mappedJsonResponseUnsafe(jsonArray.get(i), clazz3, null));
            }
            return clazz.cast(object);
        }
        if (List.class.isAssignableFrom(clazz)) {
            T t;
            if (!jsonValue.isArray()) {
                throw new JsonException("Value not an array.");
            }
            JsonArray jsonArray = jsonValue.asArray();
            int n = jsonArray.size();
            if (clazz.equals(List.class)) {
                t = clazz.cast(new ArrayList());
            } else {
                Constructor<T> constructor = clazz.getConstructor(new Class[0]);
                t = constructor.newInstance(new Object[0]);
            }
            for (int i = 0; i < n; ++i) {
                if (clazz2 != null) {
                    ((List)t).add(Transmogrifier.mappedJsonResponseUnsafe(jsonArray.get(i), clazz2, null));
                    continue;
                }
                ((List)t).add(Transmogrifier.genericJsonResponse(jsonArray.get(i)));
            }
            return t;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            T t;
            if (!jsonValue.isObject()) {
                throw new JsonException("Value not an object.");
            }
            JsonObject jsonObject = jsonValue.asObject();
            if (clazz.equals(Map.class)) {
                t = clazz.cast(new HashMap());
            } else {
                Constructor<T> constructor = clazz.getConstructor(new Class[0]);
                t = constructor.newInstance(new Object[0]);
            }
            for (JsonObject.Member member : jsonObject) {
                if (clazz2 != null) {
                    ((HashMap)t).put(member.getName(), Transmogrifier.mappedJsonResponseUnsafe(member.getValue(), clazz2, null));
                    continue;
                }
                ((HashMap)t).put(member.getName(), Transmogrifier.genericJsonResponse(member.getValue()));
            }
            return t;
        }
        if (JsonBase.class.isAssignableFrom(clazz)) {
            Field[] fieldArray;
            if (!jsonValue.isObject()) {
                throw new JsonException("Value not an object.");
            }
            JsonObject jsonObject = jsonValue.asObject();
            Constructor<T> constructor = clazz.getConstructor(new Class[0]);
            T t = constructor.newInstance(new Object[0]);
            for (Field field : fieldArray = clazz.getFields()) {
                if ((field.getModifiers() & 1) == 0 || (field.getModifiers() & 8) != 0 || (field.getModifiers() & 0x80) != 0 || (field.getModifiers() & 0x40) != 0 || (field.getModifiers() & 0x100) != 0) continue;
                String string = field.getName();
                Class<?> clazz4 = field.getType();
                if (!Transmogrifier.jsonHasField((JsonValue)jsonObject, string)) {
                    field.set(t, null);
                    continue;
                }
                if (clazz4.equals(List.class)) {
                    field.set(t, Transmogrifier.mappedJsonResponseUnsafe(jsonObject.get(string), clazz4, (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]));
                    continue;
                }
                if (clazz4.equals(Map.class)) {
                    field.set(t, Transmogrifier.mappedJsonResponseUnsafe(jsonObject.get(string), clazz4, (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[1]));
                    continue;
                }
                field.set(t, Transmogrifier.mappedJsonResponseUnsafe(jsonObject.get(string), clazz4, null));
            }
            return t;
        }
        throw new JsonException("Unsupported type: " + clazz.getSimpleName());
    }
}

