/*
 * Decompiled with CFR 0.152.
 */
package net.koofr.api.rest.v2;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.koofr.api.http.Body;
import net.koofr.api.http.Response;
import net.koofr.api.http.content.MultipartBody;
import net.koofr.api.json.JsonBase;
import net.koofr.api.json.JsonException;
import net.koofr.api.rest.v2.RMounts;
import net.koofr.api.rest.v2.Resource;
import net.koofr.api.rest.v2.data.Files;

public class RFiles
extends Resource {
    public RFiles(RMounts.RMount rMount) {
        super(rMount, "/files");
    }

    public Files list(String string) throws IOException, JsonException {
        return new RFilesList(this).get(string);
    }

    public Files.File info(String string) throws IOException, JsonException {
        return new RFilesInfo(this).get(string);
    }

    public Files.File tree(String string) throws IOException, JsonException {
        return new RFilesTree(this).get(string);
    }

    public RFilesVersions versions() {
        return new RFilesVersions(this);
    }

    public void createFolder(String string, String string2) throws IOException, JsonException {
        new RFilesFolder(this).create(string, string2);
    }

    public void delete(String string, Files.DeleteOptions deleteOptions) throws IOException, JsonException {
        new RFilesRemove(this).delete(string, deleteOptions);
    }

    public void rename(String string, String string2) throws IOException, JsonException {
        new RFilesRename(this).rename(string, string2);
    }

    public String copy(String string, String string2, String string3) throws IOException, JsonException {
        return new RFilesCopyMove(this, "/copy").execute(string, string2, string3);
    }

    public String move(String string, String string2, String string3) throws IOException, JsonException {
        return new RFilesCopyMove(this, "/move").execute(string, string2, string3);
    }

    public RTags tags() {
        return new RTags(this);
    }

    public String getDownloadUrl(String string) throws IOException, JsonException {
        return new RFilesLink(this, "/download").get(string);
    }

    public String getUploadUrl(String string) throws IOException, JsonException {
        return new RFilesLink(this, "/upload").get(string);
    }

    public Files.DownloadResult download(String string, Files.DownloadOptions downloadOptions) throws IOException {
        Response response = new RFilesContent(this, "/get").get(string, downloadOptions);
        return this.resolveDownload(response);
    }

    public Files.File upload(String string, String string2, String string3, Long l, InputStream inputStream, Files.UploadOptions uploadOptions) throws IOException, JsonException {
        return new RFilesContent(this, "/put").put(string, string2, string3, l, inputStream, uploadOptions);
    }

    private static class RFilesContent
    extends Resource {
        public RFilesContent(RFiles rFiles, String string) {
            super(rFiles, string);
            this.url = this.contentUrl(this.url);
        }

        public Response get(String string, Files.DownloadOptions downloadOptions) throws IOException {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("path");
            arrayList.add(string);
            if (downloadOptions != null) {
                if (downloadOptions.thumbnailSize != null) {
                    arrayList.add("thumb");
                    arrayList.add(downloadOptions.thumbnailSize);
                }
                if (downloadOptions.convertFormat != null) {
                    arrayList.add("convert");
                    arrayList.add(downloadOptions.convertFormat);
                }
            }
            String[] stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            return this.httpGet(stringArray);
        }

        public Files.File put(String string, String string2, String string3, Long l, InputStream inputStream, Files.UploadOptions uploadOptions) throws IOException, JsonException {
            MultipartBody multipartBody = new MultipartBody(string2, string3, l, inputStream);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("path");
            arrayList.add(string);
            arrayList.add("info");
            arrayList.add("true");
            if (uploadOptions != null) {
                if (uploadOptions.size != null) {
                    arrayList.add("overwriteIfSize");
                    arrayList.add(uploadOptions.size.toString());
                }
                if (uploadOptions.modified != null) {
                    arrayList.add("overwriteIfModified");
                    arrayList.add(uploadOptions.modified.toString());
                }
                if (uploadOptions.hash != null) {
                    arrayList.add("overwriteIfHash");
                    arrayList.add(uploadOptions.hash);
                }
                if (uploadOptions.ignoreNonExisting != null) {
                    arrayList.add("overwriteIgnoreNonexisting");
                    arrayList.add(uploadOptions.ignoreNonExisting.toString());
                }
                if (uploadOptions.noRename != null) {
                    arrayList.add("autorename");
                    arrayList.add(String.valueOf(uploadOptions.noRename == false));
                }
                if (uploadOptions.forceOverwrite != null) {
                    arrayList.add("overwrite");
                    arrayList.add(uploadOptions.forceOverwrite.toString());
                }
            }
            String[] stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            return this.resolveJsonResult(this.httpPost((Body)multipartBody, uploadOptions.callback, stringArray), Files.File.class);
        }
    }

    private static class RFilesLink
    extends Resource {
        public RFilesLink(RFiles rFiles, String string) {
            super(rFiles, string);
        }

        public String get(String string) throws IOException, JsonException {
            return this.getResult(FilesLink.class, (String[])new String[]{"path", string}).link;
        }
    }

    public static class FilesLink
    implements JsonBase {
        public String link;
    }

    public static class RTags
    extends Resource {
        public RTags(RFiles rFiles) {
            super(rFiles, "/tags");
        }

        public void add(String string, Map<String, List<String>> map) throws IOException, JsonException {
            new RTagsAction(this, "/add").execute(string, map);
        }

        public void remove(String string, Map<String, List<String>> map) throws IOException, JsonException {
            new RTagsAction(this, "/remove").execute(string, map);
        }
    }

    private static class RTagsAction
    extends Resource {
        public RTagsAction(RTags rTags, String string) {
            super(rTags, string);
        }

        public void execute(String string, Map<String, List<String>> map) throws IOException, JsonException {
            FilesTags filesTags = new FilesTags();
            filesTags.tags = map;
            this.postJsonNoResult(filesTags, "path", string);
        }
    }

    public static class FilesTags
    implements JsonBase {
        public Map<String, List<String>> tags;
    }

    private static class RFilesCopyMove
    extends Resource {
        public RFilesCopyMove(RFiles rFiles, String string) {
            super(rFiles, string);
        }

        public String execute(String string, String string2, String string3) throws IOException, JsonException {
            FilesCopyMove filesCopyMove = new FilesCopyMove();
            filesCopyMove.toMountId = string2;
            filesCopyMove.toPath = string3;
            return this.putJsonResult((Object)filesCopyMove, FilesCopyMoveResult.class, (String[])new String[]{"path", string}).name;
        }
    }

    public static class FilesCopyMoveResult
    implements JsonBase {
        public String name;
    }

    public static class FilesCopyMove
    implements JsonBase {
        public String toMountId;
        public String toPath;
    }

    private static class RFilesRename
    extends Resource {
        public RFilesRename(RFiles rFiles) {
            super(rFiles, "/rename");
        }

        public void rename(String string, String string2) throws IOException, JsonException {
            FilesRename filesRename = new FilesRename();
            filesRename.name = string2;
            this.putJsonNoResult(filesRename, "path", string);
        }
    }

    public static class FilesRename
    implements JsonBase {
        public String name;
    }

    private static class RFilesRemove
    extends Resource {
        public RFilesRemove(RFiles rFiles) {
            super(rFiles, "/remove");
        }

        public void delete(String string, Files.DeleteOptions deleteOptions) throws IOException, JsonException {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("path");
            arrayList.add(string);
            if (deleteOptions != null) {
                if (deleteOptions.size != null) {
                    arrayList.add("removeIfSize");
                    arrayList.add(deleteOptions.size.toString());
                }
                if (deleteOptions.modified != null) {
                    arrayList.add("removeIfModified");
                    arrayList.add(deleteOptions.modified.toString());
                }
                if (deleteOptions.hash != null) {
                    arrayList.add("removeIfHash");
                    arrayList.add(deleteOptions.hash);
                }
                if (deleteOptions.ifEmpty != null) {
                    arrayList.add("removeIfEmpty");
                    arrayList.add(deleteOptions.ifEmpty.toString());
                }
            }
            String[] stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            this.deleteNoResult(stringArray);
        }
    }

    private static class RFilesFolder
    extends Resource {
        public RFilesFolder(RFiles rFiles) {
            super(rFiles, "/folder");
        }

        public void create(String string, String string2) throws IOException, JsonException {
            FilesFolderCreate filesFolderCreate = new FilesFolderCreate();
            filesFolderCreate.name = string2;
            this.postJsonNoResult(filesFolderCreate, "path", string);
        }
    }

    public static class FilesFolderCreate
    implements JsonBase {
        public String name;
    }

    public static class RFilesVersions
    extends Resource {
        public RFilesVersions(RFiles rFiles) {
            super(rFiles, "/versions");
        }

        public Files.Versions get(String string) throws IOException, JsonException {
            return this.getResult(Files.Versions.class, "path", string);
        }

        public String recover(String string, String string2) throws IOException, JsonException {
            return new RFilesVersionsRecover(this).get(string, string2);
        }
    }

    private static class RFilesVersionsRecover
    extends Resource {
        public RFilesVersionsRecover(RFilesVersions rFilesVersions) {
            super(rFilesVersions, "/recover");
        }

        public String get(String string, String string2) throws IOException, JsonException {
            VersionsRecover versionsRecover = this.postJsonResult(VersionsRecover.class, "path", string, "version", string2);
            return versionsRecover.newPath;
        }
    }

    public static class VersionsRecover
    implements JsonBase {
        public String newPath;
    }

    private static class RFilesTree
    extends Resource {
        public RFilesTree(RFiles rFiles) {
            super(rFiles, "/tree");
        }

        public Files.File get(String string) throws IOException, JsonException {
            return this.getResult(Files.File.class, "path", string);
        }
    }

    private static class RFilesInfo
    extends Resource {
        public RFilesInfo(RFiles rFiles) {
            super(rFiles, "/info");
        }

        public Files.File get(String string) throws IOException, JsonException {
            return this.getResult(Files.File.class, "path", string);
        }
    }

    private static class RFilesList
    extends Resource {
        public RFilesList(RFiles rFiles) {
            super(rFiles, "/list");
        }

        public Files get(String string) throws IOException, JsonException {
            return this.getResult(Files.class, "path", string);
        }
    }
}

