/*
 * Decompiled with CFR 0.152.
 */
package net.koofr.api.rest.v2;

import java.io.IOException;
import java.util.Map;
import net.koofr.api.json.JsonBase;
import net.koofr.api.json.JsonException;
import net.koofr.api.rest.v2.Api;
import net.koofr.api.rest.v2.Resource;
import net.koofr.api.rest.v2.data.Groups;
import net.koofr.api.rest.v2.data.Permissions;

public class RGroups
extends Resource {
    public RGroups(Api api) {
        super(api, "/groups");
    }

    public Groups get() throws JsonException, IOException {
        return this.getResult(Groups.class);
    }

    public RGroup group(String string) {
        return new RGroup(this, string);
    }

    public static class RGroupBranding
    extends Resource {
        public RGroupBranding(RGroup rGroup) {
            super(rGroup, "/branding");
        }

        public void edit(Groups.GroupBranding groupBranding) throws JsonException, IOException {
            this.putJsonNoResult(groupBranding, new String[0]);
        }
    }

    public static class RGroupCommon
    extends Resource {
        public RGroupCommon(RGroup rGroup) {
            super(rGroup, "/common");
        }

        public void edit(Long l) throws JsonException, IOException {
            GroupCommonEdit groupCommonEdit = new GroupCommonEdit();
            groupCommonEdit.spaceTotal = l;
            this.putJsonNoResult(groupCommonEdit, new String[0]);
        }

        public static class GroupCommonEdit
        implements JsonBase {
            public Long spaceTotal;
        }
    }

    public static class RGroupAttributes
    extends Resource {
        public RGroupAttributes(RGroup rGroup) {
            super(rGroup, "/attributes");
        }

        public Map<String, Object> get() throws JsonException, IOException {
            return this.getResult(Map.class);
        }
    }

    public static class RGroupUser
    extends Resource {
        public RGroupUser(RGroupUsers rGroupUsers, String string) {
            super(rGroupUsers, "/" + string);
        }

        public void edit(Permissions permissions, Long l) throws JsonException, IOException {
            GroupUserEdit groupUserEdit = new GroupUserEdit();
            groupUserEdit.permissions = permissions;
            groupUserEdit.spaceTotal = l;
            this.putJsonNoResult(groupUserEdit, new String[0]);
        }

        public void delete() throws IOException {
            this.deleteNoResult(new String[0]);
        }

        public static class GroupUserEdit
        implements JsonBase {
            public Permissions permissions;
            public Long spaceTotal;
        }
    }

    public static class RGroupUsers
    extends Resource {
        public RGroupUsers(RGroup rGroup) {
            super(rGroup, "/users");
        }

        public Groups.GroupUser add(String string, Permissions permissions, Long l) throws JsonException, IOException {
            GroupUserCreate groupUserCreate = new GroupUserCreate();
            groupUserCreate.email = string;
            groupUserCreate.permissions = permissions;
            groupUserCreate.spaceTotal = l;
            return this.postJsonResult(groupUserCreate, Groups.GroupUser.class, new String[0]);
        }

        public RGroupUser user(String string) {
            return new RGroupUser(this, string);
        }

        public static class GroupUserCreate
        implements JsonBase {
            public String email;
            public Permissions permissions;
            public Long spaceTotal;
        }
    }

    public static class RGroup
    extends Resource {
        public RGroup(RGroups rGroups, String string) {
            super(rGroups, "/" + string);
        }

        public Groups.Group get() throws JsonException, IOException {
            return this.getResult(Groups.Group.class);
        }

        public RGroupUsers users() {
            return new RGroupUsers(this);
        }

        public RGroupBranding branding() {
            return new RGroupBranding(this);
        }

        public RGroupAttributes attributes() {
            return new RGroupAttributes(this);
        }

        public RGroupCommon common() {
            return new RGroupCommon(this);
        }
    }
}

