/*
 * Decompiled with CFR 0.152.
 */
package net.koofr.api.rest.v2;

import java.io.IOException;
import java.util.Date;
import net.koofr.api.json.JsonBase;
import net.koofr.api.json.JsonException;
import net.koofr.api.rest.v2.RMounts;
import net.koofr.api.rest.v2.Resource;
import net.koofr.api.rest.v2.data.Links;

public class RLinks
extends Resource {
    public RLinks(RMounts.RMount rMount) {
        super(rMount, "/links");
    }

    public Links get() throws IOException, JsonException {
        return this.getResult(Links.class);
    }

    public Links.Link create(String string) throws IOException, JsonException {
        LinkCreate linkCreate = new LinkCreate();
        linkCreate.path = string;
        return this.postJsonResult(linkCreate, Links.Link.class, new String[0]);
    }

    public RLink link(String string) {
        return new RLink(this, string);
    }

    public static class RLink
    extends Resource {
        public RLink(RLinks rLinks, String string) {
            super(rLinks, "/" + string);
        }

        public Links.Link get() throws IOException, JsonException {
            return this.getResult(Links.Link.class);
        }

        public void delete() throws IOException, JsonException {
            this.deleteNoResult(new String[0]);
        }

        public void setHash(String string) throws IOException, JsonException {
            new RLinkUrlHash(this).set(string);
        }

        public RLinkPassword password() {
            return new RLinkPassword(this);
        }

        public Links.Link setValidity(Date date, Date date2) throws IOException, JsonException {
            return new RLinkValidity(this).set(date, date2);
        }

        private static class RLinkValidity
        extends Resource {
            public RLinkValidity(RLink rLink) {
                super(rLink, "/validity");
            }

            public Links.Link set(Date date, Date date2) throws IOException, JsonException {
                LinkValidity linkValidity = new LinkValidity();
                linkValidity.validFrom = date.getTime();
                linkValidity.validTo = date2.getTime();
                return this.putJsonResult(linkValidity, Links.Link.class, new String[0]);
            }
        }

        public static class LinkValidity
        implements JsonBase {
            public Long validFrom;
            public Long validTo;
        }

        public static class RLinkPassword
        extends Resource {
            public RLinkPassword(RLink rLink) {
                super(rLink, "/password");
            }

            public Links.Link delete() throws IOException, JsonException {
                return this.deleteResult(Links.Link.class, new String[0]);
            }

            public Links.Link reset() throws IOException, JsonException {
                return new RLinkPasswordReset(this).reset();
            }
        }

        private static class RLinkPasswordReset
        extends Resource {
            public RLinkPasswordReset(RLinkPassword rLinkPassword) {
                super(rLinkPassword, "/reset");
            }

            public Links.Link reset() throws IOException, JsonException {
                return this.putJsonResult(Links.Link.class, new String[0]);
            }
        }

        private static class RLinkUrlHash
        extends Resource {
            public RLinkUrlHash(RLink rLink) {
                super(rLink, "/urlHash");
            }

            public Links.Link set(String string) throws IOException, JsonException {
                LinkSetHash linkSetHash = new LinkSetHash();
                linkSetHash.hash = string;
                return this.putJsonResult(linkSetHash, Links.Link.class, new String[0]);
            }
        }

        public static class LinkSetHash
        implements JsonBase {
            public String hash;
        }
    }

    public static class LinkCreate
    implements JsonBase {
        public String path;
    }
}

