/*
 * Decompiled with CFR 0.152.
 */
package net.koofr.api.rest.v2;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.koofr.api.auth.Authenticator;
import net.koofr.api.http.Body;
import net.koofr.api.http.Client;
import net.koofr.api.http.Request;
import net.koofr.api.http.Response;
import net.koofr.api.http.content.JsonBody;
import net.koofr.api.http.errors.BadContentTypeException;
import net.koofr.api.http.errors.HttpException;
import net.koofr.api.json.JsonException;
import net.koofr.api.json.Transmogrifier;
import net.koofr.api.rest.v2.data.Files;
import net.koofr.api.util.Log;

public class Resource {
    Authenticator auth;
    Client httpClient;
    String url;
    private static Log log = null;

    private static boolean shouldLogHttp() {
        return log != null;
    }

    public static void setHttpLog(Log log) {
        Resource.log = log;
    }

    public Resource(Authenticator authenticator, Client client, String string) {
        this.auth = authenticator;
        this.httpClient = client;
        this.url = string;
    }

    public Resource(Resource resource) {
        this.auth = resource.auth;
        this.httpClient = resource.httpClient;
        this.url = resource.url;
    }

    public Resource(Resource resource, String string) {
        this(resource);
        this.url = resource.url + string;
    }

    protected Response httpArmAndExecute(Request request, Body body, Request.TransferCallback transferCallback) throws IOException {
        if (this.auth != null) {
            this.auth.arm(request);
        }
        if (body != null) {
            if (Resource.shouldLogHttp() && body instanceof JsonBody) {
                log.debug(body.toString());
            }
            return request.execute(body, transferCallback);
        }
        return request.execute();
    }

    protected String urlEncode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    protected String urlWithParameters(String ... stringArray) {
        if (stringArray.length == 0) {
            return this.url;
        }
        if (stringArray.length % 2 != 0) {
            throw new IllegalArgumentException("Parameters are not an even-sized array of names and values.");
        }
        StringBuilder stringBuilder = new StringBuilder(this.url).append("?");
        for (int i = 0; i < stringArray.length; i += 2) {
            if (i > 0) {
                stringBuilder.append("&");
            }
            stringBuilder.append(stringArray[i]).append("=").append(this.urlEncode(stringArray[i + 1]));
        }
        return stringBuilder.toString();
    }

    protected Response httpGet(String ... stringArray) throws IOException {
        return this.httpArmAndExecute(this.httpClient.get(this.urlWithParameters(stringArray)), null, null);
    }

    protected Response httpPut(String ... stringArray) throws IOException {
        return this.httpArmAndExecute(this.httpClient.put(this.urlWithParameters(stringArray)), null, null);
    }

    protected Response httpPut(Body body, String ... stringArray) throws IOException {
        return this.httpArmAndExecute(this.httpClient.put(this.urlWithParameters(stringArray)), body, null);
    }

    protected Response httpPost(String ... stringArray) throws IOException {
        return this.httpArmAndExecute(this.httpClient.post(this.urlWithParameters(stringArray)), null, null);
    }

    protected Response httpPost(Body body, String ... stringArray) throws IOException {
        return this.httpArmAndExecute(this.httpClient.post(this.urlWithParameters(stringArray)), body, null);
    }

    protected Response httpPost(Body body, Request.TransferCallback transferCallback, String ... stringArray) throws IOException {
        return this.httpArmAndExecute(this.httpClient.post(this.urlWithParameters(stringArray)), body, transferCallback);
    }

    protected Response httpDelete(String ... stringArray) throws IOException {
        return this.httpArmAndExecute(this.httpClient.delete(this.urlWithParameters(stringArray)), null, null);
    }

    protected <T> T getResult(Class<T> clazz, String ... stringArray) throws JsonException, IOException {
        return this.resolveJsonResult(this.httpGet(stringArray), clazz);
    }

    protected <T> T getResult(Class<T> clazz) throws JsonException, IOException {
        return this.resolveJsonResult(this.httpGet(new String[0]), clazz);
    }

    protected void getNoResult(String ... stringArray) throws IOException {
        this.resolveNoResult(this.httpGet(new String[0]));
    }

    protected void deleteNoResult(String ... stringArray) throws IOException {
        this.resolveNoResult(this.httpDelete(stringArray));
    }

    protected <T> T deleteResult(Class<T> clazz, String ... stringArray) throws JsonException, IOException {
        return this.resolveJsonResult(this.httpDelete(stringArray), clazz);
    }

    protected <T> T putJsonResult(Object object, Class<T> clazz, String ... stringArray) throws JsonException, IOException {
        return this.resolveJsonResult(this.httpPut(new JsonBody(Transmogrifier.mapObject(object)), stringArray), clazz);
    }

    protected <T> T putJsonResult(Class<T> clazz, String ... stringArray) throws JsonException, IOException {
        return this.resolveJsonResult(this.httpPut(stringArray), clazz);
    }

    protected void putJsonNoResult(Object object, String ... stringArray) throws JsonException, IOException {
        this.resolveNoResult(this.httpPut(new JsonBody(Transmogrifier.mapObject(object)), stringArray));
    }

    protected void putJsonNoResult(String ... stringArray) throws JsonException, IOException {
        this.resolveNoResult(this.httpPut(stringArray));
    }

    protected <T> T postJsonResult(Object object, Class<T> clazz, String ... stringArray) throws JsonException, IOException {
        return this.resolveJsonResult(this.httpPost((Body)new JsonBody(Transmogrifier.mapObject(object)), stringArray), clazz);
    }

    protected <T> T postJsonResult(Class<T> clazz, String ... stringArray) throws JsonException, IOException {
        return this.resolveJsonResult(this.httpPost(stringArray), clazz);
    }

    protected void postJsonNoResult(Object object, String ... stringArray) throws JsonException, IOException {
        this.resolveNoResult(this.httpPost((Body)new JsonBody(Transmogrifier.mapObject(object)), stringArray));
    }

    protected void postJsonNoResult(String ... stringArray) throws JsonException, IOException {
        this.resolveNoResult(this.httpPost(stringArray));
    }

    protected void resolveNoResult(Response response) throws IOException {
        try {
            if (Resource.shouldLogHttp()) {
                Resource.logResponse(response);
                HttpException.checkResponse(response);
            } else {
                HttpException.checkResponse(response);
            }
        }
        finally {
            response.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T resolveJsonResult(Response response, Class<T> clazz) throws JsonException, IOException {
        try {
            Object object;
            if (response.getStatus() / 100 != 2) {
                if (Resource.shouldLogHttp()) {
                    Resource.logResponse(response);
                }
                HttpException.checkResponse(response);
            }
            String string = response.getHeader("Content-Type");
            Map<String, List<String>> map = response.getHeaders();
            if (Resource.shouldLogHttp()) {
                for (String string2 : map.keySet()) {
                    log.debug("Header: " + string2);
                    for (String string3 : map.get(string2)) {
                        log.debug("  " + string3);
                    }
                }
            }
            if (string == null || !string.startsWith("application/json")) {
                throw new BadContentTypeException();
            }
            if (Resource.shouldLogHttp()) {
                String string2;
                object = Resource.logResponse(response);
                string2 = Transmogrifier.mappedJsonResponse(new ByteArrayInputStream(((String)object).getBytes("UTF-8")), clazz);
                return (T)string2;
            }
            object = Transmogrifier.mappedJsonResponse(response.getInputStream(), clazz);
            return (T)object;
        }
        finally {
            response.close();
        }
    }

    protected Files.DownloadResult resolveDownload(Response response) throws IOException {
        try {
            HttpException.checkResponse(response);
            Files.DownloadResult downloadResult = new Files.DownloadResult(response);
            downloadResult.contentType = response.getHeader("Content-Type");
            downloadResult.contentLength = null;
            try {
                String string = response.getHeader("Content-Length");
                if (string != null) {
                    downloadResult.contentLength = Long.parseLong(string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            downloadResult.downloadStream = response.getInputStream();
            return downloadResult;
        }
        catch (IOException iOException) {
            response.close();
            throw iOException;
        }
    }

    protected String contentUrl(String string) {
        return string.replaceFirst("/api/v2/", "/content/api/v2/");
    }

    private static String logResponse(Response response) {
        try {
            int n;
            log.debug("Response status code: " + response.getStatus());
            StringBuilder stringBuilder = new StringBuilder();
            byte[] byArray = new byte[1024];
            InputStream inputStream = response.getInputStream();
            while ((n = inputStream.read(byArray)) >= 0) {
                byte[] byArray2 = Arrays.copyOf(byArray, n);
                stringBuilder.append(new String(byArray2, "UTF-8"));
            }
            if (stringBuilder.length() > 0) {
                log.debug("Response body: " + stringBuilder.toString());
                return stringBuilder.toString();
            }
            log.debug("No body.");
        }
        catch (IOException iOException) {
            log.debug("Request failed: " + iOException);
        }
        return null;
    }
}

