/*
 * Decompiled with CFR 0.152.
 */
package net.koofr.api.auth.oauth2;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Date;
import net.koofr.api.auth.Authenticator;
import net.koofr.api.http.Client;
import net.koofr.api.http.Request;
import net.koofr.api.http.Response;
import net.koofr.api.http.content.UrlEncodedBody;
import net.koofr.api.http.errors.HttpException;

public class OAuth2Authenticator
implements Authenticator {
    Client httpClient;
    String tokenUrl;
    String clientId;
    String clientSecret;
    String redirectUri;
    String refreshToken;
    String accessToken;
    Date accessExpiration;
    private static final int EXPIRATION_GUARD = 60000;

    public OAuth2Authenticator(Client client, String string, String string2, String string3, String string4) {
        this.httpClient = client;
        this.tokenUrl = string;
        this.clientId = string2;
        this.clientSecret = string3;
        this.redirectUri = string4;
    }

    private void parseTokenResponse(Response response) throws IOException {
        HttpException.checkResponse(response);
        JsonObject jsonObject = Json.parse((Reader)new InputStreamReader(response.getInputStream(), "UTF-8")).asObject();
        try {
            String string = jsonObject.getString("refresh_token", null);
            String string2 = jsonObject.getString("access_token", null);
            long l = jsonObject.getLong("expires_in", 0L);
            if (string != null && string2 != null && l > 0L) {
                this.refreshToken = string;
                this.accessToken = string2;
                this.accessExpiration = new Date(new Date().getTime() + l * 1000L - 60000L);
            }
        }
        catch (Exception exception) {
            throw new IOException("Bad token response: " + jsonObject.toString(), exception);
        }
    }

    public void setGrantCode(String string) throws IOException {
        Request request = this.httpClient.post(this.tokenUrl);
        UrlEncodedBody urlEncodedBody = new UrlEncodedBody("client_id", this.clientId, "client_secret", this.clientSecret, "grant_type", "authorization_code", "code", string, "redirect_uri", this.redirectUri);
        Response response = request.execute(urlEncodedBody);
        this.parseTokenResponse(response);
    }

    public void setRefreshToken(String string) throws IOException {
        Request request = this.httpClient.post(this.tokenUrl);
        UrlEncodedBody urlEncodedBody = new UrlEncodedBody("client_id", this.clientId, "client_secret", this.clientSecret, "grant_type", "refresh_token", "refresh_token", string);
        Response response = request.execute(urlEncodedBody);
        this.parseTokenResponse(response);
    }

    @Override
    public void arm(Request request) throws IOException {
        String string = this.getAccessToken();
        if (string != null) {
            request.addHeader("Authorization", "Bearer " + string);
        }
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getAccessToken() throws IOException {
        if (this.refreshToken != null && (this.accessToken == null || this.accessExpiration == null || new Date().after(this.accessExpiration))) {
            this.setRefreshToken(this.refreshToken);
        }
        return this.accessToken;
    }

    public Date getExpirationDate() {
        return this.accessExpiration;
    }
}

