/*
 * Decompiled with CFR 0.152.
 */
package net.koofr.api.http.content;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.UUID;
import java.util.Vector;
import net.koofr.api.http.Body;

public class MultipartBody
implements Body {
    public static final String LF = "\r\n";
    final String boundary = "JavaKoofrApi3-" + UUID.randomUUID().toString();
    String partFileName;
    String partContentType;
    InputStream partInputStream;
    InputStream multipartStream;
    Long partSize;
    Long contentLength;

    public MultipartBody(String string, String string2, Long l, InputStream inputStream) throws IOException {
        this.partFileName = string;
        this.partContentType = string2;
        this.partInputStream = inputStream;
        this.partSize = l;
        Vector<InputStream> vector = new Vector<InputStream>();
        byte[] byArray = ("--" + this.boundary + LF + "Content-Disposition: form-data; name=\"file\"; filename=\"" + this.partFileName + "\"" + LF + "Content-Type: " + this.partContentType + LF + LF).getBytes("UTF-8");
        long l2 = byArray.length;
        vector.add(new ByteArrayInputStream(byArray));
        vector.add(this.partInputStream);
        byArray = (LF + "--" + this.boundary + "--" + LF).getBytes("UTF-8");
        vector.add(new ByteArrayInputStream(byArray));
        this.multipartStream = new SequenceInputStream(vector.elements());
        this.contentLength = this.partSize != null ? Long.valueOf((l2 += (long)byArray.length) + this.partSize) : null;
    }

    public MultipartBody(String string, String string2, InputStream inputStream) throws IOException {
        this(string, string2, null, inputStream);
    }

    @Override
    public String getContentType() {
        return "multipart/form-data; boundary=" + this.boundary;
    }

    @Override
    public Long getContentLength() {
        return this.contentLength;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.multipartStream;
    }
}

