/*
 * Decompiled with CFR 0.152.
 */
package net.koofr.api.http.impl.basic;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.Map;
import net.koofr.api.http.Body;
import net.koofr.api.http.Request;
import net.koofr.api.http.Response;
import net.koofr.api.http.errors.CancelledException;
import net.koofr.api.http.impl.basic.BasicResponse;

public class BasicRequest
implements Request {
    static final int BUFFER_SIZE = 65536;
    HttpURLConnection cnx;

    protected BasicRequest(HttpURLConnection httpURLConnection) {
        this.cnx = httpURLConnection;
    }

    @Override
    public void setHeaders(Map<String, String> map) {
        throw new RuntimeException("Operation not supported.");
    }

    @Override
    public void addHeader(String string, String string2) {
        this.cnx.setRequestProperty(string, string2);
    }

    @Override
    public Response execute() {
        this.cnx.setRequestProperty("Accept-Encoding", "gzip");
        return new BasicResponse(this.cnx);
    }

    @Override
    public Response execute(Body body) throws IOException {
        return this.execute(body, null);
    }

    @Override
    public Response execute(Body body, Request.TransferCallback transferCallback) throws IOException {
        String string = body.getContentType();
        Long l = body.getContentLength();
        this.cnx.setRequestProperty("Accept-Encoding", "gzip");
        if (string != null) {
            this.cnx.setRequestProperty("Content-Type", string);
        }
        if (l != null) {
            this.cnx.setRequestProperty("Content-Length", l.toString());
            this.cnx.setFixedLengthStreamingMode(l);
        } else {
            this.cnx.setChunkedStreamingMode(0);
        }
        OutputStream outputStream = this.cnx.getOutputStream();
        InputStream inputStream = body.getInputStream();
        byte[] byArray = new byte[65536];
        int n = 0;
        long l2 = 0L;
        while ((n = inputStream.read(byArray)) >= 0) {
            if (transferCallback != null && transferCallback.isCancelled()) {
                throw new CancelledException();
            }
            if (n <= 0) continue;
            outputStream.write(byArray, 0, n);
            if (transferCallback == null) continue;
            transferCallback.progress(l2 += (long)n, l);
        }
        return new BasicResponse(this.cnx);
    }
}

