/*
 * Decompiled with CFR 0.152.
 */
package net.koofr.api.rest.v2;

import java.io.IOException;
import net.koofr.api.json.JsonBase;
import net.koofr.api.json.JsonException;
import net.koofr.api.rest.v2.Api;
import net.koofr.api.rest.v2.RComments;
import net.koofr.api.rest.v2.RFiles;
import net.koofr.api.rest.v2.RLinks;
import net.koofr.api.rest.v2.RReceivers;
import net.koofr.api.rest.v2.Resource;
import net.koofr.api.rest.v2.data.Bundle;
import net.koofr.api.rest.v2.data.Mounts;
import net.koofr.api.rest.v2.data.Permissions;

public class RMounts
extends Resource {
    public RMounts(Api api) {
        super(api, "/mounts");
    }

    public Mounts get() throws JsonException, IOException {
        return this.getResult(Mounts.class);
    }

    public RMount mount(String string) {
        return new RMount(this, string);
    }

    private static class RBundle
    extends Resource {
        public RBundle(RMount rMount) {
            super(rMount, "/bundle");
        }

        public Bundle get(String string) throws JsonException, IOException {
            return this.getResult(Bundle.class, "path", string);
        }
    }

    public static class RMountGroup
    extends Resource {
        public RMountGroup(RMount rMount, String string) {
            super(rMount, "/groups/" + string);
        }

        public void add(Permissions permissions) throws JsonException, IOException {
            MountGroupEdit mountGroupEdit = new MountGroupEdit();
            mountGroupEdit.permissions = permissions;
            this.putJsonNoResult(mountGroupEdit, new String[0]);
        }

        public void delete() throws JsonException, IOException {
            this.deleteNoResult(new String[0]);
        }

        public static class MountGroupEdit
        implements JsonBase {
            public Permissions permissions;
        }
    }

    public static class RMountUser
    extends Resource {
        public RMountUser(RMountUsers rMountUsers, String string) {
            super(rMountUsers, "/" + string);
        }

        public void edit(Permissions permissions) throws JsonException, IOException {
            MountUserEdit mountUserEdit = new MountUserEdit();
            mountUserEdit.permissions = permissions;
            this.putJsonNoResult(mountUserEdit, new String[0]);
        }

        public void delete() throws JsonException, IOException {
            this.deleteNoResult(new String[0]);
        }

        public static class MountUserEdit
        implements JsonBase {
            public Permissions permissions;
        }
    }

    public static class RMountUsers
    extends Resource {
        public RMountUsers(RMount rMount) {
            super(rMount, "/users");
        }

        public Mounts.MountUser add(String string, String string2, Permissions permissions) throws JsonException, IOException {
            MountUserAdd mountUserAdd = new MountUserAdd();
            mountUserAdd.id = string;
            mountUserAdd.email = string2;
            mountUserAdd.permissions = permissions;
            return this.postJsonResult(mountUserAdd, Mounts.MountUser.class, new String[0]);
        }

        public RMountUser user(String string) {
            return new RMountUser(this, string);
        }

        public static class MountUserAdd
        implements JsonBase {
            public String id;
            public String email;
            public Permissions permissions;
        }
    }

    public static class RMount
    extends Resource {
        public RMount(RMounts rMounts, String string) {
            super(rMounts, "/" + string);
        }

        public Mounts.Mount get() throws JsonException, IOException {
            return this.getResult(Mounts.Mount.class);
        }

        public void edit(String string) throws JsonException, IOException {
            MountEdit mountEdit = new MountEdit();
            mountEdit.name = string;
            this.putJsonNoResult(mountEdit, new String[0]);
        }

        public void delete() throws JsonException, IOException {
            this.deleteNoResult(new String[0]);
        }

        public Mounts.Mount createSubmount(String string, String string2) throws JsonException, IOException {
            SubmountCreate submountCreate = new SubmountCreate();
            submountCreate.path = string2;
            submountCreate.name = string;
            return new Resource(this, "/submounts").postJsonResult(submountCreate, Mounts.Mount.class, new String[0]);
        }

        public RMountUsers users() {
            return new RMountUsers(this);
        }

        public RMountGroup group(String string) {
            return new RMountGroup(this, string);
        }

        public Bundle bundle(String string) throws IOException, JsonException {
            return new RBundle(this).get(string);
        }

        public RFiles files() {
            return new RFiles(this);
        }

        public RComments comments() {
            return new RComments(this);
        }

        public RLinks links() {
            return new RLinks(this);
        }

        public RReceivers receivers() {
            return new RReceivers(this);
        }

        public static class SubmountCreate
        implements JsonBase {
            public String name;
            public String path;
        }

        public static class MountEdit
        implements JsonBase {
            public String name;
        }
    }
}

