/*
 * Decompiled with CFR 0.152.
 */
package net.koofr.api.rest.v2;

import java.io.IOException;
import java.util.Date;
import net.koofr.api.json.JsonBase;
import net.koofr.api.json.JsonException;
import net.koofr.api.rest.v2.RMounts;
import net.koofr.api.rest.v2.Resource;
import net.koofr.api.rest.v2.data.Receivers;

public class RReceivers
extends Resource {
    public RReceivers(RMounts.RMount rMount) {
        super(rMount, "/receivers");
    }

    public Receivers get() throws IOException, JsonException {
        return this.getResult(Receivers.class);
    }

    public Receivers.Receiver create(String string) throws IOException, JsonException {
        ReceiverCreate receiverCreate = new ReceiverCreate();
        receiverCreate.path = string;
        return this.postJsonResult(receiverCreate, Receivers.Receiver.class, new String[0]);
    }

    public RReceiver receiver(String string) {
        return new RReceiver(this, string);
    }

    public static class RReceiver
    extends Resource {
        public RReceiver(RReceivers rReceivers, String string) {
            super(rReceivers, "/" + string);
        }

        public Receivers.Receiver get() throws IOException, JsonException {
            return this.getResult(Receivers.Receiver.class);
        }

        public void delete() throws IOException, JsonException {
            this.deleteNoResult(new String[0]);
        }

        public void setHash(String string) throws IOException, JsonException {
            new RReceiverUrlHash(this).set(string);
        }

        public RReceiverPassword password() {
            return new RReceiverPassword(this);
        }

        public Receivers.Receiver setValidity(Date date, Date date2) throws IOException, JsonException {
            return new RReceiverValidity(this).set(date, date2);
        }

        private static class RReceiverValidity
        extends Resource {
            public RReceiverValidity(RReceiver rReceiver) {
                super(rReceiver, "/validity");
            }

            public Receivers.Receiver set(Date date, Date date2) throws IOException, JsonException {
                ReceiverValidity receiverValidity = new ReceiverValidity();
                receiverValidity.validFrom = date.getTime();
                receiverValidity.validTo = date2.getTime();
                return this.putJsonResult(receiverValidity, Receivers.Receiver.class, new String[0]);
            }
        }

        public static class ReceiverValidity
        implements JsonBase {
            public Long validFrom;
            public Long validTo;
        }

        public static class RReceiverPassword
        extends Resource {
            public RReceiverPassword(RReceiver rReceiver) {
                super(rReceiver, "/password");
            }

            public Receivers.Receiver delete() throws IOException, JsonException {
                return this.deleteResult(Receivers.Receiver.class, new String[0]);
            }

            public Receivers.Receiver reset() throws IOException, JsonException {
                return new RReceiverPasswordReset(this).reset();
            }
        }

        private static class RReceiverPasswordReset
        extends Resource {
            public RReceiverPasswordReset(RReceiverPassword rReceiverPassword) {
                super(rReceiverPassword, "/reset");
            }

            public Receivers.Receiver reset() throws IOException, JsonException {
                return this.putJsonResult(Receivers.Receiver.class, new String[0]);
            }
        }

        private static class RReceiverUrlHash
        extends Resource {
            public RReceiverUrlHash(RReceiver rReceiver) {
                super(rReceiver, "/urlHash");
            }

            public Receivers.Receiver set(String string) throws IOException, JsonException {
                ReceiverSetHash receiverSetHash = new ReceiverSetHash();
                receiverSetHash.hash = string;
                return this.putJsonResult(receiverSetHash, Receivers.Receiver.class, new String[0]);
            }
        }

        public static class ReceiverSetHash
        implements JsonBase {
            public String hash;
        }
    }

    public static class ReceiverCreate
    implements JsonBase {
        public String path;
    }
}

