/*
 * Decompiled with CFR 0.152.
 */
package net.koofr.api.rest.v2;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import net.koofr.api.http.Body;
import net.koofr.api.http.content.MultipartBody;
import net.koofr.api.json.JsonBase;
import net.koofr.api.json.JsonException;
import net.koofr.api.rest.v2.Api;
import net.koofr.api.rest.v2.RSettings;
import net.koofr.api.rest.v2.Resource;
import net.koofr.api.rest.v2.data.Bookmarks;
import net.koofr.api.rest.v2.data.ConnectionList;
import net.koofr.api.rest.v2.data.Files;
import net.koofr.api.rest.v2.data.Self;

public class RSelf
extends Resource {
    public RSelf(Api api) {
        super(api, "/user");
    }

    public Self get() throws JsonException, IOException {
        return this.getResult(Self.class);
    }

    public RConnections connections() throws JsonException, IOException {
        return new RConnections(this);
    }

    public void edit(String string, String string2) throws JsonException, IOException {
        Edit edit = new Edit();
        edit.firstName = string;
        edit.lastName = string2;
        this.putJsonNoResult(edit, new String[0]);
    }

    public RPassword password() {
        return new RPassword();
    }

    public REmail email() {
        return new REmail();
    }

    public RAttributes attributes() {
        return new RAttributes();
    }

    public RAppConfig appConfig() {
        return new RAppConfig();
    }

    public RSettings settings() {
        return new RSettings(this);
    }

    public RBookmarks bookmarks() {
        return new RBookmarks();
    }

    public RActivity activity() {
        return new RActivity();
    }

    public RProfilePicture profilePicture() {
        return new RProfilePicture(this);
    }

    public static class RProfilePicture
    extends Resource {
        public RProfilePicture(RSelf rSelf) {
            super(rSelf, "/profile-picture");
            this.url = this.contentUrl(this.url);
        }

        public Files.DownloadResult get() throws IOException {
            return this.resolveDownload(this.httpGet("nodefault", "true"));
        }

        public void update(InputStream inputStream, String string, String string2) throws IOException {
            new Update(this).update(inputStream, string, string2);
        }

        private static class Update
        extends Resource {
            public Update(RProfilePicture rProfilePicture) {
                super(rProfilePicture, "/update");
            }

            public void update(InputStream inputStream, String string, String string2) throws IOException {
                MultipartBody multipartBody = new MultipartBody(string, string2, inputStream);
                this.resolveNoResult(this.httpPost((Body)multipartBody, new String[0]));
            }
        }
    }

    public class RActivity
    extends Resource {
        public RActivity() {
            super(RSelf.this, "/activity");
        }

        public void get() {
            throw new RuntimeException("Not implemented.");
        }
    }

    public class RBookmarks
    extends Resource {
        public RBookmarks() {
            super(RSelf.this, "/bookmarks");
        }

        public Bookmarks get() throws JsonException, IOException {
            return this.getResult(Bookmarks.class);
        }

        public void create(Bookmarks.Bookmark bookmark) throws JsonException, IOException {
            this.postJsonNoResult(bookmark, new String[0]);
        }

        public void edit(Bookmarks bookmarks) throws JsonException, IOException {
            this.putJsonNoResult(bookmarks, new String[0]);
        }

        public void delete(String string, String string2) throws IOException {
            this.deleteNoResult("mountId", string, "path", string2);
        }
    }

    public class RAppConfig
    extends Resource {
        public RAppConfig() {
            super(RSelf.this, "/appconfig");
        }

        public Map<String, Object> get() throws JsonException, IOException {
            return this.getResult(Map.class);
        }
    }

    public class RAttributes
    extends Resource {
        public RAttributes() {
            super(RSelf.this, "/attributes");
        }

        public Map<String, Object> get() throws JsonException, IOException {
            return this.getResult(Map.class);
        }
    }

    public class REmail
    extends Resource {
        public REmail() {
            super(RSelf.this, "/changeemail");
        }

        public void change(String string) throws JsonException, IOException {
            EmailChange emailChange = new EmailChange();
            emailChange.newEmail = string;
            this.putJsonNoResult(emailChange, new String[0]);
        }
    }

    public class EmailChange
    implements JsonBase {
        public String newEmail;
    }

    public class RPassword
    extends Resource {
        public RPassword() {
            super(RSelf.this, "/password");
        }

        public void change(String string, String string2) throws JsonException, IOException {
            PasswordChange passwordChange = new PasswordChange();
            passwordChange.oldPassword = string;
            passwordChange.newPassword = string2;
            this.putJsonNoResult(passwordChange, new String[0]);
        }
    }

    public class PasswordChange
    implements JsonBase {
        public String oldPassword;
        public String newPassword;
    }

    public class Edit
    implements JsonBase {
        public String firstName;
        public String lastName;
    }

    public static class RConnections
    extends Resource {
        public RConnections(RSelf rSelf) {
            super(rSelf, "/connections");
        }

        public ConnectionList get() throws JsonException, IOException {
            return this.getResult(ConnectionList.class);
        }
    }
}

