/*
 * Decompiled with CFR 0.152.
 */
package net.sinofool.wechat.app;

import net.sinofool.wechat.WeChatUserInfo;
import net.sinofool.wechat.app.WeChatAppAccessInfo;
import net.sinofool.wechat.app.WeChatAppConfig;
import net.sinofool.wechat.app.WeChatAppHttpClient;
import net.sinofool.wechat.thirdparty.org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeChatApp {
    private static final Logger LOG = LoggerFactory.getLogger(WeChatApp.class);
    private final WeChatAppConfig config;
    private final WeChatAppHttpClient httpClient;

    public WeChatApp(WeChatAppConfig config, WeChatAppHttpClient httpClient) {
        this.config = config;
        this.httpClient = httpClient;
    }

    public boolean getAccessInfo(String code, WeChatAppAccessInfo access) {
        String ret = this.httpClient.get("api.weixin.qq.com", 443, "https", "/sns/oauth2/access_token?appid=" + this.config.getAppId() + "&secret=" + this.config.getAppSecret() + "&code=" + code + "&grant_type=authorization_code");
        JSONObject json = new JSONObject(ret);
        access.setAccessToken(json.getString("access_token"));
        access.setExpiresIn(json.getInt("expires_in"));
        access.setRefreshToken(json.getString("refresh_token"));
        access.setOpenId(json.getString("openid"));
        access.setScope(json.getString("scope"));
        return true;
    }

    public WeChatUserInfo getUserInfo(String accessToken, String openid) {
        String ret = this.httpClient.get("api.weixin.qq.com", 443, "https", "/sns/userinfo?access_token=" + accessToken + "&openid=" + openid);
        return this.parseWeChatUser(ret);
    }

    private WeChatUserInfo parseWeChatUser(String ret) {
        LOG.debug("Parsing WeChatUser {}", (Object)ret);
        return WeChatUserInfo.valueOf(ret);
    }
}

