/*
 * Decompiled with CFR 0.152.
 */
package net.sinofool.wechat.miniapp;

import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.sinofool.wechat.miniapp.WeChatMiniAppConfig;
import net.sinofool.wechat.miniapp.WeChatMiniAppEncryptedUserInfo;
import net.sinofool.wechat.miniapp.WeChatMiniAppHttpClient;
import net.sinofool.wechat.miniapp.WeChatMiniAppSessionInfo;
import net.sinofool.wechat.miniapp.WeChatMiniAppUserInfo;
import net.sinofool.wechat.thirdparty.org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeChatMiniApp {
    private static final Logger LOG = LoggerFactory.getLogger(WeChatMiniApp.class);
    private final WeChatMiniAppConfig config;
    private final WeChatMiniAppHttpClient httpClient;

    public WeChatMiniApp(WeChatMiniAppConfig config, WeChatMiniAppHttpClient httpClient) {
        this.config = config;
        this.httpClient = httpClient;
    }

    public boolean getSessionInfo(String code, WeChatMiniAppSessionInfo session) {
        String ret = this.httpClient.get("api.weixin.qq.com", 443, "https", "/sns/jscode2session?appid=" + this.config.getAppId() + "&secret=" + this.config.getAppSecret() + "&js_code=" + code + "&grant_type=authorization_code");
        JSONObject json = new JSONObject(ret);
        if (json.has("openid") && json.has("session_key")) {
            session.setOpenid(json.getString("openid"));
            session.setSessionKey(json.getString("session_key"));
            return true;
        }
        return false;
    }

    public WeChatMiniAppUserInfo decryptUserInfo(WeChatMiniAppSessionInfo session, WeChatMiniAppEncryptedUserInfo encryptedUserInfo) {
        try {
            IvParameterSpec iv = new IvParameterSpec(Base64.getDecoder().decode(encryptedUserInfo.getBase64Iv()));
            SecretKeySpec key = new SecretKeySpec(Base64.getDecoder().decode(session.getSessionKey()), "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
            cipher.init(2, (Key)key, iv);
            byte[] dec = cipher.doFinal(Base64.getDecoder().decode(encryptedUserInfo.getBase64EncryptedData()));
            return WeChatMiniAppUserInfo.valueOf(new String(dec, Charset.forName("UTF-8")));
        }
        catch (NoSuchAlgorithmException e) {
            LOG.warn("Error decrypt Wechat MiniApp user info", (Throwable)e);
        }
        catch (InvalidKeyException e) {
            LOG.warn("Error decrypt Wechat MiniApp user info", (Throwable)e);
        }
        catch (InvalidAlgorithmParameterException e) {
            LOG.warn("Error decrypt Wechat MiniApp user info", (Throwable)e);
        }
        catch (NoSuchPaddingException e) {
            LOG.warn("Error decrypt Wechat MiniApp user info", (Throwable)e);
        }
        catch (BadPaddingException e) {
            LOG.warn("Error decrypt Wechat MiniApp user info", (Throwable)e);
        }
        catch (IllegalBlockSizeException e) {
            LOG.warn("Error decrypt Wechat MiniApp user info", (Throwable)e);
        }
        return null;
    }
}

