/*
 * Decompiled with CFR 0.152.
 */
package net.sinofool.wechat.pay;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import net.sinofool.wechat.WeChatException;
import net.sinofool.wechat.base.OneLevelOnlyXML;
import net.sinofool.wechat.base.StringPair;
import net.sinofool.wechat.mp.WeChatMPEventHandler;
import net.sinofool.wechat.mp.WeChatUtils;
import net.sinofool.wechat.pay.WeChatPayConfig;
import net.sinofool.wechat.pay.WeChatPayHttpClient;
import net.sinofool.wechat.pay.WeChatPayRequestData;
import net.sinofool.wechat.pay.WeChatPayResponseData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class WeChatPay {
    private static final Logger LOG = LoggerFactory.getLogger(WeChatPay.class);
    private final WeChatPayConfig config;
    private final WeChatPayHttpClient http;

    public WeChatPay(WeChatPayConfig config, WeChatMPEventHandler eventHandler, WeChatPayHttpClient http) {
        this.config = config;
        this.http = http;
        if (null != eventHandler) {
            eventHandler.setWeChatPay(this);
        }
    }

    public WeChatPayRequestData makeJSAPIPayment(int timestamp, String nonce, String prepayId) {
        WeChatPayRequestData request = new WeChatPayRequestData();
        request.setString("appId", this.config.getAppId());
        request.setString("timeStamp", String.valueOf(timestamp));
        request.setString("nonceStr", nonce);
        request.setString("package", "prepay_id=" + prepayId);
        request.setString("signType", "MD5");
        return request;
    }

    public String signJSAPIPayment(WeChatPayRequestData request) {
        return this.signMD5(request.getSortedParameters());
    }

    public boolean verifyJSAPIResponse(WeChatPayResponseData response) {
        if (!"SUCCESS".equalsIgnoreCase(response.getString("return_code"))) {
            return false;
        }
        if (!"SUCCESS".equalsIgnoreCase(response.getString("result_code"))) {
            return false;
        }
        String signFromResponse = response.getString("sign");
        String sign = this.signMD5(response.getSortedParameters("sign"));
        return sign.equalsIgnoreCase(signFromResponse);
    }

    public String signRaiseAppRequest(WeChatPayRequestData request) {
        return this.signMD5(request.getSortedParameters());
    }

    private WeChatPayRequestData makeOrder(String tradeNo, String name, double fee, String ip, String notify) {
        WeChatPayRequestData request = new WeChatPayRequestData();
        request.setString("appid", this.config.getAppId());
        request.setString("mch_id", this.config.getMchId());
        request.setString("nonce_str", WeChatUtils.nonce());
        request.setString("out_trade_no", tradeNo);
        request.setString("spbill_create_ip", ip);
        request.setString("total_fee", String.valueOf((int)(fee * 100.0)));
        request.setString("body", name);
        request.setString("notify_url", notify);
        return request;
    }

    public WeChatPayRequestData makeOrderJSAPI(String tradeNo, String name, double fee, String ip, String notify, String openId) {
        WeChatPayRequestData request = this.makeOrder(tradeNo, name, fee, ip, notify);
        request.setString("trade_type", "JSAPI");
        request.setString("openid", openId);
        return request;
    }

    public WeChatPayRequestData makeOrderNATIVE(String tradeNo, String name, double fee, String ip, String notify, String productId) {
        WeChatPayRequestData request = this.makeOrder(tradeNo, name, fee, ip, notify);
        request.setString("trade_type", "NATIVE");
        request.setString("product_id", productId);
        return request;
    }

    public WeChatPayRequestData makeOrderAPP(String tradeNo, String name, double fee, String ip, String notify) {
        WeChatPayRequestData request = this.makeOrder(tradeNo, name, fee, ip, notify);
        request.setString("trade_type", "APP");
        return request;
    }

    public WeChatPayRequestData makeRaiseAppRequest(String prepayId) {
        WeChatPayRequestData request = new WeChatPayRequestData();
        request.setString("appid", this.config.getAppId());
        request.setString("partnerid", this.config.getMchId());
        request.setString("prepayid", prepayId);
        request.setString("package", "Sign=WXPay");
        request.setString("noncestr", WeChatUtils.nonce());
        request.setString("timestamp", String.valueOf(WeChatUtils.now()));
        return request;
    }

    public String placeOrder(WeChatPayRequestData request) {
        OneLevelOnlyXML xml = new OneLevelOnlyXML();
        xml.createRootElement("xml");
        for (StringPair param : this.sign(request.getSortedParameters())) {
            xml.createChild(param.getFirst(), param.getSecond());
        }
        String str = xml.toXMLString();
        LOG.info("Order request: {}", (Object)str);
        String ret = this.http.post("api.mch.weixin.qq.com", 443, "https", "/pay/unifiedorder", str);
        LOG.info("Order response: {}", (Object)ret);
        try {
            WeChatPayResponseData response = WeChatPayResponseData.parse(ret);
            String sign = this.signMD5(response.getAllData().getSorted("sign"));
            if (!sign.equalsIgnoreCase(response.getString("sign"))) {
                LOG.warn("Failed to verify sign");
                return null;
            }
            if (!"SUCCESS".equalsIgnoreCase(response.getString("return_code")) || !"SUCCESS".equalsIgnoreCase(response.getString("result_code"))) {
                LOG.warn("Error returned {}", (Object)response.getString("return_msg"));
                return null;
            }
            return response.getString("prepay_id");
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn("Cannot parse result", (Throwable)e);
            return null;
        }
        catch (ParserConfigurationException e) {
            LOG.warn("Cannot parse result", (Throwable)e);
            return null;
        }
        catch (SAXException e) {
            LOG.warn("Cannot parse result", (Throwable)e);
            return null;
        }
        catch (IOException e) {
            LOG.warn("Cannot parse result", (Throwable)e);
            return null;
        }
    }

    private List<StringPair> sign(List<StringPair> p) {
        String sign = this.signMD5(p);
        p.add(new StringPair("sign", sign));
        return p;
    }

    private String signMD5(List<StringPair> p) {
        String param = this.join(p, false) + "&key=" + this.config.getPayKey();
        String sign = WeChatUtils.md5HEX(param);
        LOG.trace("Signing {}={}", (Object)param, (Object)sign);
        return sign;
    }

    protected String join(List<StringPair> p, boolean encode) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < p.size(); ++i) {
            if (i != 0) {
                buff.append("&");
            }
            buff.append(p.get(i).getFirst()).append("=");
            if (encode) {
                try {
                    buff.append(URLEncoder.encode(p.get(i).getSecond(), "utf-8"));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    LOG.warn("Cannot encode {}", (Object)p.get(i).getSecond());
                    throw new WeChatException(e);
                }
            }
            buff.append(p.get(i).getSecond());
        }
        return buff.toString();
    }
}

