/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.api.sharedpreferences;

import android.content.SharedPreferences;
import org.androidannotations.api.sharedpreferences.AbstractPrefField;

public final class LongPrefField
extends AbstractPrefField {
    private final long defaultValue;

    LongPrefField(SharedPreferences sharedPreferences, String key, long defaultValue) {
        super(sharedPreferences, key);
        this.defaultValue = defaultValue;
    }

    public long get() {
        return this.getOr(this.defaultValue);
    }

    public long getOr(long defaultValue) {
        try {
            return this.sharedPreferences.getLong(this.key, defaultValue);
        }
        catch (ClassCastException e) {
            try {
                String value = this.sharedPreferences.getString(this.key, "" + defaultValue);
                return Long.parseLong(value);
            }
            catch (Exception e2) {
                throw e;
            }
        }
    }

    public void put(long value) {
        this.apply(this.edit().putLong(this.key, value));
    }
}

