/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.v2.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

public class NullableJsonElementTypeAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (JsonElement.class.isAssignableFrom(type.getRawType())) {
            TypeAdapter delegateAdapter = gson.getAdapter(JsonElement.class);
            NullableJsonElementTypeAdapter adapter = new NullableJsonElementTypeAdapter((TypeAdapter<JsonElement>)delegateAdapter);
            return adapter;
        }
        return null;
    }

    private static class NullableJsonElementTypeAdapter
    extends TypeAdapter<JsonElement> {
        private final TypeAdapter<JsonElement> delegate;

        public NullableJsonElementTypeAdapter(TypeAdapter<JsonElement> delegate) {
            this.delegate = delegate;
        }

        public void write(JsonWriter out, JsonElement value) throws IOException {
            this.delegate.write(out, (Object)value);
        }

        public JsonElement read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                return null;
            }
            return (JsonElement)this.delegate.read(in);
        }
    }
}

