/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.file;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ListIterator;
import org.apache.commons.lang.StringUtils;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelativePath {
    private final boolean endsWithFile;
    private final String[] segments;

    public RelativePath(boolean endsWithFile, String ... segments) {
        this(endsWithFile, (RelativePath)null, segments);
    }

    private RelativePath(boolean endsWithFile, RelativePath parentPath, String ... childSegments) {
        this.endsWithFile = endsWithFile;
        int sourceLength = 0;
        if (parentPath != null) {
            String[] sourceSegments = parentPath.getSegments();
            sourceLength = sourceSegments.length;
            this.segments = new String[sourceLength + childSegments.length];
            System.arraycopy(sourceSegments, 0, this.segments, 0, sourceLength);
        } else {
            this.segments = new String[childSegments.length];
        }
        System.arraycopy(childSegments, 0, this.segments, sourceLength, childSegments.length);
    }

    public String[] getSegments() {
        return this.segments;
    }

    public ListIterator<String> segmentIterator() {
        ArrayList<String> content = new ArrayList<String>(Arrays.asList(this.segments));
        return content.listIterator();
    }

    public boolean isFile() {
        return this.endsWithFile;
    }

    public String getPathString() {
        return GUtil.join(this.segments, "/");
    }

    public File getFile(File baseDir) {
        return new File(baseDir, this.getPathString());
    }

    public String getLastName() {
        if (this.segments.length > 0) {
            return this.segments[this.segments.length - 1];
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelativePath that = (RelativePath)o;
        if (this.endsWithFile != that.endsWithFile) {
            return false;
        }
        return Arrays.equals(this.segments, that.segments);
    }

    public int hashCode() {
        int result = this.endsWithFile ? 1 : 0;
        result = 31 * result + Arrays.hashCode(this.segments);
        return result;
    }

    public String toString() {
        return this.getPathString();
    }

    public RelativePath getParent() {
        if (this.segments.length == 0) {
            return null;
        }
        String[] parentSegments = new String[this.segments.length - 1];
        System.arraycopy(this.segments, 0, parentSegments, 0, parentSegments.length);
        return new RelativePath(false, parentSegments);
    }

    public static RelativePath parse(boolean isFile, String path) {
        return RelativePath.parse(isFile, null, path);
    }

    public static RelativePath parse(boolean isFile, RelativePath parent, String path) {
        String[] names = StringUtils.split((String)path, (String)("/" + File.separator));
        return new RelativePath(isFile, parent, names);
    }

    public RelativePath replaceLastName(String name) {
        String[] newSegments = new String[this.segments.length];
        System.arraycopy(this.segments, 0, newSegments, 0, this.segments.length);
        newSegments[this.segments.length - 1] = name;
        return new RelativePath(this.endsWithFile, newSegments);
    }

    public RelativePath append(RelativePath other) {
        return new RelativePath(other.endsWithFile, this, other.segments);
    }

    public RelativePath plus(RelativePath other) {
        return this.append(other);
    }

    public RelativePath append(boolean endsWithFile, String ... segments) {
        return new RelativePath(endsWithFile, this, segments);
    }

    public RelativePath prepend(String ... segments) {
        return new RelativePath(false, segments).append(this);
    }
}

