/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.GroovyObject;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovySystem;
import groovy.lang.MetaBeanProperty;
import groovy.lang.MetaClass;
import groovy.lang.MetaProperty;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.ReadOnlyPropertyException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.gradle.api.internal.AbstractDynamicObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDynamicObject
extends AbstractDynamicObject {
    private final Object bean;
    private final boolean includeProperties;

    public BeanDynamicObject(Object bean) {
        this.bean = bean;
        this.includeProperties = true;
    }

    private BeanDynamicObject(Object bean, boolean includeProperties) {
        this.bean = bean;
        this.includeProperties = includeProperties;
    }

    public BeanDynamicObject withNoProperties() {
        return new BeanDynamicObject(this.bean, false);
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    protected String getDisplayName() {
        return this.bean.toString();
    }

    private MetaClass getMetaClass() {
        if (this.bean instanceof GroovyObject) {
            return ((GroovyObject)this.bean).getMetaClass();
        }
        return GroovySystem.getMetaClassRegistry().getMetaClass(this.bean.getClass());
    }

    @Override
    public boolean hasProperty(String name) {
        return this.includeProperties && this.getMetaClass().hasProperty(this.bean, name) != null;
    }

    @Override
    public Object getProperty(String name) throws MissingPropertyException {
        if (!this.includeProperties) {
            throw this.propertyMissingException(name);
        }
        MetaProperty property = this.getMetaClass().hasProperty(this.bean, name);
        if (property == null) {
            throw this.propertyMissingException(name);
        }
        if (property instanceof MetaBeanProperty && ((MetaBeanProperty)property).getGetter() == null) {
            throw new GroovyRuntimeException(String.format("Cannot get the value of write-only property '%s' on %s.", name, this.getDisplayName()));
        }
        try {
            return property.getProperty(this.bean);
        }
        catch (InvokerInvocationException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void setProperty(final String name, Object value) throws MissingPropertyException {
        if (!this.includeProperties) {
            throw this.propertyMissingException(name);
        }
        MetaClass metaClass = this.getMetaClass();
        MetaProperty property = metaClass.hasProperty(this.bean, name);
        if (property == null) {
            throw this.propertyMissingException(name);
        }
        if (property instanceof MetaBeanProperty && ((MetaBeanProperty)property).getSetter() == null) {
            throw new ReadOnlyPropertyException(name, this.bean.getClass()){

                public String getMessage() {
                    return String.format("Cannot set the value of read-only property '%s' on %s.", name, BeanDynamicObject.this.getDisplayName());
                }
            };
        }
        try {
            metaClass.setProperty(this.bean, name, value);
        }
        catch (InvokerInvocationException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw e;
        }
    }

    public Map<String, Object> getProperties() {
        if (!this.includeProperties) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        List classProperties = this.getMetaClass().getProperties();
        for (MetaProperty metaProperty : classProperties) {
            MetaBeanProperty beanProperty;
            if (metaProperty.getName().equals("properties")) {
                properties.put("properties", properties);
                continue;
            }
            if (metaProperty instanceof MetaBeanProperty && (beanProperty = (MetaBeanProperty)metaProperty).getGetter() == null) continue;
            properties.put(metaProperty.getName(), metaProperty.getProperty(this.bean));
        }
        return properties;
    }

    @Override
    public boolean hasMethod(String name, Object ... arguments) {
        return !this.getMetaClass().respondsTo(this.bean, name, arguments).isEmpty();
    }

    @Override
    public Object invokeMethod(String name, Object ... arguments) throws MissingMethodException {
        try {
            return this.getMetaClass().invokeMethod(this.bean, name, arguments);
        }
        catch (InvokerInvocationException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw e;
        }
        catch (MissingMethodException e) {
            throw this.methodMissingException(name, arguments);
        }
    }
}

