/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import java.io.File;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.resolve.DownloadOptions;
import org.apache.ivy.core.resolve.ResolveEngine;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;

public class DefaultResolvedArtifact
implements ResolvedArtifact {
    private ResolvedDependency resolvedDependency;
    private Artifact artifact;
    private ResolveEngine resolvedEngine;
    private File file;

    public DefaultResolvedArtifact(Artifact artifact, ResolveEngine resolvedEngine) {
        this.artifact = artifact;
        this.resolvedEngine = resolvedEngine;
    }

    public ResolvedDependency getResolvedDependency() {
        return this.resolvedDependency;
    }

    public void setResolvedDependency(ResolvedDependency resolvedDependency) {
        this.resolvedDependency = resolvedDependency;
    }

    public String toString() {
        return String.format("%s;%s", this.resolvedDependency, this.artifact.getName());
    }

    public String getName() {
        return this.artifact.getName();
    }

    public String getType() {
        return this.artifact.getType();
    }

    public String getExtension() {
        return this.artifact.getExt();
    }

    public String getVersion() {
        return this.getResolvedDependency() == null ? null : this.getResolvedDependency().getModuleVersion();
    }

    public String getDependencyName() {
        return this.getResolvedDependency() == null ? null : this.getResolvedDependency().getModuleName();
    }

    public File getFile() {
        if (this.file == null) {
            this.file = this.resolvedEngine.download(this.artifact, new DownloadOptions()).getLocalFile();
        }
        return this.file;
    }
}

