/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.internal.artifacts.ResolvedConfigurationIdentifier;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResolvedDependency
implements ResolvedDependency {
    private Set<ResolvedDependency> children = new LinkedHashSet<ResolvedDependency>();
    private Set<ResolvedDependency> parents = new LinkedHashSet<ResolvedDependency>();
    private Map<ResolvedDependency, Set<ResolvedArtifact>> parentArtifacts = new LinkedHashMap<ResolvedDependency, Set<ResolvedArtifact>>();
    private String name;
    private final ResolvedConfigurationIdentifier id;
    private Set<ResolvedArtifact> moduleArtifacts = new LinkedHashSet<ResolvedArtifact>();
    private Map<ResolvedDependency, Set<ResolvedArtifact>> allArtifactsCache = new HashMap<ResolvedDependency, Set<ResolvedArtifact>>();
    private Set<ResolvedArtifact> allModuleArtifactsCache;

    public DefaultResolvedDependency(String name, String moduleGroup, String moduleName, String moduleVersion, String configuration, Set<ResolvedArtifact> moduleArtifacts) {
        assert (name != null);
        assert (moduleArtifacts != null);
        this.name = name;
        this.id = new ResolvedConfigurationIdentifier(moduleGroup, moduleName, moduleVersion, configuration);
        this.moduleArtifacts = moduleArtifacts;
    }

    public DefaultResolvedDependency(String moduleGroup, String moduleName, String moduleVersion, String configuration, Set<ResolvedArtifact> moduleArtifacts) {
        this(moduleGroup + ":" + moduleName + ":" + moduleVersion, moduleGroup, moduleName, moduleVersion, configuration, moduleArtifacts);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ResolvedConfigurationIdentifier getId() {
        return this.id;
    }

    @Override
    public String getModuleGroup() {
        return this.id.getModuleGroup();
    }

    @Override
    public String getModuleName() {
        return this.id.getModuleName();
    }

    @Override
    public String getModuleVersion() {
        return this.id.getModuleVersion();
    }

    @Override
    public String getConfiguration() {
        return this.id.getConfiguration();
    }

    @Override
    public Set<ResolvedDependency> getChildren() {
        return this.children;
    }

    @Override
    public Set<ResolvedArtifact> getModuleArtifacts() {
        return this.moduleArtifacts;
    }

    @Override
    public Set<ResolvedArtifact> getAllModuleArtifacts() {
        if (this.allModuleArtifactsCache == null) {
            LinkedHashSet<ResolvedArtifact> allArtifacts = new LinkedHashSet<ResolvedArtifact>();
            allArtifacts.addAll(this.getModuleArtifacts());
            for (ResolvedDependency childResolvedDependency : this.getChildren()) {
                allArtifacts.addAll(childResolvedDependency.getAllModuleArtifacts());
            }
            this.allModuleArtifactsCache = allArtifacts;
        }
        return this.allModuleArtifactsCache;
    }

    @Override
    public Set<ResolvedArtifact> getParentArtifacts(ResolvedDependency parent) {
        if (!this.parents.contains(parent)) {
            throw new InvalidUserDataException("Unknown Parent");
        }
        Set<ResolvedArtifact> artifacts = this.parentArtifacts.get(parent);
        return artifacts == null ? Collections.emptySet() : artifacts;
    }

    @Override
    public Set<ResolvedArtifact> getArtifacts(ResolvedDependency parent) {
        return GUtil.addSets(this.getParentArtifacts(parent), this.getModuleArtifacts());
    }

    @Override
    public Set<ResolvedArtifact> getAllArtifacts(ResolvedDependency parent) {
        if (this.allArtifactsCache.get(parent) == null) {
            LinkedHashSet<ResolvedArtifact> allArtifacts = new LinkedHashSet<ResolvedArtifact>();
            allArtifacts.addAll(this.getArtifacts(parent));
            for (ResolvedDependency childResolvedDependency : this.getChildren()) {
                for (ResolvedDependency childParent : childResolvedDependency.getParents()) {
                    allArtifacts.addAll(childResolvedDependency.getAllArtifacts(childParent));
                }
            }
            this.allArtifactsCache.put(parent, allArtifacts);
        }
        return this.allArtifactsCache.get(parent);
    }

    @Override
    public Set<ResolvedDependency> getParents() {
        return this.parents;
    }

    public String toString() {
        return this.name + ";" + this.getConfiguration();
    }

    public void addParentSpecificArtifacts(ResolvedDependency parent, Set<ResolvedArtifact> artifacts) {
        this.parentArtifacts.put(parent, artifacts);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultResolvedDependency that = (DefaultResolvedDependency)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public void addChild(DefaultResolvedDependency child) {
        this.children.add(child);
        child.parents.add(this);
    }
}

